/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.lifecycle;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.FunctionCallIDRange;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.IAssetItemWithChildren;
import com.arm.mgd.lightweight.asset.IAssetItemWithParent;
import com.arm.mgd.lightweight.asset.lifecycle.AbstractAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManagerCallbacks;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemValueWithAssetValue;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ReferenceCountedAssetLifecycleManager<ASSET_TYPE extends IAssetItem<?, ? extends IAssetItem.Value<? extends ASSET_TYPE>>>
extends AbstractAssetLifecycleManager<ASSET_TYPE> {
    protected final @NonNull Object mutex = new Object();
    private @NonNull FunctionCallIDRange assetAvailableBounds;
    private boolean deletedByMidstreamTrace;
    private @NonNull ReferenceCountEntry referenceCountState;
    private @Nullable FunctionCall releasingFunction;
    private final @NonNull List<@NonNull IAssetItem<?, ?>> retainingAssets = new ArrayList();

    public ReferenceCountedAssetLifecycleManager(@NonNull ASSET_TYPE asset, @NonNull IAssetItemLifecycleManagerCallbacks callbacks, boolean retainableFlag) {
        super(asset, callbacks);
        assert (retainableFlag);
        this.referenceCountState = new ReferenceCountEntry(asset.getCreatingFunction());
        this.assetAvailableBounds = new FunctionCallIDRange(asset.getCreatingFunction().getID());
        if (asset instanceof IAssetItemWithParent) {
            ((IAssetItemWithChildren)((IAssetItemWithParent)asset).getParentAsset()).getLifecycleManager().trackRetainedByAssetItem(asset.getCreatingFunction(), asset);
        }
    }

    @Override
    public void delete(@NonNull FunctionCall deletingFunction) {
        throw new UnsupportedOperationException("Cannot manually retain DYNAMIC_UNBIND_WHEN_NO_LONGER_REFERENCED assets");
    }

    @Override
    public @NonNull FunctionCallIDRange getAssetLiveBounds() {
        return this.assetAvailableBounds;
    }

    @Override
    public @NonNull FunctionCallIDRange getAssetRetainedBounds() {
        return this.assetAvailableBounds;
    }

    @Override
    public @NonNull FunctionCall getReleasingFunction() {
        if (this.releasingFunction == null) {
            throw new IllegalStateException();
        }
        return (FunctionCall)NullUtils.neverNull((Object)this.releasingFunction);
    }

    @Override
    public boolean isAssetLive(@NonNull FunctionCallID at) {
        return this.assetAvailableBounds.contains(at);
    }

    @Override
    public boolean isAssetRetained(@NonNull FunctionCallID at) {
        return this.assetAvailableBounds.contains(at);
    }

    @Override
    public boolean isDeleted() {
        return this.assetAvailableBounds.isClosedRange();
    }

    @Override
    public boolean isReleased() {
        return this.assetAvailableBounds.isClosedRange();
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public void release(@NonNull FunctionCall functionCall) {
        this.retainOrRelease(functionCall, false);
    }

    @Override
    public void retain(@NonNull FunctionCall functionCall) {
        this.retainOrRelease(functionCall, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsNotRetainedByMidstreamAttachment(@NonNull FunctionCall functionCall) {
        if (functionCall.getID().compareTo(this.asset.getCreatingFunction().getID()) >= 0) {
            Object object = this.mutex;
            synchronized (object) {
                ReferenceCountEntry newEntry;
                if (this.isReleased()) {
                    return;
                }
                this.asset.addFunctionCall(functionCall);
                this.deletedByMidstreamTrace = true;
                this.referenceCountState = newEntry = ReferenceCountEntry.deletedByMidstreamTrace(functionCall);
                assert (!this.assetAvailableBounds.isClosedRange());
                this.assetAvailableBounds = new FunctionCallIDRange(this.assetAvailableBounds.getFrom(), functionCall.getID());
                this.releasingFunction = functionCall;
            }
            this.onRelease(functionCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <THAT_ASSET extends IAssetItem<?, ?>> void trackReleasedFromAssetItem(@NonNull FunctionCall functionCall, @NonNull THAT_ASSET assetItem) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.retainingAssets.remove(assetItem)) {
                throw new UnsupportedOperationException("Releasing asset that is not retained");
            }
            this.retainOrRelease(functionCall, false);
        }
    }

    @Override
    public <T extends IStateItem<? extends IStateItemValueWithAssetValue<? super ASSET_TYPE, ?>>> void trackReleasedFromStateItem(@NonNull FunctionCall functionCall, @NonNull T stateItem) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <THAT_ASSET extends IAssetItem<?, ?>> void trackRetainedByAssetItem(@NonNull FunctionCall functionCall, @NonNull THAT_ASSET assetItem) {
        Object object = this.mutex;
        synchronized (object) {
            this.retainingAssets.add(assetItem);
            this.retainOrRelease(functionCall, true);
        }
    }

    @Override
    public <T extends IStateItem<? extends IStateItemValueWithAssetValue<? super ASSET_TYPE, ?>>> void trackRetainedByStateItem(@NonNull FunctionCall functionCall, @NonNull T stateItem) {
    }

    protected boolean isDeletedByMidstreamTrace() {
        return this.deletedByMidstreamTrace;
    }

    protected void onRelease(@NonNull FunctionCall functionCall) {
        assert (this.retainingAssets.isEmpty() || this.deletedByMidstreamTrace);
        this.unbindAllHeldReferences(functionCall);
        if (this.asset instanceof IAssetItemWithParent) {
            ((IAssetItemWithChildren)((IAssetItemWithParent)this.asset).getParentAsset()).getLifecycleManager().trackReleasedFromAssetItem(functionCall, this.asset);
        }
        this.callbacks.setDeleted(functionCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void retainOrRelease(@NonNull FunctionCall functionCall, boolean retain) {
        if (!this.deletedByMidstreamTrace) {
            boolean callOnRelease = false;
            Object object = this.mutex;
            synchronized (object) {
                ReferenceCountEntry newEntry;
                this.referenceCountState = newEntry = new ReferenceCountEntry(this.referenceCountState, functionCall, retain);
                if (newEntry.referenceCount < 1) {
                    assert (!this.assetAvailableBounds.isClosedRange());
                    this.assetAvailableBounds = new FunctionCallIDRange(this.assetAvailableBounds.getFrom(), functionCall.getID());
                    this.releasingFunction = functionCall;
                    callOnRelease = true;
                }
            }
            if (callOnRelease) {
                this.onRelease(functionCall);
            }
        }
    }

    private static final class ReferenceCountEntry {
        public final @NonNull FunctionCall functionCall;
        public final int referenceCount;

        public static @NonNull ReferenceCountEntry deletedByMidstreamTrace(@NonNull FunctionCall functionCall) {
            return new ReferenceCountEntry(functionCall, 0);
        }

        public ReferenceCountEntry(@NonNull FunctionCall functionCall) {
            this(functionCall, 1);
        }

        public ReferenceCountEntry(@NonNull ReferenceCountEntry previousEntry, @NonNull FunctionCall functionCall, boolean retain) {
            this(functionCall, previousEntry.referenceCount + (retain ? 1 : -1));
            assert (previousEntry.functionCall.compareTo(functionCall) <= 0) : previousEntry.functionCall.getID() + " vs " + functionCall.getID();
            assert (previousEntry.referenceCount > 0);
        }

        private ReferenceCountEntry(@NonNull FunctionCall functionCall, int referenceCount) {
            this.functionCall = functionCall;
            this.referenceCount = referenceCount;
        }
    }
}

