/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.lifecycle;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.FunctionCallIDRange;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.lifecycle.AbstractAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManagerCallbacks;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemValueWithAssetValue;
import com.arm.mgd.lightweight.state.internal.AbstractAssetStateItem;
import com.arm.mgd.utils.NullUtils;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DeletableAssetLifecycleManager<ASSET_TYPE extends IAssetItem<?, ? extends IAssetItem.Value<? extends ASSET_TYPE>>>
extends AbstractAssetLifecycleManager<ASSET_TYPE> {
    private @NonNull FunctionCallIDRange assetAvailableBounds;
    private final @NonNull Set<AbstractAssetStateItem<@NonNull ?>> boundStateItems;
    private @Nullable FunctionCall deletingFunction;

    public DeletableAssetLifecycleManager(@NonNull ASSET_TYPE asset, @NonNull IAssetItemLifecycleManagerCallbacks callbacks, boolean retainableFlag) {
        super(asset, callbacks);
        assert (!retainableFlag);
        this.assetAvailableBounds = new FunctionCallIDRange(asset.getCreatingFunction().getID());
        this.boundStateItems = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NonNull FunctionCall deletingFunction) {
        Object object = this.assetAvailableBounds;
        synchronized (object) {
            assert (!this.assetAvailableBounds.isClosedRange() || ((FunctionCallID)NullUtils.neverNull((Object)this.assetAvailableBounds.getTo())).equals(deletingFunction.getID())) : "Double deletion for as " + this.asset + ", prev = " + this.deletingFunction + " @ " + this.assetAvailableBounds.getTo() + ", this = " + deletingFunction + " @ " + deletingFunction.getID();
            this.assetAvailableBounds = new FunctionCallIDRange(this.assetAvailableBounds.getFrom(), deletingFunction.getID());
            this.deletingFunction = deletingFunction;
        }
        this.unbindAllHeldReferences(deletingFunction);
        object = this.boundStateItems;
        synchronized (object) {
            for (AbstractAssetStateItem<?> stateItem : this.boundStateItems) {
                stateItem.setBoundAssetDeleted(deletingFunction);
            }
            this.boundStateItems.clear();
        }
        this.callbacks.setDeleted(deletingFunction);
    }

    @Override
    public @NonNull FunctionCallIDRange getAssetLiveBounds() {
        return this.assetAvailableBounds;
    }

    @Override
    public @NonNull FunctionCallIDRange getAssetRetainedBounds() {
        return this.getAssetLiveBounds();
    }

    @Override
    public @NonNull FunctionCall getReleasingFunction() {
        if (this.deletingFunction == null) {
            throw new IllegalStateException();
        }
        return (FunctionCall)NullUtils.neverNull((Object)this.deletingFunction);
    }

    @Override
    public boolean isAssetLive(@NonNull FunctionCallID at) {
        return this.assetAvailableBounds.contains(at);
    }

    @Override
    public boolean isAssetRetained(@NonNull FunctionCallID at) {
        return this.isAssetLive(at);
    }

    @Override
    public boolean isDeleted() {
        return this.assetAvailableBounds.isClosedRange();
    }

    @Override
    public boolean isReleased() {
        return this.isDeleted();
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public void release(@NonNull FunctionCall releasingFunction) {
        throw new UnsupportedOperationException("Cannot manually release DYNAMIC_UNBIND_IMMEDIATELY assets");
    }

    @Override
    public void retain(@NonNull FunctionCall functionCall) {
        throw new UnsupportedOperationException("Cannot manually retain DYNAMIC_UNBIND_IMMEDIATELY assets");
    }

    @Override
    public void setIsNotRetainedByMidstreamAttachment(@NonNull FunctionCall functionCall) {
        if (!this.isDeleted() && functionCall.getID().compareTo(this.asset.getCreatingFunction().getID()) >= 0) {
            this.asset.addFunctionCall(functionCall);
            this.delete(functionCall);
        }
    }

    @Override
    public <THAT_ASSET extends IAssetItem<?, ?>> void trackReleasedFromAssetItem(@NonNull FunctionCall functionCall, @NonNull THAT_ASSET assetItem) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IStateItem<? extends IStateItemValueWithAssetValue<? super ASSET_TYPE, ?>>> void trackReleasedFromStateItem(@NonNull FunctionCall functionCall, @NonNull T stateItem) {
        if (stateItem instanceof AbstractAssetStateItem) {
            Set<AbstractAssetStateItem<?>> set = this.boundStateItems;
            synchronized (set) {
                this.boundStateItems.remove(stateItem);
            }
        }
    }

    @Override
    public <THAT_ASSET extends IAssetItem<?, ?>> void trackRetainedByAssetItem(@NonNull FunctionCall functionCall, @NonNull THAT_ASSET assetItem) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IStateItem<? extends IStateItemValueWithAssetValue<? super ASSET_TYPE, ?>>> void trackRetainedByStateItem(@NonNull FunctionCall functionCall, @NonNull T stateItem) {
        assert (!this.isDeleted());
        if (stateItem instanceof AbstractAssetStateItem) {
            Set<AbstractAssetStateItem<?>> set = this.boundStateItems;
            synchronized (set) {
                this.boundStateItems.add((AbstractAssetStateItem)stateItem);
            }
        }
    }
}

