/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.lifecycle;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.FunctionCallIDRange;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.lifecycle.AbstractAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManagerCallbacks;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemValueWithAssetValue;
import org.eclipse.jdt.annotation.NonNull;

public class DefaultObjectLifecycleManager<ASSET_TYPE extends IAssetItem<?, ? extends IAssetItem.Value<? extends ASSET_TYPE>>>
extends AbstractAssetLifecycleManager<ASSET_TYPE> {
    private final @NonNull FunctionCallIDRange assetAvailableBounds;

    public DefaultObjectLifecycleManager(@NonNull ASSET_TYPE asset, @NonNull IAssetItemLifecycleManagerCallbacks callbacks) {
        super(asset, callbacks);
        this.assetAvailableBounds = new FunctionCallIDRange(asset.getCreatingFunction().getID());
    }

    @Override
    public void delete(@NonNull FunctionCall deletingFunction) {
    }

    @Override
    public @NonNull FunctionCallIDRange getAssetLiveBounds() {
        return this.assetAvailableBounds;
    }

    @Override
    public @NonNull FunctionCallIDRange getAssetRetainedBounds() {
        return this.getAssetLiveBounds();
    }

    @Override
    public @NonNull FunctionCall getReleasingFunction() {
        throw new IllegalStateException();
    }

    @Override
    public boolean isAssetLive(@NonNull FunctionCallID at) {
        return this.assetAvailableBounds.contains(at);
    }

    @Override
    public boolean isAssetRetained(@NonNull FunctionCallID at) {
        return this.isAssetLive(at);
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public boolean isReleased() {
        return this.isDeleted();
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public void release(@NonNull FunctionCall deletingFunction) {
    }

    @Override
    public void retain(@NonNull FunctionCall functionCall) {
    }

    @Override
    public void setIsNotRetainedByMidstreamAttachment(@NonNull FunctionCall functionCall) {
    }

    @Override
    public <THAT_ASSET extends IAssetItem<?, ?>> void trackReleasedFromAssetItem(@NonNull FunctionCall functionCall, @NonNull THAT_ASSET assetItem) {
    }

    @Override
    public <T extends IStateItem<? extends IStateItemValueWithAssetValue<? super ASSET_TYPE, ?>>> void trackReleasedFromStateItem(@NonNull FunctionCall functionCall, @NonNull T stateItem) {
    }

    @Override
    public <THAT_ASSET extends IAssetItem<?, ?>> void trackRetainedByAssetItem(@NonNull FunctionCall functionCall, @NonNull THAT_ASSET assetItem) {
    }

    @Override
    public <T extends IStateItem<? extends IStateItemValueWithAssetValue<? super ASSET_TYPE, ?>>> void trackRetainedByStateItem(@NonNull FunctionCall functionCall, @NonNull T stateItem) {
    }
}

