/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.lifecycle;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.FunctionCallIDRange;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManagerCallbacks;
import com.arm.mgd.lightweight.asset.lifecycle.ReferenceCountedAssetLifecycleManager;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemValueWithAssetValue;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class AutoRetainedAssetLifecycleManager<ASSET_TYPE extends IAssetItem<?, ? extends IAssetItem.Value<? extends ASSET_TYPE>>>
extends ReferenceCountedAssetLifecycleManager<ASSET_TYPE> {
    private @NonNull FunctionCallIDRange assetLiveBounds;
    private final @NonNull List<@NonNull IStateItem<?>> retainingStates = new ArrayList();
    private final boolean retainableFlag;
    private int retentionCounter = 0;
    private int retentionCounterIndex = -1;

    public AutoRetainedAssetLifecycleManager(@NonNull ASSET_TYPE asset, @NonNull IAssetItemLifecycleManagerCallbacks callbacks, boolean retainableFlag) {
        super(asset, callbacks, true);
        this.retainableFlag = retainableFlag;
        this.assetLiveBounds = new FunctionCallIDRange(asset.getCreatingFunction().getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NonNull FunctionCall functionCall) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.retainableFlag) {
                assert (this.retentionCounterIndex < functionCall.getIndex());
                --this.retentionCounter;
                this.retentionCounterIndex = functionCall.getIndex();
                if (this.retentionCounter > 0) {
                    return;
                }
            }
            assert (!this.assetLiveBounds.isClosedRange() || ((FunctionCallID)NullUtils.neverNull((Object)this.assetLiveBounds.getTo())).equals(functionCall.getID())) : "Double deletion for as " + this.asset + ", prev = " + this.assetLiveBounds.getTo() + ", this = " + functionCall + " @ " + functionCall.getID();
            this.assetLiveBounds = new FunctionCallIDRange(this.assetLiveBounds.getFrom(), functionCall.getID());
            this.callbacks.setDeleteRequested(functionCall);
            this.retainOrRelease(functionCall, false);
        }
    }

    @Override
    public @NonNull FunctionCallIDRange getAssetLiveBounds() {
        return this.assetLiveBounds;
    }

    @Override
    public boolean isAssetLive(@NonNull FunctionCallID at) {
        return this.assetLiveBounds.contains(at);
    }

    @Override
    public boolean isDeleted() {
        return this.assetLiveBounds.isClosedRange();
    }

    @Override
    public void release(@NonNull FunctionCall deletingFunction) {
        throw new UnsupportedOperationException("Cannot manually release DYNAMIC_UNBIND_WHEN_NO_LONGER_REFERENCED assets");
    }

    @Override
    public void retain(@NonNull FunctionCall functionCall) {
        if (this.retainableFlag) {
            assert (this.retentionCounterIndex < functionCall.getIndex());
            ++this.retentionCounter;
        } else {
            throw new UnsupportedOperationException("Cannot manually retain DYNAMIC_UNBIND_WHEN_NO_LONGER_REFERENCED assets");
        }
        this.retentionCounterIndex = functionCall.getIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsNotRetainedByMidstreamAttachment(@NonNull FunctionCall functionCall) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isDeleted() && functionCall.getID().compareTo(this.asset.getCreatingFunction().getID()) >= 0) {
                this.delete(functionCall);
            }
            super.setIsNotRetainedByMidstreamAttachment(functionCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IStateItem<? extends IStateItemValueWithAssetValue<? super ASSET_TYPE, ?>>> void trackReleasedFromStateItem(@NonNull FunctionCall functionCall, @NonNull T stateItem) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.retainingStates.remove(stateItem)) {
                throw new UnsupportedOperationException("Releasing state that is not retained");
            }
            this.retainOrRelease(functionCall, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IStateItem<? extends IStateItemValueWithAssetValue<? super ASSET_TYPE, ?>>> void trackRetainedByStateItem(@NonNull FunctionCall functionCall, @NonNull T stateItem) {
        Object object = this.mutex;
        synchronized (object) {
            this.retainingStates.add(stateItem);
            this.retainOrRelease(functionCall, true);
        }
    }

    @Override
    protected void onRelease(@NonNull FunctionCall functionCall) {
        assert (this.retainingStates.isEmpty() || this.isDeletedByMidstreamTrace());
        super.onRelease(functionCall);
    }
}

