/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.lifecycle;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManagerCallbacks;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractAssetLifecycleManager<ASSET_TYPE extends IAssetItem<?, ? extends IAssetItem.Value<? extends ASSET_TYPE>>>
implements IAssetItemLifecycleManager<ASSET_TYPE> {
    protected final @NonNull ASSET_TYPE asset;
    protected final @NonNull IAssetItemLifecycleManagerCallbacks callbacks;
    private final @NonNull Map<IAssetProperty<?>, IAssetPropertValueTracker<?>> trackedPropertyValues = new HashMap();

    public AbstractAssetLifecycleManager(@NonNull ASSET_TYPE asset, @NonNull IAssetItemLifecycleManagerCallbacks callbacks) {
        this.asset = asset;
        this.callbacks = callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <U extends IAssetItem<?, ? extends IAssetItem.Value<? extends U>>> void trackPropertyValueChanged(@NonNull IAssetProperty<@Nullable U> property, @NonNull FunctionCall functionCall, @Nullable U value) {
        Map<IAssetProperty<?>, IAssetPropertValueTracker<?>> map = this.trackedPropertyValues;
        synchronized (map) {
            IAssetPropertValueTracker<?> oldTracker = this.trackedPropertyValues.remove(property);
            if (oldTracker != null) {
                assert (oldTracker instanceof SingleAssetPropertyValueTracker);
                oldTracker.unbind(functionCall);
            }
            if (value != null) {
                this.trackedPropertyValues.put(property, new SingleAssetPropertyValueTracker(this, functionCall, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, U extends IAssetItem<?, ? extends IAssetItem.Value<? extends U>>> void trackPropertyValueChangedMapEntry(@NonNull IAssetProperty<Map<@NonNull K, @Nullable U>> property, @NonNull FunctionCall functionCall, @NonNull K key, @Nullable U value) {
        Map<IAssetProperty<?>, IAssetPropertValueTracker<?>> map = this.trackedPropertyValues;
        synchronized (map) {
            IAssetPropertValueTracker<?> oldTracker = this.trackedPropertyValues.remove(property);
            MapAssetPropertyValueTracker tracker = oldTracker != null ? (MapAssetPropertyValueTracker)oldTracker : new MapAssetPropertyValueTracker();
            tracker.unbind(functionCall, key);
            if (value != null) {
                tracker.bind(functionCall, key, value);
            }
            this.trackedPropertyValues.put(property, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindAllHeldReferences(@NonNull FunctionCall functionCall) {
        ArrayList boundValues;
        Map<IAssetProperty<?>, IAssetPropertValueTracker<?>> map = this.trackedPropertyValues;
        synchronized (map) {
            boundValues = new ArrayList(this.trackedPropertyValues.values());
            this.trackedPropertyValues.clear();
        }
        for (IAssetPropertValueTracker iAssetPropertValueTracker : boundValues) {
            iAssetPropertValueTracker.unbind(functionCall);
        }
    }

    private static interface IAssetPropertValueTracker<T extends IAssetItem<?, ?>> {
        public void unbind(@NonNull FunctionCall var1);
    }

    private class MapAssetPropertyValueTracker<K, T extends IAssetItem<?, ?>>
    implements IAssetPropertValueTracker<T> {
        private final @NonNull Map<K, SingleAssetPropertyValueTracker<T>> values = new HashMap<K, SingleAssetPropertyValueTracker<T>>();

        public void bind(@NonNull FunctionCall functionCall, @NonNull K key, @NonNull T value) {
            SingleAssetPropertyValueTracker newValue = new SingleAssetPropertyValueTracker(AbstractAssetLifecycleManager.this, functionCall, value);
            SingleAssetPropertyValueTracker oldValue = this.values.put(key, newValue);
            if (oldValue != null) {
                oldValue.unbind(functionCall);
            }
        }

        @Override
        public void unbind(@NonNull FunctionCall functionCall) {
            for (SingleAssetPropertyValueTracker<T> value : this.values.values()) {
                value.unbind(functionCall);
            }
        }

        public void unbind(@NonNull FunctionCall functionCall, @NonNull K key) {
            SingleAssetPropertyValueTracker<T> value = this.values.remove(key);
            if (value != null) {
                value.unbind(functionCall);
            }
        }
    }

    private static class SingleAssetPropertyValueTracker<T extends IAssetItem<?, ?>>
    implements IAssetPropertValueTracker<T> {
        private final @NonNull FunctionCall functioncall;
        private final @NonNull T value;
        final /* synthetic */ AbstractAssetLifecycleManager this$0;

        public SingleAssetPropertyValueTracker(@NonNull FunctionCall functionCall, T value) {
            this.this$0 = var1_1;
            this.value = value;
            this.functioncall = functionCall;
            value.getLifecycleManager().trackRetainedByAssetItem(functionCall, var1_1.asset);
        }

        @Override
        public void unbind(@NonNull FunctionCall functionCall) {
            assert (this.functioncall.compareTo(functionCall) < 0);
            this.value.getLifecycleManager().trackReleasedFromAssetItem(functionCall, this.this$0.asset);
        }
    }
}

