/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.internal;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractAssetPropertyValue<PROPERTY_TYPE>
implements IAssetPropertyValue<PROPERTY_TYPE> {
    protected final @NonNull IAssetItem<?, ?> assetObject;
    protected final @NonNull IAssetProperty<PROPERTY_TYPE> assetProperty;
    private @NonNull FunctionCall lastAffectingFunction;

    public AbstractAssetPropertyValue(@NonNull IAssetPropertyValue<PROPERTY_TYPE> cloneProperty) {
        this.assetObject = cloneProperty.getParentAssetObject();
        this.assetProperty = cloneProperty.getProperty();
        this.lastAffectingFunction = cloneProperty.getLastAffectingFunction();
    }

    protected AbstractAssetPropertyValue(@NonNull IAssetItem<?, ?> assetObject, @NonNull IAssetProperty<PROPERTY_TYPE> assetProperty) {
        this.assetObject = assetObject;
        this.assetProperty = assetProperty;
        this.lastAffectingFunction = assetObject.getCreatingFunction();
    }

    @Override
    public @NonNull FunctionCall getLastAffectingFunction() {
        return this.lastAffectingFunction;
    }

    @Override
    public final @NonNull IAssetItem<?, ?> getParentAssetObject() {
        return this.assetObject;
    }

    @Override
    public final @NonNull IAssetProperty<PROPERTY_TYPE> getProperty() {
        return this.assetProperty;
    }

    @Override
    public final @NonNull ClosedFunctionCallIDRange getValidFunctionCallRange() {
        FunctionCall firstCallAfterLastAffecting = this.assetObject.findFirstFunctionCallAfter(this.lastAffectingFunction.getID());
        FunctionCallID rangeEnd = firstCallAfterLastAffecting != null ? firstCallAfterLastAffecting.getID() : this.lastAffectingFunction.getID().next();
        return new ClosedFunctionCallIDRange(this.lastAffectingFunction.getID(), rangeEnd);
    }

    public abstract String toString();

    protected void addAffectingFunctionCall(@NonNull FunctionCall functionCall) {
        int comparison = this.lastAffectingFunction.compareTo(functionCall);
        if (comparison == 0) {
            return;
        }
        if (comparison < 0) {
            this.lastAffectingFunction = functionCall;
        } else assert (false) : "addAffectingFunctionCall called with out of order calls: " + this.lastAffectingFunction.getID() + " vs " + functionCall.getID();
    }
}

