/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.internal;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AbstractAssetContainerMap;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.IAssetItemWithChildren;
import com.arm.mgd.lightweight.asset.IAssetItemWithParent;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractAssetItemWithChildren<API_MODEL, VALUE_TYPE extends IAssetItem.Value<? extends IAssetItem<API_MODEL, VALUE_TYPE>>, CHILD_TYPE extends IAssetItemWithParent<API_MODEL, ?, ? extends IAssetItemWithChildren<API_MODEL, VALUE_TYPE, CHILD_TYPE>>>
extends AbstractAssetItem<API_MODEL, VALUE_TYPE>
implements IAssetItemWithChildren<API_MODEL, VALUE_TYPE, CHILD_TYPE> {
    private final AssetContainerMap<CHILD_TYPE> childAssets = new AssetContainerMap();

    protected AbstractAssetItemWithChildren(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId) {
        super(creatingFunctionCall, id, uniqueInstanceId);
    }

    @Override
    public void addChildAsset(@NonNull CHILD_TYPE newAsset) {
        if (newAsset.getParentAsset() != this) {
            throw new IllegalArgumentException("Invalid child asset " + newAsset.getClass().getSimpleName() + " for " + this.getClass().getSimpleName());
        }
        this.childAssets.addChildAsset(newAsset);
    }

    @Override
    public <T extends CHILD_TYPE> Iterator<@NonNull T> childAssetIterator(KapiSpec.AssetTraits<?, T, ?> traits) {
        return this.childAssets.childAssetIterator(traits);
    }

    @Override
    public Iterator<@NonNull AssetTableSpec> childTypeIterator() {
        return this.childAssets.childTypeIterator();
    }

    @Override
    public void forEachChildAsset(Consumer<CHILD_TYPE> callback) {
        this.childAssets.forEach(callback);
    }

    @Override
    public <T extends CHILD_TYPE> Map<@NonNull AssetItemID, @NonNull List<@NonNull T>> getAllChildren(KapiSpec.AssetTraits<?, T, ?> traits) {
        return this.childAssets.getAllChildren(traits);
    }

    @Override
    public <T extends CHILD_TYPE> @Nullable T getLastAssetBefore(KapiSpec.AssetTraits<?, T, ?> traits, AssetItemID id, FunctionCallID atCallID, boolean live) {
        return (T)((IAssetItemWithParent)this.childAssets.getLastAssetBefore(traits, id, atCallID, live));
    }

    @Override
    public <T extends CHILD_TYPE> @Nullable T getLastAssetBefore(KapiSpec.AssetTraits<?, T, ?> traits, AssetItemID id, FunctionCallID atCallID, @Nullable Long specificInstanceId) {
        if (specificInstanceId == null) {
            return (T)((IAssetItemWithParent)this.childAssets.getLastAssetBefore(traits, id, atCallID, true));
        }
        return (T)((IAssetItemWithParent)this.childAssets.getLastAssetBefore(traits, id, atCallID, specificInstanceId));
    }

    protected void deleteAllChildren(KapiSpec.AssetTraits<?, ? extends CHILD_TYPE, ?> traits, FunctionCall deletingFunction) {
        this.childAssets.markAllAsDeleted(traits, deletingFunction);
    }

    private static class AssetContainerMap<CHILD_TYPE extends IAssetItem<?, ?>>
    extends AbstractAssetContainerMap<CHILD_TYPE> {
        private AssetContainerMap() {
        }

        @Override
        public boolean isAcceptableClass(@NonNull AssetTableSpec assetTableSpec) {
            return true;
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(@NonNull Class<T> assetClass) {
            return true;
        }
    }
}

