/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.internal;

import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractAssetItemValue<PARENT_TYPE extends IAssetItem<?, ? extends IAssetItem.Value<PARENT_TYPE>>>
implements IAssetItem.Value<PARENT_TYPE> {
    private final @NonNull PARENT_TYPE assetObject;
    private final @NonNull ClosedFunctionCallIDRange functionCallRange;
    private final @NonNull Map<IAssetProperty<?>, IAssetPropertyValue<?>> properties = new HashMap();

    protected static IAssetPropertyValue<?>[] join(@NonNull IAssetPropertyValue<?>[] additionalPropertyValues, IAssetPropertyValue<?> ... values) {
        IAssetPropertyValue[] result = new IAssetPropertyValue[additionalPropertyValues.length + values.length];
        System.arraycopy(additionalPropertyValues, 0, result, 0, additionalPropertyValues.length);
        System.arraycopy(values, 0, result, additionalPropertyValues.length, values.length);
        return result;
    }

    protected AbstractAssetItemValue(@NonNull ClosedFunctionCallIDRange functionCallRange, @NonNull PARENT_TYPE assetObject, IAssetPropertyValue<?> ... assetPropertyValues) {
        this.functionCallRange = functionCallRange;
        this.assetObject = assetObject;
        IAssetPropertyValue<?>[] iAssetPropertyValueArray = assetPropertyValues;
        int n = assetPropertyValues.length;
        int n2 = 0;
        while (n2 < n) {
            IAssetPropertyValue<?> assetPropertyValue = iAssetPropertyValueArray[n2];
            this.properties.put(assetPropertyValue.getProperty(), assetPropertyValue);
            ++n2;
        }
    }

    @Override
    public final @NonNull PARENT_TYPE getAssetObject() {
        return this.assetObject;
    }

    @Override
    public final <PROPERTY_TYPE> IAssetPropertyValue<PROPERTY_TYPE> getPropertyValue(@NonNull IAssetProperty<PROPERTY_TYPE> property) {
        if (this.properties.containsKey(property)) {
            IAssetPropertyValue<?> resultCast = this.properties.get(property);
            assert (resultCast != null);
            return resultCast;
        }
        throw new NoSuchElementException("Invalid property " + property.getPropertyLabel() + " in " + this.assetObject.getAssetTypeLabel());
    }

    @Override
    public final @NonNull ClosedFunctionCallIDRange getValidFunctionCallRange() {
        return this.functionCallRange;
    }

    @Override
    public final @NonNull Iterator<IAssetPropertyValue<?>> iterator() {
        return Collections.unmodifiableCollection(this.properties.values()).iterator();
    }
}

