/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.internal;

import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.CompletableProgressFuture;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManagerCallbacks;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.util.AbstractFunctionCallContainer;
import com.arm.mgd.lightweight.util.CacheValueByFunctionId;
import com.arm.mgd.utils.NullUtils;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractAssetItem<API_MODEL, VALUE_TYPE extends IAssetItem.Value<? extends IAssetItem<API_MODEL, VALUE_TYPE>>>
extends AbstractFunctionCallContainer
implements IAssetItem<API_MODEL, VALUE_TYPE> {
    protected final @NonNull IAssetItemLifecycleManagerCallbacks lifecycleManagerPrivateInterface;
    private final @NonNull AssetItemID id;
    private final @NonNull UniqueInstanceId uniqueInstanceId;
    private final @NonNull CacheValueByFunctionId<VALUE_TYPE> valueCache;

    protected AbstractAssetItem(@NonNull FunctionCall creatingFunctionCall, @NonNull AssetItemID id, @NonNull UniqueInstanceId uniqueInstanceId) {
        this.id = id;
        this.lifecycleManagerPrivateInterface = new IAssetItemLifecycleManagerCallbacks(){

            @Override
            public void setDeleted(FunctionCall functionCall) {
                AbstractAssetItem.this.setDeleted(functionCall);
            }

            @Override
            public void setDeleteRequested(@NonNull FunctionCall functionCall) {
                AbstractAssetItem.this.setDeleteRequested(functionCall);
            }
        };
        this.valueCache = new CacheValueByFunctionId();
        this.uniqueInstanceId = uniqueInstanceId;
        this.addFunctionCall(creatingFunctionCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addFunctionCall(@NonNull FunctionCall functionCall) {
        Object object = this.functionCallMutex;
        synchronized (object) {
            super.addFunctionCall(functionCall);
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        IAssetItem that = (IAssetItem)obj;
        return that.getId().equals(this.getId()) && that.getCreatingFunction().equals(this.getCreatingFunction());
    }

    @Override
    public @NonNull FunctionCall getCreatingFunction() {
        return this.getFunctionCall(0);
    }

    @Override
    public AssetItemID getId() {
        return this.id;
    }

    @Override
    public @NonNull UniqueInstanceId getUniqueInstanceId() {
        return this.uniqueInstanceId;
    }

    @Override
    public final @NonNull CompletableProgressFuture<@NonNull VALUE_TYPE> getValue(@NonNull Executor executor, final @NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, final @NonNull FunctionCallID at) {
        return (CompletableProgressFuture)NullUtils.neverNull(CompletableProgressFuture.supplyAsync(executor, new Function<ICoreProgressMonitor, VALUE_TYPE>(){

            @Override
            public @NonNull VALUE_TYPE apply(@NonNull ICoreProgressMonitor progressMonitor) {
                try {
                    return AbstractAssetItem.this.waitForValue(callbacks, progressMonitor, at);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }));
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public @NonNull VALUE_TYPE waitForValue(@NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCallID at) throws Exception {
        return this.waitForValue(callbacks, ICoreProgressMonitor.NULL_MONITOR, at);
    }

    @Override
    public @NonNull VALUE_TYPE waitForValue(@NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull FunctionCallID at) throws Exception {
        @Nullable IAssetItem.Value cachedValue = (IAssetItem.Value)this.valueCache.findNearestBefore(at);
        if (cachedValue == null) {
            return (VALUE_TYPE)((IAssetItem.Value)this.valueCache.cacheAndReturn(this.executeLightweightValueProcessor(callbacks, progressMonitor, at)));
        }
        if (!cachedValue.getValidFunctionCallRange().contains(at)) {
            IAssetItem.Value updatedValue = this.executeLightweightValueProcessor(callbacks, progressMonitor, cachedValue, at);
            if (updatedValue.getValidFunctionCallRange().equals(cachedValue.getValidFunctionCallRange())) {
                return (VALUE_TYPE)this.valueCache.update(updatedValue);
            }
            return (VALUE_TYPE)this.valueCache.cacheAndReturn(updatedValue);
        }
        return (VALUE_TYPE)cachedValue;
    }

    protected abstract @NonNull VALUE_TYPE executeLightweightValueProcessor(@NonNull ILightweightAssetProcessorCallbacks<API_MODEL> var1, @NonNull ICoreProgressMonitor var2, @NonNull FunctionCallID var3) throws Exception;

    protected abstract @NonNull VALUE_TYPE executeLightweightValueProcessor(@NonNull ILightweightAssetProcessorCallbacks<API_MODEL> var1, @NonNull ICoreProgressMonitor var2, @NonNull VALUE_TYPE var3, @NonNull FunctionCallID var4) throws Exception;

    protected void setDeleted(@NonNull FunctionCall functionCall) {
    }

    protected void setDeleteRequested(@NonNull FunctionCall functionCall) {
    }
}

