/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.gles.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.gles.GlProgramAsset;
import com.arm.mgd.lightweight.asset.gles.ShaderUniform;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemWithParent;
import com.arm.mgd.lightweight.asset.lifecycle.ChildAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.gles.GlesAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.model.api.GLESApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractShaderUniform
extends AbstractAssetItemWithParent<GLESApi, ShaderUniform.Value, GlProgramAsset> {
    private final ImmutablePropertyValue<@NonNull Integer> arrayLength;
    private final ImmutablePropertyValue<@NonNull String> blockName;
    private final ImmutablePropertyValue<@NonNull Integer> elementLength;
    private final ImmutablePropertyValue<@NonNull Integer> location;
    private final ImmutablePropertyValue<@NonNull String> name;
    private final ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type;
    private final IAssetItemLifecycleManager<ShaderUniform> lifecycleManager;

    protected AbstractShaderUniform(FunctionCall creatingFunctionCall, GlProgramAsset parentAsset, AssetItemID id, UniqueInstanceId uniqueInstanceId, int arrayLength, String blockName, int elementLength, int location, String name, AbstractConstantOrAliasSpecExtended type) {
        super(creatingFunctionCall, parentAsset, id, uniqueInstanceId);
        this.arrayLength = new ImmutablePropertyValue<Integer>(this, ShaderUniformProperties.PROPERTY_ARRAY_LENGTH, arrayLength);
        this.blockName = new ImmutablePropertyValue<String>(this, ShaderUniformProperties.PROPERTY_BLOCK_NAME, blockName);
        this.elementLength = new ImmutablePropertyValue<Integer>(this, ShaderUniformProperties.PROPERTY_ELEMENT_LENGTH, elementLength);
        this.location = new ImmutablePropertyValue<Integer>(this, ShaderUniformProperties.PROPERTY_LOCATION, location);
        this.name = new ImmutablePropertyValue<String>(this, ShaderUniformProperties.PROPERTY_NAME, name);
        this.type = new ImmutablePropertyValue<AbstractConstantOrAliasSpecExtended>(this, ShaderUniformProperties.PROPERTY_TYPE, type);
        this.lifecycleManager = new ChildAssetLifecycleManager<ShaderUniform>((ShaderUniform)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(ShaderUniformProperties.PROPERTY_ARRAY_LENGTH, ShaderUniformProperties.PROPERTY_BLOCK_NAME, ShaderUniformProperties.PROPERTY_ELEMENT_LENGTH, ShaderUniformProperties.PROPERTY_LOCATION, ShaderUniformProperties.PROPERTY_NAME, ShaderUniformProperties.PROPERTY_TYPE, ShaderUniformProperties.PROPERTY_VALUE));
    }

    public ImmutablePropertyValue<@NonNull Integer> getImmutablePropertyArrayLength() {
        return this.arrayLength;
    }

    public ImmutablePropertyValue<@NonNull String> getImmutablePropertyBlockName() {
        return this.blockName;
    }

    public ImmutablePropertyValue<@NonNull Integer> getImmutablePropertyElementLength() {
        return this.elementLength;
    }

    public ImmutablePropertyValue<@NonNull Integer> getImmutablePropertyLocation() {
        return this.location;
    }

    public ImmutablePropertyValue<@NonNull String> getImmutablePropertyName() {
        return this.name;
    }

    public ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getImmutablePropertyType() {
        return this.type;
    }

    @Override
    public String getAssetTypeLabel() {
        return "ShaderUniform";
    }

    @Override
    protected ShaderUniform.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<GLESApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return GlesAssetValueProcessor.ShaderUniformValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (ShaderUniform)this, lastCallID);
    }

    @Override
    protected ShaderUniform.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<GLESApi> callbacks, ICoreProgressMonitor progressMonitor, ShaderUniform.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return GlesAssetValueProcessor.ShaderUniformValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.GLES.assetTables.UNIFORM_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("ShaderUniform#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("arrayLength = ").append(this.getImmutablePropertyArrayLength()).append(", ").append("blockName = ").append(this.getImmutablePropertyBlockName()).append(", ").append("elementLength = ").append(this.getImmutablePropertyElementLength()).append(", ").append("location = ").append(this.getImmutablePropertyLocation()).append(", ").append("name = ").append(this.getImmutablePropertyName()).append(", ").append("type = ").append(this.getImmutablePropertyType()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<ShaderUniform> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<GLESApi, ?>> getImmutablePropertyAssetDependencies() {
        return Collections.emptySet();
    }

    public static class ShaderUniformProperties {
        public static final SimpleAssetProperty<@NonNull Integer> PROPERTY_ARRAY_LENGTH = new SimpleAssetProperty("arrayLength");
        public static final SimpleAssetProperty<@NonNull String> PROPERTY_BLOCK_NAME = new SimpleAssetProperty("blockName");
        public static final SimpleAssetProperty<@NonNull Integer> PROPERTY_ELEMENT_LENGTH = new SimpleAssetProperty("elementLength");
        public static final SimpleAssetProperty<@NonNull Integer> PROPERTY_LOCATION = new SimpleAssetProperty("location");
        public static final SimpleAssetProperty<@NonNull String> PROPERTY_NAME = new SimpleAssetProperty("name");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_TYPE = new SimpleAssetProperty("type");
        public static final SimpleAssetProperty<Number[][]> PROPERTY_VALUE = new SimpleAssetProperty("value");
    }

    public static abstract class Value
    extends AbstractAssetItemValue<ShaderUniform> {
        private final IAssetPropertyValue<@NonNull Integer> arrayLength;
        private final IAssetPropertyValue<@NonNull String> blockName;
        private final IAssetPropertyValue<@NonNull Integer> elementLength;
        private final IAssetPropertyValue<@NonNull Integer> location;
        private final IAssetPropertyValue<@NonNull String> name;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type;
        private final IAssetPropertyValue<Number[][]> value;

        public Value(ClosedFunctionCallIDRange functionCallRange, ShaderUniform assetObject, IAssetPropertyValue<@NonNull Integer> arrayLength, IAssetPropertyValue<@NonNull String> blockName, IAssetPropertyValue<@NonNull Integer> elementLength, IAssetPropertyValue<@NonNull Integer> location, IAssetPropertyValue<@NonNull String> name, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type, IAssetPropertyValue<Number[][]> value) {
            super(functionCallRange, assetObject, arrayLength, blockName, elementLength, location, name, type, value);
            this.arrayLength = arrayLength;
            this.blockName = blockName;
            this.elementLength = elementLength;
            this.location = location;
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public final IAssetPropertyValue<@NonNull Integer> getArrayLength() {
            return this.arrayLength;
        }

        public final IAssetPropertyValue<@NonNull String> getBlockName() {
            return this.blockName;
        }

        public final IAssetPropertyValue<@NonNull Integer> getElementLength() {
            return this.elementLength;
        }

        public final IAssetPropertyValue<@NonNull Integer> getLocation() {
            return this.location;
        }

        public final IAssetPropertyValue<@NonNull String> getName() {
            return this.name;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getType() {
            return this.type;
        }

        public final IAssetPropertyValue<Number[][]> getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("ShaderUniform#").append(((ShaderUniform)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("arrayLength = ").append(this.getArrayLength()).append(", ").append("blockName = ").append(this.getBlockName()).append(", ").append("elementLength = ").append(this.getElementLength()).append(", ").append("location = ").append(this.getLocation()).append(", ").append("name = ").append(this.getName()).append(", ").append("type = ").append(this.getType()).append(", ").append("value = ").append(this.getValue()).append("}");
            return result.toString();
        }
    }
}

