/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.gles.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.IAssetItemWithParent;
import com.arm.mgd.lightweight.asset.gles.GlTextureAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureSurfaceAsset;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemWithChildren;
import com.arm.mgd.lightweight.asset.lifecycle.DefaultObjectLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.DeletableAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.gles.GlesAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.model.api.GLESApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractGlTextureAsset
extends AbstractAssetItemWithChildren<GLESApi, GlTextureAsset.Value, IAssetItemWithParent<GLESApi, ?, GlTextureAsset>> {
    private final IAssetItemLifecycleManager<GlTextureAsset> lifecycleManager;

    protected AbstractGlTextureAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.lifecycleManager = id.equals(AssetItemID.valueOf(0)) ? new DefaultObjectLifecycleManager<GlTextureAsset>((GlTextureAsset)this, this.lifecycleManagerPrivateInterface) : new DeletableAssetLifecycleManager<GlTextureAsset>((GlTextureAsset)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(GlTextureAssetProperties.PROPERTY_BASE_LEVEL, GlTextureAssetProperties.PROPERTY_BORDER_COLOR, GlTextureAssetProperties.PROPERTY_COMPARE_FUNC, GlTextureAssetProperties.PROPERTY_COMPARE_MODE, GlTextureAssetProperties.PROPERTY_DEPTH_STENCIL_TEXTURE_MODE, GlTextureAssetProperties.PROPERTY_EGL_IMAGE, GlTextureAssetProperties.PROPERTY_EVER_BOUND_TO_FRAMEBUFFER, GlTextureAssetProperties.PROPERTY_IMMUTABLE_FORMAT, GlTextureAssetProperties.PROPERTY_IMMUTABLE_LEVELS, GlTextureAssetProperties.PROPERTY_MAG_FILTER, GlTextureAssetProperties.PROPERTY_MAX_LEVEL, GlTextureAssetProperties.PROPERTY_MAX_LOD, GlTextureAssetProperties.PROPERTY_MIN_FILTER, GlTextureAssetProperties.PROPERTY_MIN_LOD, GlTextureAssetProperties.PROPERTY_SWIZZLE_A, GlTextureAssetProperties.PROPERTY_SWIZZLE_B, GlTextureAssetProperties.PROPERTY_SWIZZLE_G, GlTextureAssetProperties.PROPERTY_SWIZZLE_R, GlTextureAssetProperties.PROPERTY_TEXTURE_TARGET, GlTextureAssetProperties.PROPERTY_WRAP_R, GlTextureAssetProperties.PROPERTY_WRAP_S, GlTextureAssetProperties.PROPERTY_WRAP_T));
    }

    @Override
    public String getAssetTypeLabel() {
        return "GlTextureAsset";
    }

    @Override
    protected GlTextureAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<GLESApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return GlesAssetValueProcessor.GlTextureAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (GlTextureAsset)this, lastCallID);
    }

    @Override
    protected GlTextureAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<GLESApi> callbacks, ICoreProgressMonitor progressMonitor, GlTextureAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return GlesAssetValueProcessor.GlTextureAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC;
    }

    @Override
    public void addChildAsset(GlTextureSurfaceAsset newAsset) {
        super.addChildAsset(newAsset);
    }

    public @Nullable GlTextureSurfaceAsset getGlTextureSurfaceAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, boolean live) {
        GlTextureSurfaceAsset result = this.getLastAssetBefore(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_TRAITS, id, functionCallID, live);
        if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCallID) || !live && !result.getLifecycleManager().isAssetRetained(functionCallID)) {
            return null;
        }
        return result;
    }

    public @Nullable GlTextureSurfaceAsset getGlTextureSurfaceAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, @Nullable Long specificInstanceId) {
        GlTextureSurfaceAsset result = this.getLastAssetBefore(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_TRAITS, id, functionCallID, specificInstanceId);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("GlTextureAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("GlTextureSurfaceAsset = ").append(this.getAllChildren(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_TRAITS)).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<GlTextureAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<GLESApi, ?>> getImmutablePropertyAssetDependencies() {
        return Collections.emptySet();
    }

    @Override
    protected void setDeleted(FunctionCall functionCall) {
        super.setDeleted(functionCall);
        this.deleteAllChildren(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_TRAITS, functionCall);
    }

    public static class GlTextureAssetProperties {
        public static final SimpleAssetProperty<@NonNull Long> PROPERTY_BASE_LEVEL = new SimpleAssetProperty("baseLevel");
        public static final SimpleAssetProperty<float[]> PROPERTY_BORDER_COLOR = new SimpleAssetProperty("borderColor");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_COMPARE_FUNC = new SimpleAssetProperty("compareFunc");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_COMPARE_MODE = new SimpleAssetProperty("compareMode");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_DEPTH_STENCIL_TEXTURE_MODE = new SimpleAssetProperty("depthStencilTextureMode");
        public static final SimpleAssetProperty<@Nullable Pointer> PROPERTY_EGL_IMAGE = new SimpleAssetProperty("eglImage");
        public static final SimpleAssetProperty<@NonNull Boolean> PROPERTY_EVER_BOUND_TO_FRAMEBUFFER = new SimpleAssetProperty("everBoundToFramebuffer");
        public static final SimpleAssetProperty<@NonNull Boolean> PROPERTY_IMMUTABLE_FORMAT = new SimpleAssetProperty("immutableFormat");
        public static final SimpleAssetProperty<@NonNull Long> PROPERTY_IMMUTABLE_LEVELS = new SimpleAssetProperty("immutableLevels");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_MAG_FILTER = new SimpleAssetProperty("magFilter");
        public static final SimpleAssetProperty<@NonNull Long> PROPERTY_MAX_LEVEL = new SimpleAssetProperty("maxLevel");
        public static final SimpleAssetProperty<@NonNull Float> PROPERTY_MAX_LOD = new SimpleAssetProperty("maxLod");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_MIN_FILTER = new SimpleAssetProperty("minFilter");
        public static final SimpleAssetProperty<@NonNull Float> PROPERTY_MIN_LOD = new SimpleAssetProperty("minLod");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_SWIZZLE_A = new SimpleAssetProperty("swizzleA");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_SWIZZLE_B = new SimpleAssetProperty("swizzleB");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_SWIZZLE_G = new SimpleAssetProperty("swizzleG");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_SWIZZLE_R = new SimpleAssetProperty("swizzleR");
        public static final SimpleAssetProperty<@Nullable AbstractConstantOrAliasSpecExtended> PROPERTY_TEXTURE_TARGET = new SimpleAssetProperty("textureTarget");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_WRAP_R = new SimpleAssetProperty("wrapR");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_WRAP_S = new SimpleAssetProperty("wrapS");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_WRAP_T = new SimpleAssetProperty("wrapT");
    }

    public static abstract class Value
    extends AbstractAssetItemValue<GlTextureAsset> {
        private final IAssetPropertyValue<@NonNull Long> baseLevel;
        private final IAssetPropertyValue<float[]> borderColor;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareFunc;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareMode;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> depthStencilTextureMode;
        private final IAssetPropertyValue<@Nullable Pointer> eglImage;
        private final IAssetPropertyValue<@NonNull Boolean> everBoundToFramebuffer;
        private final IAssetPropertyValue<@NonNull Boolean> immutableFormat;
        private final IAssetPropertyValue<@NonNull Long> immutableLevels;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> magFilter;
        private final IAssetPropertyValue<@NonNull Long> maxLevel;
        private final IAssetPropertyValue<@NonNull Float> maxLod;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> minFilter;
        private final IAssetPropertyValue<@NonNull Float> minLod;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleA;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleB;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleG;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleR;
        private final IAssetPropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> textureTarget;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapR;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapS;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapT;

        public Value(ClosedFunctionCallIDRange functionCallRange, GlTextureAsset assetObject, IAssetPropertyValue<@NonNull Long> baseLevel, IAssetPropertyValue<float[]> borderColor, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareFunc, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareMode, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> depthStencilTextureMode, IAssetPropertyValue<@Nullable Pointer> eglImage, IAssetPropertyValue<@NonNull Boolean> everBoundToFramebuffer, IAssetPropertyValue<@NonNull Boolean> immutableFormat, IAssetPropertyValue<@NonNull Long> immutableLevels, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> magFilter, IAssetPropertyValue<@NonNull Long> maxLevel, IAssetPropertyValue<@NonNull Float> maxLod, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> minFilter, IAssetPropertyValue<@NonNull Float> minLod, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleA, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleB, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleG, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleR, IAssetPropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> textureTarget, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapR, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapS, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapT) {
            super(functionCallRange, assetObject, baseLevel, borderColor, compareFunc, compareMode, depthStencilTextureMode, eglImage, everBoundToFramebuffer, immutableFormat, immutableLevels, magFilter, maxLevel, maxLod, minFilter, minLod, swizzleA, swizzleB, swizzleG, swizzleR, textureTarget, wrapR, wrapS, wrapT);
            this.baseLevel = baseLevel;
            this.borderColor = borderColor;
            this.compareFunc = compareFunc;
            this.compareMode = compareMode;
            this.depthStencilTextureMode = depthStencilTextureMode;
            this.eglImage = eglImage;
            this.everBoundToFramebuffer = everBoundToFramebuffer;
            this.immutableFormat = immutableFormat;
            this.immutableLevels = immutableLevels;
            this.magFilter = magFilter;
            this.maxLevel = maxLevel;
            this.maxLod = maxLod;
            this.minFilter = minFilter;
            this.minLod = minLod;
            this.swizzleA = swizzleA;
            this.swizzleB = swizzleB;
            this.swizzleG = swizzleG;
            this.swizzleR = swizzleR;
            this.textureTarget = textureTarget;
            this.wrapR = wrapR;
            this.wrapS = wrapS;
            this.wrapT = wrapT;
        }

        public final IAssetPropertyValue<@NonNull Long> getBaseLevel() {
            return this.baseLevel;
        }

        public final IAssetPropertyValue<float[]> getBorderColor() {
            return this.borderColor;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getCompareFunc() {
            return this.compareFunc;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getCompareMode() {
            return this.compareMode;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getDepthStencilTextureMode() {
            return this.depthStencilTextureMode;
        }

        public final IAssetPropertyValue<@Nullable Pointer> getEglImage() {
            return this.eglImage;
        }

        public final IAssetPropertyValue<@NonNull Boolean> getEverBoundToFramebuffer() {
            return this.everBoundToFramebuffer;
        }

        public final IAssetPropertyValue<@NonNull Boolean> getImmutableFormat() {
            return this.immutableFormat;
        }

        public final IAssetPropertyValue<@NonNull Long> getImmutableLevels() {
            return this.immutableLevels;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getMagFilter() {
            return this.magFilter;
        }

        public final IAssetPropertyValue<@NonNull Long> getMaxLevel() {
            return this.maxLevel;
        }

        public final IAssetPropertyValue<@NonNull Float> getMaxLod() {
            return this.maxLod;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getMinFilter() {
            return this.minFilter;
        }

        public final IAssetPropertyValue<@NonNull Float> getMinLod() {
            return this.minLod;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getSwizzleA() {
            return this.swizzleA;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getSwizzleB() {
            return this.swizzleB;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getSwizzleG() {
            return this.swizzleG;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getSwizzleR() {
            return this.swizzleR;
        }

        public final IAssetPropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> getTextureTarget() {
            return this.textureTarget;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getWrapR() {
            return this.wrapR;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getWrapS() {
            return this.wrapS;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getWrapT() {
            return this.wrapT;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("GlTextureAsset#").append(((GlTextureAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("baseLevel = ").append(this.getBaseLevel()).append(", ").append("borderColor = ").append(this.getBorderColor()).append(", ").append("compareFunc = ").append(this.getCompareFunc()).append(", ").append("compareMode = ").append(this.getCompareMode()).append(", ").append("depthStencilTextureMode = ").append(this.getDepthStencilTextureMode()).append(", ").append("eglImage = ").append(this.getEglImage()).append(", ").append("everBoundToFramebuffer = ").append(this.getEverBoundToFramebuffer()).append(", ").append("immutableFormat = ").append(this.getImmutableFormat()).append(", ").append("immutableLevels = ").append(this.getImmutableLevels()).append(", ").append("magFilter = ").append(this.getMagFilter()).append(", ").append("maxLevel = ").append(this.getMaxLevel()).append(", ").append("maxLod = ").append(this.getMaxLod()).append(", ").append("minFilter = ").append(this.getMinFilter()).append(", ").append("minLod = ").append(this.getMinLod()).append(", ").append("swizzleA = ").append(this.getSwizzleA()).append(", ").append("swizzleB = ").append(this.getSwizzleB()).append(", ").append("swizzleG = ").append(this.getSwizzleG()).append(", ").append("swizzleR = ").append(this.getSwizzleR()).append(", ").append("textureTarget = ").append(this.getTextureTarget()).append(", ").append("wrapR = ").append(this.getWrapR()).append(", ").append("wrapS = ").append(this.getWrapS()).append(", ").append("wrapT = ").append(this.getWrapT()).append("}");
            return result.toString();
        }
    }
}

