/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.gles.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.gles.GlShaderAsset;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.lifecycle.AutoRetainedAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.gles.GlesAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.model.api.GLESApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractGlShaderAsset
extends AbstractAssetItem<GLESApi, GlShaderAsset.Value> {
    private final ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type;
    private final IAssetItemLifecycleManager<GlShaderAsset> lifecycleManager;

    protected AbstractGlShaderAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, AbstractConstantOrAliasSpecExtended type) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.type = new ImmutablePropertyValue<AbstractConstantOrAliasSpecExtended>(this, GlShaderAssetProperties.PROPERTY_TYPE, type);
        this.lifecycleManager = new AutoRetainedAssetLifecycleManager<GlShaderAsset>((GlShaderAsset)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(GlShaderAssetProperties.PROPERTY_BINARY_FORMAT, GlShaderAssetProperties.PROPERTY_COMPILED, GlShaderAssetProperties.PROPERTY_DELETED, GlShaderAssetProperties.PROPERTY_FLAGGED_FOR_DELETION, GlShaderAssetProperties.PROPERTY_SHADER_INFO_LOG, GlShaderAssetProperties.PROPERTY_SHADER_SOURCE, GlShaderAssetProperties.PROPERTY_TYPE));
    }

    public ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getImmutablePropertyType() {
        return this.type;
    }

    @Override
    public String getAssetTypeLabel() {
        return "GlShaderAsset";
    }

    @Override
    protected GlShaderAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<GLESApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return GlesAssetValueProcessor.GlShaderAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (GlShaderAsset)this, lastCallID);
    }

    @Override
    protected GlShaderAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<GLESApi> callbacks, ICoreProgressMonitor progressMonitor, GlShaderAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return GlesAssetValueProcessor.GlShaderAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("GlShaderAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("type = ").append(this.getImmutablePropertyType()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<GlShaderAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<GLESApi, ?>> getImmutablePropertyAssetDependencies() {
        return Collections.emptySet();
    }

    public static class GlShaderAssetProperties {
        public static final SimpleAssetProperty<@Nullable AbstractConstantOrAliasSpecExtended> PROPERTY_BINARY_FORMAT = new SimpleAssetProperty("binaryFormat");
        public static final SimpleAssetProperty<@NonNull Boolean> PROPERTY_COMPILED = new SimpleAssetProperty("compiled");
        public static final SimpleAssetProperty<@NonNull Boolean> PROPERTY_DELETED = new SimpleAssetProperty("deleted");
        public static final SimpleAssetProperty<@NonNull Boolean> PROPERTY_FLAGGED_FOR_DELETION = new SimpleAssetProperty("flaggedForDeletion");
        public static final SimpleAssetProperty<@NonNull String> PROPERTY_SHADER_INFO_LOG = new SimpleAssetProperty("shaderInfoLog");
        public static final SimpleAssetProperty<@NonNull String> PROPERTY_SHADER_SOURCE = new SimpleAssetProperty("shaderSource");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_TYPE = new SimpleAssetProperty("type");
    }

    public static abstract class Value
    extends AbstractAssetItemValue<GlShaderAsset> {
        private final IAssetPropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> binaryFormat;
        private final IAssetPropertyValue<@NonNull Boolean> compiled;
        private final IAssetPropertyValue<@NonNull Boolean> deleted;
        private final IAssetPropertyValue<@NonNull Boolean> flaggedForDeletion;
        private final IAssetPropertyValue<@NonNull String> shaderInfoLog;
        private final IAssetPropertyValue<@NonNull String> shaderSource;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type;

        public Value(ClosedFunctionCallIDRange functionCallRange, GlShaderAsset assetObject, IAssetPropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> binaryFormat, IAssetPropertyValue<@NonNull Boolean> compiled, IAssetPropertyValue<@NonNull Boolean> deleted, IAssetPropertyValue<@NonNull Boolean> flaggedForDeletion, IAssetPropertyValue<@NonNull String> shaderInfoLog, IAssetPropertyValue<@NonNull String> shaderSource, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type) {
            super(functionCallRange, assetObject, binaryFormat, compiled, deleted, flaggedForDeletion, shaderInfoLog, shaderSource, type);
            this.binaryFormat = binaryFormat;
            this.compiled = compiled;
            this.deleted = deleted;
            this.flaggedForDeletion = flaggedForDeletion;
            this.shaderInfoLog = shaderInfoLog;
            this.shaderSource = shaderSource;
            this.type = type;
        }

        public final IAssetPropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> getBinaryFormat() {
            return this.binaryFormat;
        }

        public final IAssetPropertyValue<@NonNull Boolean> getCompiled() {
            return this.compiled;
        }

        public final IAssetPropertyValue<@NonNull Boolean> getDeleted() {
            return this.deleted;
        }

        public final IAssetPropertyValue<@NonNull Boolean> getFlaggedForDeletion() {
            return this.flaggedForDeletion;
        }

        public final IAssetPropertyValue<@NonNull String> getShaderInfoLog() {
            return this.shaderInfoLog;
        }

        public final IAssetPropertyValue<@NonNull String> getShaderSource() {
            return this.shaderSource;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getType() {
            return this.type;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("GlShaderAsset#").append(((GlShaderAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("binaryFormat = ").append(this.getBinaryFormat()).append(", ").append("compiled = ").append(this.getCompiled()).append(", ").append("deleted = ").append(this.getDeleted()).append(", ").append("flaggedForDeletion = ").append(this.getFlaggedForDeletion()).append(", ").append("shaderInfoLog = ").append(this.getShaderInfoLog()).append(", ").append("shaderSource = ").append(this.getShaderSource()).append(", ").append("type = ").append(this.getType()).append("}");
            return result.toString();
        }
    }
}

