/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.gles.gen;

import com.arm.mgd.core.asset.ComputeWorkgroupSize;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.IAssetItemWithParent;
import com.arm.mgd.lightweight.asset.gles.GlProgramAsset;
import com.arm.mgd.lightweight.asset.gles.GlShaderAsset;
import com.arm.mgd.lightweight.asset.gles.ShaderUniform;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemWithChildren;
import com.arm.mgd.lightweight.asset.lifecycle.AutoRetainedAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.gles.GlesAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.model.api.GLESApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractGlProgramAsset
extends AbstractAssetItemWithChildren<GLESApi, GlProgramAsset.Value, IAssetItemWithParent<GLESApi, ?, GlProgramAsset>> {
    private final IAssetItemLifecycleManager<GlProgramAsset> lifecycleManager;

    protected AbstractGlProgramAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.lifecycleManager = new AutoRetainedAssetLifecycleManager<GlProgramAsset>((GlProgramAsset)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(GlProgramAssetProperties.PROPERTY_ATTACHED_SHADERS, GlProgramAssetProperties.PROPERTY_COMPUTE_WORK_GROUP_SIZE, GlProgramAssetProperties.PROPERTY_DELETED, GlProgramAssetProperties.PROPERTY_LINKED, GlProgramAssetProperties.PROPERTY_LINKED_SHADERS, GlProgramAssetProperties.PROPERTY_PROGRAM_INFO_LOG, GlProgramAssetProperties.PROPERTY_SEPARABLE, GlProgramAssetProperties.PROPERTY_VALIDATED));
    }

    @Override
    public String getAssetTypeLabel() {
        return "GlProgramAsset";
    }

    @Override
    protected GlProgramAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<GLESApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return GlesAssetValueProcessor.GlProgramAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (GlProgramAsset)this, lastCallID);
    }

    @Override
    protected GlProgramAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<GLESApi> callbacks, ICoreProgressMonitor progressMonitor, GlProgramAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return GlesAssetValueProcessor.GlProgramAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC;
    }

    @Override
    public void addChildAsset(ShaderUniform newAsset) {
        super.addChildAsset(newAsset);
    }

    public @Nullable ShaderUniform getShaderUniformAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, boolean live) {
        ShaderUniform result = this.getLastAssetBefore(KapiSpec.GLES.assetTables.UNIFORM_TRAITS, id, functionCallID, live);
        if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCallID) || !live && !result.getLifecycleManager().isAssetRetained(functionCallID)) {
            return null;
        }
        return result;
    }

    public @Nullable ShaderUniform getShaderUniformAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, @Nullable Long specificInstanceId) {
        ShaderUniform result = this.getLastAssetBefore(KapiSpec.GLES.assetTables.UNIFORM_TRAITS, id, functionCallID, specificInstanceId);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("GlProgramAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("ShaderUniform = ").append(this.getAllChildren(KapiSpec.GLES.assetTables.UNIFORM_TRAITS)).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<GlProgramAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<GLESApi, ?>> getImmutablePropertyAssetDependencies() {
        return Collections.emptySet();
    }

    @Override
    protected void setDeleted(FunctionCall functionCall) {
        super.setDeleted(functionCall);
        this.deleteAllChildren(KapiSpec.GLES.assetTables.UNIFORM_TRAITS, functionCall);
    }

    public static class GlProgramAssetProperties {
        public static final SimpleAssetProperty<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset>> PROPERTY_ATTACHED_SHADERS = new SimpleAssetProperty("attachedShaders");
        public static final SimpleAssetProperty<@Nullable ComputeWorkgroupSize> PROPERTY_COMPUTE_WORK_GROUP_SIZE = new SimpleAssetProperty("computeWorkGroupSize");
        public static final SimpleAssetProperty<@NonNull Boolean> PROPERTY_DELETED = new SimpleAssetProperty("deleted");
        public static final SimpleAssetProperty<@NonNull Boolean> PROPERTY_LINKED = new SimpleAssetProperty("linked");
        public static final SimpleAssetProperty<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset>> PROPERTY_LINKED_SHADERS = new SimpleAssetProperty("linkedShaders");
        public static final SimpleAssetProperty<@NonNull String> PROPERTY_PROGRAM_INFO_LOG = new SimpleAssetProperty("programInfoLog");
        public static final SimpleAssetProperty<@NonNull Boolean> PROPERTY_SEPARABLE = new SimpleAssetProperty("separable");
        public static final SimpleAssetProperty<@NonNull Boolean> PROPERTY_VALIDATED = new SimpleAssetProperty("validated");
    }

    public static abstract class Value
    extends AbstractAssetItemValue<GlProgramAsset> {
        private final IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset>> attachedShaders;
        private final IAssetPropertyValue<@Nullable ComputeWorkgroupSize> computeWorkGroupSize;
        private final IAssetPropertyValue<@NonNull Boolean> deleted;
        private final IAssetPropertyValue<@NonNull Boolean> linked;
        private final IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset>> linkedShaders;
        private final IAssetPropertyValue<@NonNull String> programInfoLog;
        private final IAssetPropertyValue<@NonNull Boolean> separable;
        private final IAssetPropertyValue<@NonNull Boolean> validated;

        public Value(ClosedFunctionCallIDRange functionCallRange, GlProgramAsset assetObject, IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset>> attachedShaders, IAssetPropertyValue<@Nullable ComputeWorkgroupSize> computeWorkGroupSize, IAssetPropertyValue<@NonNull Boolean> deleted, IAssetPropertyValue<@NonNull Boolean> linked, IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset>> linkedShaders, IAssetPropertyValue<@NonNull String> programInfoLog, IAssetPropertyValue<@NonNull Boolean> separable, IAssetPropertyValue<@NonNull Boolean> validated) {
            super(functionCallRange, assetObject, attachedShaders, computeWorkGroupSize, deleted, linked, linkedShaders, programInfoLog, separable, validated);
            this.attachedShaders = attachedShaders;
            this.computeWorkGroupSize = computeWorkGroupSize;
            this.deleted = deleted;
            this.linked = linked;
            this.linkedShaders = linkedShaders;
            this.programInfoLog = programInfoLog;
            this.separable = separable;
            this.validated = validated;
        }

        public final IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset>> getAttachedShaders() {
            return this.attachedShaders;
        }

        public final IAssetPropertyValue<@Nullable ComputeWorkgroupSize> getComputeWorkGroupSize() {
            return this.computeWorkGroupSize;
        }

        public final IAssetPropertyValue<@NonNull Boolean> getDeleted() {
            return this.deleted;
        }

        public final IAssetPropertyValue<@NonNull Boolean> getLinked() {
            return this.linked;
        }

        public final IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset>> getLinkedShaders() {
            return this.linkedShaders;
        }

        public final IAssetPropertyValue<@NonNull String> getProgramInfoLog() {
            return this.programInfoLog;
        }

        public final IAssetPropertyValue<@NonNull Boolean> getSeparable() {
            return this.separable;
        }

        public final IAssetPropertyValue<@NonNull Boolean> getValidated() {
            return this.validated;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("GlProgramAsset#").append(((GlProgramAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("attachedShaders = ").append(this.getAttachedShaders()).append(", ").append("computeWorkGroupSize = ").append(this.getComputeWorkGroupSize()).append(", ").append("deleted = ").append(this.getDeleted()).append(", ").append("linked = ").append(this.getLinked()).append(", ").append("linkedShaders = ").append(this.getLinkedShaders()).append(", ").append("programInfoLog = ").append(this.getProgramInfoLog()).append(", ").append("separable = ").append(this.getSeparable()).append(", ").append("validated = ").append(this.getValidated()).append("}");
            return result.toString();
        }
    }
}

