/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.gles;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.LightweightAssetBuilder;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ProgramResourceDescriptor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.gles.GlProgramAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractShaderUniform;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.model.api.GLESApi;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ShaderUniform
extends AbstractShaderUniform {
    private final @Nullable ProgramResourceDescriptor blockDescriptor;
    private final @NonNull ProgramResourceDescriptor uniformDescriptor;

    public static @NonNull ShaderUniform createForMidstreamTrace(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull GlProgramAsset parentAsset, @NonNull AssetItemID id) {
        ShaderUniform result = parentAsset.getLastAssetBefore(KapiSpec.GLES.assetTables.UNIFORM_TRAITS, id, createdByFunction.getID(), true);
        if (result != null) {
            return result;
        }
        throw new AssertionError((Object)("Unexpected missing ShaderUniform asset: " + id));
    }

    public ShaderUniform(@NonNull FunctionCall creatingFunctionCall, @NonNull GlProgramAsset parentAsset, @NonNull ProgramResourceDescriptor uniformDescriptor, @Nullable ProgramResourceDescriptor blockDescriptor) {
        super(creatingFunctionCall, parentAsset, AssetItemID.valueOf(uniformDescriptor.getIndex()), UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, uniformDescriptor.resolveArraySize(), blockDescriptor != null ? blockDescriptor.getName() : "", uniformDescriptor.resolveElementLength(), uniformDescriptor.resolveLocation(), uniformDescriptor.getNameWithoutSuffix(), uniformDescriptor.resolveType());
        this.uniformDescriptor = uniformDescriptor;
        this.blockDescriptor = blockDescriptor;
    }

    public @Nullable ProgramResourceDescriptor getBlockDescriptor() {
        return this.blockDescriptor;
    }

    public @NonNull ProgramResourceDescriptor getUniformDescriptor() {
        return this.uniformDescriptor;
    }

    public int mapLocationToIndex(int location, int offset) {
        if (location < 0) {
            return -1;
        }
        int locatonPlusOffset = location + offset;
        List<ProgramResourceDescriptor.ProgramResourceAdditionalLocation> locations = this.uniformDescriptor.getAdditionalLocations();
        if (locations.isEmpty()) {
            int singleLocation = this.uniformDescriptor.resolveLocation();
            if (offset == 0 && singleLocation == location) {
                return 0;
            }
        }
        int arrayIndex = 0;
        while (arrayIndex < locations.size()) {
            ProgramResourceDescriptor.ProgramResourceAdditionalLocation arrayLocation = locations.get(arrayIndex);
            Integer indexLocation = arrayLocation.getLocation();
            if (indexLocation == locatonPlusOffset) {
                return arrayIndex;
            }
            ++arrayIndex;
        }
        return -1;
    }

    public boolean ownsLocation(int location) {
        if (location < 0) {
            return false;
        }
        if (this.uniformDescriptor.resolveLocation() == location) {
            return true;
        }
        for (ProgramResourceDescriptor.ProgramResourceAdditionalLocation additionalLocation : this.uniformDescriptor.getAdditionalLocations()) {
            if (additionalLocation.getLocation() != location) continue;
            return true;
        }
        return false;
    }

    public static final class Value
    extends AbstractShaderUniform.Value {
        public Value(@NonNull ClosedFunctionCallIDRange functionCallRange, @NonNull ShaderUniform assetObject, @NonNull IAssetPropertyValue<@NonNull Integer> arrayLength, @NonNull IAssetPropertyValue<@NonNull String> blockName, @NonNull IAssetPropertyValue<@NonNull Integer> elementLength, @NonNull IAssetPropertyValue<@NonNull Integer> location, @NonNull IAssetPropertyValue<@NonNull String> name, @NonNull IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type, @NonNull IAssetPropertyValue<@NonNull Number @NonNull [] @Nullable []> value) {
            super(functionCallRange, assetObject, arrayLength, blockName, elementLength, location, name, type, value);
        }
    }
}

