/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.gles;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.LightweightAssetBuilder;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.gles.GlBufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureSurfaceAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlTextureImageAsset;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimplePropertyValue;
import com.arm.mgd.lightweight.model.api.GLESApi;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlTextureImageAsset
extends AbstractGlTextureImageAsset {
    public static @NonNull GlTextureImageAsset createForMidstreamTrace(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull GlTextureSurfaceAsset parentAsset, @NonNull AssetItemID id) {
        return new GlTextureImageAsset(createdByFunction, parentAsset, id, UniqueInstanceId.createFor(assetAttachment));
    }

    public GlTextureImageAsset(@NonNull FunctionCall creatingFunctionCall, @NonNull GlTextureSurfaceAsset parentAsset, @NonNull AssetItemID id) {
        this(creatingFunctionCall, parentAsset, id, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID);
    }

    public GlTextureImageAsset(@NonNull FunctionCall creatingFunctionCall, @NonNull GlTextureSurfaceAsset parentAsset, @NonNull AssetItemID id, @NonNull UniqueInstanceId uniqueInstanceId) {
        super(creatingFunctionCall, parentAsset, id, uniqueInstanceId);
    }

    public void setStorageProperties(@NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> internalFormatProperty, @NonNull SimplePropertyValue<@NonNull Long> widthProperty, @NonNull SimplePropertyValue<@NonNull Long> heightProperty, @NonNull SimplePropertyValue<@NonNull Long> depthProperty, @NonNull AbstractConstantOrAliasSpecExtended target, @NonNull AbstractConstantOrAliasSpecExtended internalFormat, int levels, int width, int height, @Nullable Integer depth) {
        boolean isTexture3D = target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D);
        assert (isTexture3D && depth != null || !isTexture3D);
        internalFormatProperty.setValue(functionCall, internalFormat);
        widthProperty.setValue(functionCall, NullUtils.longValueOf((long)com.arm.mgd.core.asset.GlTextureImageAsset.scaleMipmapDimension(width, this.getId().asLong(), levels)));
        heightProperty.setValue(functionCall, NullUtils.longValueOf((long)com.arm.mgd.core.asset.GlTextureImageAsset.scaleMipmapDimension(height, this.getId().asLong(), levels)));
        depthProperty.setValue(functionCall, NullUtils.longValueOf((long)com.arm.mgd.core.asset.GlTextureImageAsset.scaleMipmapDimension(isTexture3D ? (Integer)NullUtils.neverNull((Object)depth) : 1, this.getId().asLong(), levels)));
    }

    public static class Value
    extends AbstractGlTextureImageAsset.Value {
        public Value(@NonNull ClosedFunctionCallIDRange functionCallRange, @NonNull GlTextureImageAsset assetObject, @NonNull IAssetPropertyValue<@NonNull Long> alphaSize, @NonNull IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> alphaType, @NonNull IAssetPropertyValue<@NonNull Long> blueSize, @NonNull IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> blueType, @NonNull IAssetPropertyValue<@Nullable GlBufferAsset> bufferDataStoreBinding, @NonNull IAssetPropertyValue<@NonNull Long> bufferOffset, @NonNull IAssetPropertyValue<@NonNull Long> bufferSize, @NonNull IAssetPropertyValue<@NonNull Boolean> compressed, @NonNull IAssetPropertyValue<@NonNull Long> depth, @NonNull IAssetPropertyValue<@NonNull Long> depthSize, @NonNull IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> depthType, @NonNull IAssetPropertyValue<@NonNull Boolean> fixedSampleLocations, @NonNull IAssetPropertyValue<@NonNull Long> greenSize, @NonNull IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> greenType, @NonNull IAssetPropertyValue<@NonNull Long> height, @NonNull IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> internalFormat, @NonNull IAssetPropertyValue<@NonNull Long> redSize, @NonNull IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> redType, @NonNull IAssetPropertyValue<@NonNull Long> samples, @NonNull IAssetPropertyValue<@NonNull Long> sharedSize, @NonNull IAssetPropertyValue<@NonNull Long> stencilSize, @NonNull IAssetPropertyValue<@NonNull Long> width) {
            super(functionCallRange, assetObject, alphaSize, alphaType, blueSize, blueType, bufferDataStoreBinding, bufferOffset, bufferSize, compressed, depth, depthSize, depthType, fixedSampleLocations, greenSize, greenType, height, internalFormat, redSize, redType, samples, sharedSize, stencilSize, width);
        }
    }
}

