/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.gles;

import com.arm.mgd.core.asset.ComputeWorkgroupSize;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.LightweightAssetBuilder;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ProgramColour;
import com.arm.mgd.core.target.data.ProgramResourceDescriptor;
import com.arm.mgd.core.target.data.ProgramResourceDescriptorMap;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.FunctionCallIDRange;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.gles.GlShaderAsset;
import com.arm.mgd.lightweight.asset.gles.ShaderUniform;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlProgramAsset;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.model.api.GLESApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class GlProgramAsset
extends AbstractGlProgramAsset {
    private final List<TransientState> transientState = new ArrayList<TransientState>();

    public static GlProgramAsset createForMidstreamTrace(LightweightAssetBuilder<GLESApi> builder, MidstreamAssetItem assetAttachment, FunctionCall createdByFunction, AssetItemID id) {
        return new GlProgramAsset(createdByFunction, id, UniqueInstanceId.createFor(assetAttachment));
    }

    public GlProgramAsset(FunctionCall creatingFunctionCall, AssetItemID id) {
        this(creatingFunctionCall, id, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID);
    }

    public GlProgramAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId) {
        super(creatingFunctionCall, id, uniqueInstanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceTransientState(FunctionCall functionCall, ProgramColour programColour, ProgramResourceDescriptorMap programResources) {
        List<TransientState> list = this.transientState;
        synchronized (list) {
            TransientState lastTransientState;
            FunctionCallID callID = functionCall.getID();
            TransientState transientState = lastTransientState = !this.transientState.isEmpty() ? this.transientState.get(this.transientState.size() - 1) : null;
            if (lastTransientState != null) {
                if (lastTransientState.getBounds().isClosedRange() || lastTransientState.getBounds().getFrom().compareTo(callID) >= 0) {
                    throw new IllegalArgumentException("Call processing out of order");
                }
                lastTransientState.setClosingFunctionID(callID);
            }
            TransientState newTransientState = new TransientState(callID, programColour, programResources);
            this.transientState.add(newTransientState);
            this.createNewUniforms(functionCall, programResources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setDeleted(@NonNull FunctionCall deletingFunction) {
        List<TransientState> list = this.transientState;
        synchronized (list) {
            TransientState lastTransientState;
            super.setDeleted(deletingFunction);
            TransientState transientState = lastTransientState = !this.transientState.isEmpty() ? this.transientState.get(this.transientState.size() - 1) : null;
            if (lastTransientState != null && !lastTransientState.getBounds().isClosedRange()) {
                lastTransientState.setClosingFunctionID(deletingFunction.getID());
            }
        }
    }

    private void createNewUniforms(FunctionCall functionCall, ProgramResourceDescriptorMap programResourceDescriptor) {
        Map<Long, ProgramResourceDescriptor> uniformsMap = programResourceDescriptor.getResourcesMap(KapiSpec.GLES.constants.GL_UNIFORM);
        Map<Long, ProgramResourceDescriptor> uniformBlocksMap = programResourceDescriptor.getResourcesMap(KapiSpec.GLES.constants.GL_UNIFORM_BLOCK);
        this.deleteAllChildren(KapiSpec.GLES.assetTables.UNIFORM_TRAITS, functionCall);
        for (ProgramResourceDescriptor uniform : uniformsMap.values()) {
            ProgramResourceDescriptor block = uniformBlocksMap.get(uniform.resolveBlockIndex());
            ShaderUniform uniformAsset = new ShaderUniform(functionCall, this, uniform, block);
            this.addChildAsset(uniformAsset);
        }
    }

    public final class TransientState {
        private FunctionCallIDRange bounds;
        private final ProgramColour programColour;
        private final ProgramResourceDescriptorMap programResources;

        public TransientState(FunctionCallID callID, ProgramColour programColour, ProgramResourceDescriptorMap programResources) {
            this.bounds = new FunctionCallIDRange(callID, null);
            this.programColour = programColour;
            this.programResources = programResources;
        }

        public FunctionCallIDRange getBounds() {
            return this.bounds;
        }

        public ProgramColour getProgramColour() {
            return this.programColour;
        }

        public ProgramResourceDescriptorMap getProgramResources() {
            return this.programResources;
        }

        private void setClosingFunctionID(FunctionCallID id) {
            assert (!this.bounds.isClosedRange());
            this.bounds = new FunctionCallIDRange(this.bounds.getFrom(), id);
        }
    }

    public static final class Value
    extends AbstractGlProgramAsset.Value {
        public Value(ClosedFunctionCallIDRange functionCallRange, GlProgramAsset assetObject, IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset>> attachedShaders, IAssetPropertyValue<@Nullable ComputeWorkgroupSize> computeWorkGroupSize, IAssetPropertyValue<@NonNull Boolean> deleted, IAssetPropertyValue<@NonNull Boolean> linked, IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset>> linkedShaders, IAssetPropertyValue<@NonNull String> programInfoLog, IAssetPropertyValue<@NonNull Boolean> separable, IAssetPropertyValue<@NonNull Boolean> validated) {
            super(functionCallRange, assetObject, attachedShaders, computeWorkGroupSize, deleted, linked, linkedShaders, programInfoLog, separable, validated);
        }
    }
}

