/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.gles;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AbstractAssetContainerMap;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.gles.GlAtomicCounterBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlBufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlImageUnitAsset;
import com.arm.mgd.lightweight.asset.gles.GlProgramAsset;
import com.arm.mgd.lightweight.asset.gles.GlProgramPipelineAsset;
import com.arm.mgd.lightweight.asset.gles.GlQueryObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlRenderbufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlSamplerAsset;
import com.arm.mgd.lightweight.asset.gles.GlShaderAsset;
import com.arm.mgd.lightweight.asset.gles.GlShaderStorageBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlSyncObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureUnitAsset;
import com.arm.mgd.lightweight.asset.gles.GlTransformFeedbackAsset;
import com.arm.mgd.lightweight.asset.gles.GlTransformFeedbackBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlUniformBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexArrayObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexAttributeNonArrayValueAsset;
import com.arm.mgd.lightweight.model.GlesContext;
import com.arm.mgd.lightweight.model.api.GLESApi;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class AllGlesAssets {

    public static final class CurrentAssetProvider {
        private final @NonNull GlesContext glesContext;

        public CurrentAssetProvider(@NonNull GlesContext glesContext) {
            this.glesContext = glesContext;
        }

        private @NonNull PerContextAssets getPerContextAssets() {
            return this.glesContext.getPerContextAssets();
        }

        private @NonNull PerContextGroupAssets getPerContextGroupAssets() {
            return this.glesContext.getContextGroup().getPerContextGroupAssets();
        }

        public @Nullable GlBufferAsset getGlBufferAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlBufferAsset result = this.getPerContextGroupAssets().getLastGlBufferAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlProgramAsset getGlProgramAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlProgramAsset result = this.getPerContextGroupAssets().getLastGlProgramAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlRenderbufferAsset getGlRenderbufferAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlRenderbufferAsset result = this.getPerContextGroupAssets().getLastGlRenderbufferAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlSamplerAsset getGlSamplerAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlSamplerAsset result = this.getPerContextGroupAssets().getLastGlSamplerAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlShaderAsset getGlShaderAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlShaderAsset result = this.getPerContextGroupAssets().getLastGlShaderAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlSyncObjectAsset getGlSyncObjectAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlSyncObjectAsset result = this.getPerContextGroupAssets().getLastGlSyncObjectAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlTextureAsset getGlTextureAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlTextureAsset result = this.getPerContextGroupAssets().getLastGlTextureAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlAtomicCounterBufferBindingPointAsset getGlAtomicCounterBufferBindingPointAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlAtomicCounterBufferBindingPointAsset result = this.getPerContextAssets().getLastGlAtomicCounterBufferBindingPointAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlFramebufferAsset getGlFramebufferAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlFramebufferAsset result = this.getPerContextAssets().getLastGlFramebufferAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlImageUnitAsset getGlImageUnitAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlImageUnitAsset result = this.getPerContextAssets().getLastGlImageUnitAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlProgramPipelineAsset getGlProgramPipelineAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlProgramPipelineAsset result = this.getPerContextAssets().getLastGlProgramPipelineAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlQueryObjectAsset getGlQueryObjectAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlQueryObjectAsset result = this.getPerContextAssets().getLastGlQueryObjectAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlShaderStorageBufferBindingPointAsset getGlShaderStorageBufferBindingPointAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlShaderStorageBufferBindingPointAsset result = this.getPerContextAssets().getLastGlShaderStorageBufferBindingPointAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlTextureUnitAsset getGlTextureUnitAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlTextureUnitAsset result = this.getPerContextAssets().getLastGlTextureUnitAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlTransformFeedbackAsset getGlTransformFeedbackAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlTransformFeedbackAsset result = this.getPerContextAssets().getLastGlTransformFeedbackAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlTransformFeedbackBufferBindingPointAsset getGlTransformFeedbackBufferBindingPointAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlTransformFeedbackBufferBindingPointAsset result = this.getPerContextAssets().getLastGlTransformFeedbackBufferBindingPointAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlUniformBindingPointAsset getGlUniformBindingPointAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlUniformBindingPointAsset result = this.getPerContextAssets().getLastGlUniformBindingPointAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlVertexArrayObjectAsset getGlVertexArrayObjectAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlVertexArrayObjectAsset result = this.getPerContextAssets().getLastGlVertexArrayObjectAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable GlVertexAttributeNonArrayValueAsset getGlVertexAttributeNonArrayValueAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            GlVertexAttributeNonArrayValueAsset result = this.getPerContextAssets().getLastGlVertexAttributeNonArrayValueAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }
    }

    public static final class GlobalAssets
    extends AbstractAssetContainerMap<IAssetItem<GLESApi, ?>> {
        @Override
        public boolean isAcceptableClass(AssetTableSpec assetTableSpec) {
            return false;
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> assetClass) {
            return false;
        }
    }

    public static final class PerContextAssets
    extends AbstractAssetContainerMap<IAssetItem<GLESApi, ?>> {
        @Override
        public boolean isAcceptableClass(AssetTableSpec assetTableSpec) {
            if (KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.IMAGE_UNIT_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.QUERY_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            return KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_NON_ARRAY_VALUE_TRAITS.SPEC.equals(assetTableSpec);
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> assetClass) {
            if (GlAtomicCounterBufferBindingPointAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlFramebufferAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlImageUnitAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlProgramPipelineAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlQueryObjectAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlShaderStorageBufferBindingPointAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlTextureUnitAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlTransformFeedbackAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlTransformFeedbackBufferBindingPointAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlUniformBindingPointAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlVertexArrayObjectAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            return GlVertexAttributeNonArrayValueAsset.class.isAssignableFrom(assetClass);
        }

        public @Nullable GlAtomicCounterBufferBindingPointAsset getLastGlAtomicCounterBufferBindingPointAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlFramebufferAsset getLastGlFramebufferAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlImageUnitAsset getLastGlImageUnitAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.IMAGE_UNIT_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlProgramPipelineAsset getLastGlProgramPipelineAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlQueryObjectAsset getLastGlQueryObjectAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.QUERY_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlShaderStorageBufferBindingPointAsset getLastGlShaderStorageBufferBindingPointAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlTextureUnitAsset getLastGlTextureUnitAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlTransformFeedbackAsset getLastGlTransformFeedbackAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlTransformFeedbackBufferBindingPointAsset getLastGlTransformFeedbackBufferBindingPointAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlUniformBindingPointAsset getLastGlUniformBindingPointAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlVertexArrayObjectAsset getLastGlVertexArrayObjectAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlVertexAttributeNonArrayValueAsset getLastGlVertexAttributeNonArrayValueAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_NON_ARRAY_VALUE_TRAITS, id, functionCallID, live);
        }
    }

    public static final class PerContextGroupAssets
    extends AbstractAssetContainerMap<IAssetItem<GLESApi, ?>> {
        @Override
        public boolean isAcceptableClass(AssetTableSpec assetTableSpec) {
            if (KapiSpec.GLES.assetTables.BUFFER_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.SAMPLER_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.GLES.assetTables.SYNC_OBJECT_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            return KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC.equals(assetTableSpec);
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> assetClass) {
            if (GlBufferAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlProgramAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlRenderbufferAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlSamplerAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlShaderAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (GlSyncObjectAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            return GlTextureAsset.class.isAssignableFrom(assetClass);
        }

        public @Nullable GlBufferAsset getLastGlBufferAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.BUFFER_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlProgramAsset getLastGlProgramAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlRenderbufferAsset getLastGlRenderbufferAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlSamplerAsset getLastGlSamplerAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlShaderAsset getLastGlShaderAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.SHADER_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlSyncObjectAsset getLastGlSyncObjectAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.SYNC_OBJECT_TRAITS, id, functionCallID, live);
        }

        public @Nullable GlTextureAsset getLastGlTextureAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, id, functionCallID, live);
        }
    }
}

