/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.egl.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.egl.EglConfigAsset;
import com.arm.mgd.lightweight.asset.egl.EglDisplayAsset;
import com.arm.mgd.lightweight.asset.egl.EglSurfaceAsset;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemWithParent;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.model.api.EGLApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractEglSurfaceAsset<SUB_TYPE extends EglSurfaceAsset<SUB_TYPE, VALUE_TYPE>, VALUE_TYPE extends EglSurfaceAsset.Value<SUB_TYPE, VALUE_TYPE>>
extends AbstractAssetItemWithParent<EGLApi, VALUE_TYPE, EglDisplayAsset> {
    private final ImmutablePropertyValue<@NonNull EglConfigAsset> config;

    protected AbstractEglSurfaceAsset(FunctionCall creatingFunctionCall, EglDisplayAsset parentAsset, AssetItemID id, UniqueInstanceId uniqueInstanceId, EglConfigAsset config) {
        super(creatingFunctionCall, parentAsset, id, uniqueInstanceId);
        this.config = new ImmutablePropertyValue<EglConfigAsset>(this, EglSurfaceAssetProperties.PROPERTY_CONFIG, config);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(EglSurfaceAssetProperties.PROPERTY_ATTRIBUTES, EglSurfaceAssetProperties.PROPERTY_CONFIG, EglSurfaceAssetProperties.PROPERTY_LOCKED, EglSurfaceAssetProperties.PROPERTY_PENDING_ATTRIBUTES));
    }

    public ImmutablePropertyValue<@NonNull EglConfigAsset> getImmutablePropertyConfig() {
        return this.config;
    }

    @Override
    public String getAssetTypeLabel() {
        return "EglSurfaceAsset";
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS.SPEC;
    }

    public abstract String toString();

    @Override
    public abstract IAssetItemLifecycleManager<SUB_TYPE> getLifecycleManager();

    public static class EglSurfaceAssetProperties {
        public static final SimpleAssetProperty<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long>> PROPERTY_ATTRIBUTES = new SimpleAssetProperty("attributes");
        public static final SimpleAssetProperty<@NonNull EglConfigAsset> PROPERTY_CONFIG = new SimpleAssetProperty("config");
        public static final SimpleAssetProperty<@Nullable Boolean> PROPERTY_LOCKED = new SimpleAssetProperty("locked");
        public static final SimpleAssetProperty<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long>> PROPERTY_PENDING_ATTRIBUTES = new SimpleAssetProperty("pendingAttributes");
    }

    public static abstract class Value<SUB_TYPE extends EglSurfaceAsset<SUB_TYPE, VALUE_TYPE>, VALUE_TYPE extends EglSurfaceAsset.Value<SUB_TYPE, VALUE_TYPE>>
    extends AbstractAssetItemValue<SUB_TYPE> {
        private final IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long>> attributes;
        private final IAssetPropertyValue<@NonNull EglConfigAsset> config;
        private final IAssetPropertyValue<@Nullable Boolean> locked;
        private final IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long>> pendingAttributes;

        public Value(ClosedFunctionCallIDRange functionCallRange, SUB_TYPE assetObject, IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long>> attributes, IAssetPropertyValue<@NonNull EglConfigAsset> config, IAssetPropertyValue<@Nullable Boolean> locked, IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long>> pendingAttributes, IAssetPropertyValue<?> ... propertyValues) {
            super(functionCallRange, assetObject, Value.join(propertyValues, attributes, config, locked, pendingAttributes));
            this.attributes = attributes;
            this.config = config;
            this.locked = locked;
            this.pendingAttributes = pendingAttributes;
        }

        public final IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long>> getAttributes() {
            return this.attributes;
        }

        public final IAssetPropertyValue<@NonNull EglConfigAsset> getConfig() {
            return this.config;
        }

        public final IAssetPropertyValue<@Nullable Boolean> getLocked() {
            return this.locked;
        }

        public final IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long>> getPendingAttributes() {
            return this.pendingAttributes;
        }

        public abstract String toString();
    }
}

