/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.egl.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.egl.EglDisplayAsset;
import com.arm.mgd.lightweight.asset.egl.EglImageAsset;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemWithParent;
import com.arm.mgd.lightweight.asset.lifecycle.AutoRetainedAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.egl.EglAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.model.api.EGLApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractEglImageAsset
extends AbstractAssetItemWithParent<EGLApi, EglImageAsset.Value, EglDisplayAsset> {
    private final ImmutablePropertyValue<@Nullable Pointer> clientObjectID;
    private final ImmutablePropertyValue<@Nullable EglContextAsset> sourceContext;
    private final ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> target;
    private final IAssetItemLifecycleManager<EglImageAsset> lifecycleManager;

    protected AbstractEglImageAsset(FunctionCall creatingFunctionCall, EglDisplayAsset parentAsset, AssetItemID id, UniqueInstanceId uniqueInstanceId, @Nullable Pointer clientObjectID, @Nullable EglContextAsset sourceContext, AbstractConstantOrAliasSpecExtended target) {
        super(creatingFunctionCall, parentAsset, id, uniqueInstanceId);
        this.clientObjectID = new ImmutablePropertyValue<Pointer>(this, EglImageAssetProperties.PROPERTY_CLIENT_OBJECT_ID, clientObjectID);
        this.sourceContext = new ImmutablePropertyValue<EglContextAsset>(this, EglImageAssetProperties.PROPERTY_SOURCE_CONTEXT, sourceContext);
        this.target = new ImmutablePropertyValue<AbstractConstantOrAliasSpecExtended>(this, EglImageAssetProperties.PROPERTY_TARGET, target);
        this.lifecycleManager = new AutoRetainedAssetLifecycleManager<EglImageAsset>((EglImageAsset)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(EglImageAssetProperties.PROPERTY_ATTRIBUTES, EglImageAssetProperties.PROPERTY_CLIENT_OBJECT_ID, EglImageAssetProperties.PROPERTY_SOURCE_CONTEXT, EglImageAssetProperties.PROPERTY_TARGET));
    }

    public ImmutablePropertyValue<@Nullable Pointer> getImmutablePropertyClientObjectId() {
        return this.clientObjectID;
    }

    public ImmutablePropertyValue<@Nullable EglContextAsset> getImmutablePropertySourceContext() {
        return this.sourceContext;
    }

    public ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getImmutablePropertyTarget() {
        return this.target;
    }

    @Override
    public String getAssetTypeLabel() {
        return "EglImageAsset";
    }

    @Override
    protected EglImageAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<EGLApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return EglAssetValueProcessor.EglImageAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (EglImageAsset)this, lastCallID);
    }

    @Override
    protected EglImageAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<EGLApi> callbacks, ICoreProgressMonitor progressMonitor, EglImageAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return EglAssetValueProcessor.EglImageAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.EGL.assetTables.EGLIMAGE_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("EglImageAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("clientObjectID = ").append(this.getImmutablePropertyClientObjectId()).append(", ").append("sourceContext = ").append(this.getImmutablePropertySourceContext()).append(", ").append("target = ").append(this.getImmutablePropertyTarget()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<EglImageAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<EGLApi, ?>> getImmutablePropertyAssetDependencies() {
        HashSet<@NonNull IAssetItem<EGLApi, ?>> result = new HashSet();
        IAssetItem assetValue = this.getImmutablePropertySourceContext().getValue();
        if (assetValue != null) {
            result.add(assetValue);
        }
        return result;
    }

    public static class EglImageAssetProperties {
        public static final SimpleAssetProperty<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long>> PROPERTY_ATTRIBUTES = new SimpleAssetProperty("attributes");
        public static final SimpleAssetProperty<@Nullable Pointer> PROPERTY_CLIENT_OBJECT_ID = new SimpleAssetProperty("clientObjectID");
        public static final SimpleAssetProperty<@Nullable EglContextAsset> PROPERTY_SOURCE_CONTEXT = new SimpleAssetProperty("sourceContext");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_TARGET = new SimpleAssetProperty("target");
    }

    public static abstract class Value
    extends AbstractAssetItemValue<EglImageAsset> {
        private final IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long>> attributes;
        private final IAssetPropertyValue<@Nullable Pointer> clientObjectID;
        private final IAssetPropertyValue<@Nullable EglContextAsset> sourceContext;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> target;

        public Value(ClosedFunctionCallIDRange functionCallRange, EglImageAsset assetObject, IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long>> attributes, IAssetPropertyValue<@Nullable Pointer> clientObjectID, IAssetPropertyValue<@Nullable EglContextAsset> sourceContext, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> target) {
            super(functionCallRange, assetObject, attributes, clientObjectID, sourceContext, target);
            this.attributes = attributes;
            this.clientObjectID = clientObjectID;
            this.sourceContext = sourceContext;
            this.target = target;
        }

        public final IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long>> getAttributes() {
            return this.attributes;
        }

        public final IAssetPropertyValue<@Nullable Pointer> getClientObjectId() {
            return this.clientObjectID;
        }

        public final IAssetPropertyValue<@Nullable EglContextAsset> getSourceContext() {
            return this.sourceContext;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getTarget() {
            return this.target;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("EglImageAsset#").append(((EglImageAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("attributes = ").append(this.getAttributes()).append(", ").append("clientObjectID = ").append(this.getClientObjectId()).append(", ").append("sourceContext = ").append(this.getSourceContext()).append(", ").append("target = ").append(this.getTarget()).append("}");
            return result.toString();
        }
    }
}

