/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.egl.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.IAssetItemWithParent;
import com.arm.mgd.lightweight.asset.egl.EglConfigAsset;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.egl.EglDisplayAsset;
import com.arm.mgd.lightweight.asset.egl.EglImageAsset;
import com.arm.mgd.lightweight.asset.egl.EglPbufferSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglPixmapSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglSyncAsset;
import com.arm.mgd.lightweight.asset.egl.EglWindowSurfaceAsset;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemWithChildren;
import com.arm.mgd.lightweight.asset.lifecycle.AutoRetainedAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.egl.EglAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.model.api.EGLApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractEglDisplayAsset
extends AbstractAssetItemWithChildren<EGLApi, EglDisplayAsset.Value, IAssetItemWithParent<EGLApi, ?, EglDisplayAsset>> {
    private final ImmutablePropertyValue<@Nullable Pointer> nativeDisplayID;
    private final IAssetItemLifecycleManager<EglDisplayAsset> lifecycleManager;

    protected AbstractEglDisplayAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, @Nullable Pointer nativeDisplayID) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.nativeDisplayID = new ImmutablePropertyValue<Pointer>(this, EglDisplayAssetProperties.PROPERTY_NATIVE_DISPLAY_ID, nativeDisplayID);
        this.lifecycleManager = new AutoRetainedAssetLifecycleManager<EglDisplayAsset>((EglDisplayAsset)this, this.lifecycleManagerPrivateInterface, true);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(EglDisplayAssetProperties.PROPERTY_NATIVE_DISPLAY_ID));
    }

    public ImmutablePropertyValue<@Nullable Pointer> getImmutablePropertyNativeDisplayId() {
        return this.nativeDisplayID;
    }

    @Override
    public String getAssetTypeLabel() {
        return "EglDisplayAsset";
    }

    @Override
    protected EglDisplayAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<EGLApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return EglAssetValueProcessor.EglDisplayAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (EglDisplayAsset)this, lastCallID);
    }

    @Override
    protected EglDisplayAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<EGLApi> callbacks, ICoreProgressMonitor progressMonitor, EglDisplayAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return EglAssetValueProcessor.EglDisplayAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS.SPEC;
    }

    @Override
    public void addChildAsset(EglConfigAsset newAsset) {
        super.addChildAsset(newAsset);
    }

    public @Nullable EglConfigAsset getEglConfigAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, boolean live) {
        EglConfigAsset result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, id, functionCallID, live);
        if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCallID) || !live && !result.getLifecycleManager().isAssetRetained(functionCallID)) {
            return null;
        }
        return result;
    }

    public @Nullable EglConfigAsset getEglConfigAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, @Nullable Long specificInstanceId) {
        EglConfigAsset result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, id, functionCallID, specificInstanceId);
        return result;
    }

    @Override
    public void addChildAsset(EglContextAsset newAsset) {
        super.addChildAsset(newAsset);
    }

    public @Nullable EglContextAsset getEglContextAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, boolean live) {
        EglContextAsset result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, id, functionCallID, live);
        if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCallID) || !live && !result.getLifecycleManager().isAssetRetained(functionCallID)) {
            return null;
        }
        return result;
    }

    public @Nullable EglContextAsset getEglContextAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, @Nullable Long specificInstanceId) {
        EglContextAsset result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, id, functionCallID, specificInstanceId);
        return result;
    }

    @Override
    public void addChildAsset(EglImageAsset newAsset) {
        super.addChildAsset(newAsset);
    }

    public @Nullable EglImageAsset getEglImageAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, boolean live) {
        EglImageAsset result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLIMAGE_TRAITS, id, functionCallID, live);
        if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCallID) || !live && !result.getLifecycleManager().isAssetRetained(functionCallID)) {
            return null;
        }
        return result;
    }

    public @Nullable EglImageAsset getEglImageAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, @Nullable Long specificInstanceId) {
        EglImageAsset result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLIMAGE_TRAITS, id, functionCallID, specificInstanceId);
        return result;
    }

    public @Nullable EglSurfaceAsset<?, ?> getEglSurfaceAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, boolean live) {
        EglSurfaceAsset<?, ?> result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, id, functionCallID, live);
        if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCallID) || !live && !result.getLifecycleManager().isAssetRetained(functionCallID)) {
            return null;
        }
        return result;
    }

    public @Nullable EglSurfaceAsset<?, ?> getEglSurfaceAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, @Nullable Long specificInstanceId) {
        EglSurfaceAsset<?, ?> result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, id, functionCallID, specificInstanceId);
        return result;
    }

    @Override
    public void addChildAsset(EglSyncAsset newAsset) {
        super.addChildAsset(newAsset);
    }

    public @Nullable EglSyncAsset getEglSyncAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, boolean live) {
        EglSyncAsset result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLSYNC_TRAITS, id, functionCallID, live);
        if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCallID) || !live && !result.getLifecycleManager().isAssetRetained(functionCallID)) {
            return null;
        }
        return result;
    }

    public @Nullable EglSyncAsset getEglSyncAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, @Nullable Long specificInstanceId) {
        EglSyncAsset result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLSYNC_TRAITS, id, functionCallID, specificInstanceId);
        return result;
    }

    @Override
    public void addChildAsset(EglPbufferSurfaceAsset newAsset) {
        super.addChildAsset(newAsset);
    }

    public @Nullable EglPbufferSurfaceAsset getEglPbufferSurfaceAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, boolean live) {
        EglSurfaceAsset<?, ?> result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, id, functionCallID, live);
        if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCallID) || !live && !result.getLifecycleManager().isAssetRetained(functionCallID)) {
            return null;
        }
        if (!(result instanceof EglPbufferSurfaceAsset)) {
            return null;
        }
        return (EglPbufferSurfaceAsset)result;
    }

    public @Nullable EglPbufferSurfaceAsset getEglPbufferSurfaceAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, @Nullable Long specificInstanceId) {
        EglSurfaceAsset<?, ?> result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, id, functionCallID, specificInstanceId);
        if (!(result instanceof EglPbufferSurfaceAsset)) {
            return null;
        }
        return (EglPbufferSurfaceAsset)result;
    }

    @Override
    public void addChildAsset(EglPixmapSurfaceAsset newAsset) {
        super.addChildAsset(newAsset);
    }

    public @Nullable EglPixmapSurfaceAsset getEglPixmapSurfaceAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, boolean live) {
        EglSurfaceAsset<?, ?> result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, id, functionCallID, live);
        if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCallID) || !live && !result.getLifecycleManager().isAssetRetained(functionCallID)) {
            return null;
        }
        if (!(result instanceof EglPixmapSurfaceAsset)) {
            return null;
        }
        return (EglPixmapSurfaceAsset)result;
    }

    public @Nullable EglPixmapSurfaceAsset getEglPixmapSurfaceAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, @Nullable Long specificInstanceId) {
        EglSurfaceAsset<?, ?> result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, id, functionCallID, specificInstanceId);
        if (!(result instanceof EglPixmapSurfaceAsset)) {
            return null;
        }
        return (EglPixmapSurfaceAsset)result;
    }

    @Override
    public void addChildAsset(EglWindowSurfaceAsset newAsset) {
        super.addChildAsset(newAsset);
    }

    public @Nullable EglWindowSurfaceAsset getEglWindowSurfaceAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, boolean live) {
        EglSurfaceAsset<?, ?> result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, id, functionCallID, live);
        if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCallID) || !live && !result.getLifecycleManager().isAssetRetained(functionCallID)) {
            return null;
        }
        if (!(result instanceof EglWindowSurfaceAsset)) {
            return null;
        }
        return (EglWindowSurfaceAsset)result;
    }

    public @Nullable EglWindowSurfaceAsset getEglWindowSurfaceAssetAt(@NonNull FunctionCallID functionCallID, @NonNull AssetItemID id, @Nullable Long specificInstanceId) {
        EglSurfaceAsset<?, ?> result = this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, id, functionCallID, specificInstanceId);
        if (!(result instanceof EglWindowSurfaceAsset)) {
            return null;
        }
        return (EglWindowSurfaceAsset)result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("EglDisplayAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("nativeDisplayID = ").append(this.getImmutablePropertyNativeDisplayId()).append(", ").append("EglConfigAsset = ").append(this.getAllChildren(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS)).append(", ").append("EglContextAsset = ").append(this.getAllChildren(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS)).append(", ").append("EglImageAsset = ").append(this.getAllChildren(KapiSpec.EGL.assetTables.EGLIMAGE_TRAITS)).append(", ").append("EglSurfaceAsset = ").append(this.getAllChildren(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS)).append(", ").append("EglSyncAsset = ").append(this.getAllChildren(KapiSpec.EGL.assetTables.EGLSYNC_TRAITS)).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<EglDisplayAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<EGLApi, ?>> getImmutablePropertyAssetDependencies() {
        return Collections.emptySet();
    }

    @Override
    protected void setDeleted(FunctionCall functionCall) {
        super.setDeleted(functionCall);
        this.deleteAllChildren(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, functionCall);
        this.deleteAllChildren(KapiSpec.EGL.assetTables.EGLIMAGE_TRAITS, functionCall);
        this.deleteAllChildren(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, functionCall);
        this.deleteAllChildren(KapiSpec.EGL.assetTables.EGLSYNC_TRAITS, functionCall);
        this.deleteAllChildren(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, functionCall);
        this.deleteAllChildren(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, functionCall);
        this.deleteAllChildren(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, functionCall);
    }

    public static class EglDisplayAssetProperties {
        public static final SimpleAssetProperty<@Nullable Pointer> PROPERTY_NATIVE_DISPLAY_ID = new SimpleAssetProperty("nativeDisplayID");
    }

    public static abstract class Value
    extends AbstractAssetItemValue<EglDisplayAsset> {
        private final IAssetPropertyValue<@Nullable Pointer> nativeDisplayID;

        public Value(ClosedFunctionCallIDRange functionCallRange, EglDisplayAsset assetObject, IAssetPropertyValue<@Nullable Pointer> nativeDisplayID) {
            super(functionCallRange, assetObject, nativeDisplayID);
            this.nativeDisplayID = nativeDisplayID;
        }

        public final IAssetPropertyValue<@Nullable Pointer> getNativeDisplayId() {
            return this.nativeDisplayID;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("EglDisplayAsset#").append(((EglDisplayAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("nativeDisplayID = ").append(this.getNativeDisplayId()).append("}");
            return result.toString();
        }
    }
}

