/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.egl.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.egl.EglConfigAsset;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.egl.EglDisplayAsset;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemWithParent;
import com.arm.mgd.lightweight.asset.lifecycle.AutoRetainedAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.egl.EglAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.model.api.EGLApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractEglContextAsset
extends AbstractAssetItemWithParent<EGLApi, EglContextAsset.Value, EglDisplayAsset> {
    private final ImmutablePropertyValue<@NonNull EglConfigAsset> config;
    private final ImmutablePropertyValue<@Nullable EglContextAsset> sharedContext;
    private final IAssetItemLifecycleManager<EglContextAsset> lifecycleManager;

    protected AbstractEglContextAsset(FunctionCall creatingFunctionCall, EglDisplayAsset parentAsset, AssetItemID id, UniqueInstanceId uniqueInstanceId, EglConfigAsset config, @Nullable EglContextAsset sharedContext) {
        super(creatingFunctionCall, parentAsset, id, uniqueInstanceId);
        this.config = new ImmutablePropertyValue<EglConfigAsset>(this, EglContextAssetProperties.PROPERTY_CONFIG, config);
        this.sharedContext = new ImmutablePropertyValue<EglContextAsset>(this, EglContextAssetProperties.PROPERTY_SHARED_CONTEXT, sharedContext);
        this.lifecycleManager = new AutoRetainedAssetLifecycleManager<EglContextAsset>((EglContextAsset)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(EglContextAssetProperties.PROPERTY_ATTRIBUTES, EglContextAssetProperties.PROPERTY_CONFIG, EglContextAssetProperties.PROPERTY_SHARED_CONTEXT));
    }

    public ImmutablePropertyValue<@NonNull EglConfigAsset> getImmutablePropertyConfig() {
        return this.config;
    }

    public ImmutablePropertyValue<@Nullable EglContextAsset> getImmutablePropertySharedContext() {
        return this.sharedContext;
    }

    @Override
    public String getAssetTypeLabel() {
        return "EglContextAsset";
    }

    @Override
    protected EglContextAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<EGLApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return EglAssetValueProcessor.EglContextAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (EglContextAsset)this, lastCallID);
    }

    @Override
    protected EglContextAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<EGLApi> callbacks, ICoreProgressMonitor progressMonitor, EglContextAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return EglAssetValueProcessor.EglContextAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("EglContextAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("config = ").append(this.getImmutablePropertyConfig()).append(", ").append("sharedContext = ").append(this.getImmutablePropertySharedContext()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<EglContextAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<EGLApi, ?>> getImmutablePropertyAssetDependencies() {
        HashSet<@NonNull IAssetItem<EGLApi, ?>> result = new HashSet();
        IAssetItem assetValue = this.getImmutablePropertyConfig().getValue();
        if (assetValue != null) {
            result.add(assetValue);
        }
        if ((assetValue = (IAssetItem)this.getImmutablePropertySharedContext().getValue()) != null) {
            result.add(assetValue);
        }
        return result;
    }

    public static class EglContextAssetProperties {
        public static final SimpleAssetProperty<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long>> PROPERTY_ATTRIBUTES = new SimpleAssetProperty("attributes");
        public static final SimpleAssetProperty<@NonNull EglConfigAsset> PROPERTY_CONFIG = new SimpleAssetProperty("config");
        public static final SimpleAssetProperty<@Nullable EglContextAsset> PROPERTY_SHARED_CONTEXT = new SimpleAssetProperty("sharedContext");
    }

    public static abstract class Value
    extends AbstractAssetItemValue<EglContextAsset> {
        private final IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long>> attributes;
        private final IAssetPropertyValue<@NonNull EglConfigAsset> config;
        private final IAssetPropertyValue<@Nullable EglContextAsset> sharedContext;

        public Value(ClosedFunctionCallIDRange functionCallRange, EglContextAsset assetObject, IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long>> attributes, IAssetPropertyValue<@NonNull EglConfigAsset> config, IAssetPropertyValue<@Nullable EglContextAsset> sharedContext) {
            super(functionCallRange, assetObject, attributes, config, sharedContext);
            this.attributes = attributes;
            this.config = config;
            this.sharedContext = sharedContext;
        }

        public final IAssetPropertyValue<@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long>> getAttributes() {
            return this.attributes;
        }

        public final IAssetPropertyValue<@NonNull EglConfigAsset> getConfig() {
            return this.config;
        }

        public final IAssetPropertyValue<@Nullable EglContextAsset> getSharedContext() {
            return this.sharedContext;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("EglContextAsset#").append(((EglContextAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("attributes = ").append(this.getAttributes()).append(", ").append("config = ").append(this.getConfig()).append(", ").append("sharedContext = ").append(this.getSharedContext()).append("}");
            return result.toString();
        }
    }
}

