/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.egl;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AbstractAssetContainerMap;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.egl.EglDisplayAsset;
import com.arm.mgd.lightweight.model.EglModel;
import com.arm.mgd.lightweight.model.api.EGLApi;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class AllEglAssets {

    public static final class CurrentAssetProvider {
        private final @NonNull EglModel apiModel;

        public CurrentAssetProvider(@NonNull EglModel apiModel) {
            this.apiModel = apiModel;
        }

        private @NonNull GlobalAssets getGlobalAssets() {
            return this.apiModel.getGlobalAssets();
        }

        public @Nullable EglDisplayAsset getEglDisplayAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            EglDisplayAsset result = this.getGlobalAssets().getLastEglDisplayAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }
    }

    public static final class GlobalAssets
    extends AbstractAssetContainerMap<IAssetItem<EGLApi, ?>> {
        @Override
        public boolean isAcceptableClass(AssetTableSpec assetTableSpec) {
            return KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS.SPEC.equals(assetTableSpec);
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> assetClass) {
            return EglDisplayAsset.class.isAssignableFrom(assetClass);
        }

        public @Nullable EglDisplayAsset getLastEglDisplayAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, id, functionCallID, live);
        }
    }

    public static final class PerContextAssets
    extends AbstractAssetContainerMap<IAssetItem<EGLApi, ?>> {
        @Override
        public boolean isAcceptableClass(AssetTableSpec assetTableSpec) {
            return false;
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> assetClass) {
            return false;
        }
    }

    public static final class PerContextGroupAssets
    extends AbstractAssetContainerMap<IAssetItem<EGLApi, ?>> {
        @Override
        public boolean isAcceptableClass(AssetTableSpec assetTableSpec) {
            return false;
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> assetClass) {
            return false;
        }
    }
}

