/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.cl.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.cl.ClContextAsset;
import com.arm.mgd.lightweight.asset.cl.ClProgramAsset;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.ReferenceCountedAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.cl.ClAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.model.api.CLApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractClProgramAsset
extends AbstractAssetItem<CLApi, ClProgramAsset.Value> {
    private final ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset;
    private final IAssetItemLifecycleManager<ClProgramAsset> lifecycleManager;

    protected AbstractClProgramAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, ClContextAsset contextAsset) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.contextAsset = new ImmutablePropertyValue<ClContextAsset>(this, ClProgramAssetProperties.PROPERTY_CONTEXT_ASSET, contextAsset);
        this.lifecycleManager = new ReferenceCountedAssetLifecycleManager<ClProgramAsset>((ClProgramAsset)this, this.lifecycleManagerPrivateInterface, true);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(ClProgramAssetProperties.PROPERTY_BUILD_OPTIONS, ClProgramAssetProperties.PROPERTY_CONTEXT_ASSET));
    }

    public ImmutablePropertyValue<@NonNull ClContextAsset> getImmutablePropertyContextAsset() {
        return this.contextAsset;
    }

    @Override
    public String getAssetTypeLabel() {
        return "ClProgramAsset";
    }

    @Override
    protected ClProgramAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<CLApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return ClAssetValueProcessor.ClProgramAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (ClProgramAsset)this, lastCallID);
    }

    @Override
    protected ClProgramAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<CLApi> callbacks, ICoreProgressMonitor progressMonitor, ClProgramAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return ClAssetValueProcessor.ClProgramAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.CL.assetTables.PROGRAM_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("ClProgramAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("contextAsset = ").append(this.getImmutablePropertyContextAsset()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<ClProgramAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<CLApi, ?>> getImmutablePropertyAssetDependencies() {
        HashSet<@NonNull IAssetItem<CLApi, ?>> result = new HashSet();
        IAssetItem assetValue = this.getImmutablePropertyContextAsset().getValue();
        if (assetValue != null) {
            result.add(assetValue);
        }
        return result;
    }

    public static class ClProgramAssetProperties {
        public static final SimpleAssetProperty<@Nullable String> PROPERTY_BUILD_OPTIONS = new SimpleAssetProperty("buildOptions");
        public static final SimpleAssetProperty<@NonNull ClContextAsset> PROPERTY_CONTEXT_ASSET = new SimpleAssetProperty("contextAsset");
    }

    public static abstract class Value
    extends AbstractAssetItemValue<ClProgramAsset> {
        private final IAssetPropertyValue<@Nullable String> buildOptions;
        private final IAssetPropertyValue<@NonNull ClContextAsset> contextAsset;

        public Value(ClosedFunctionCallIDRange functionCallRange, ClProgramAsset assetObject, IAssetPropertyValue<@Nullable String> buildOptions, IAssetPropertyValue<@NonNull ClContextAsset> contextAsset) {
            super(functionCallRange, assetObject, buildOptions, contextAsset);
            this.buildOptions = buildOptions;
            this.contextAsset = contextAsset;
        }

        public final IAssetPropertyValue<@Nullable String> getBuildOptions() {
            return this.buildOptions;
        }

        public final IAssetPropertyValue<@NonNull ClContextAsset> getContextAsset() {
            return this.contextAsset;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("ClProgramAsset#").append(((ClProgramAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("buildOptions = ").append(this.getBuildOptions()).append(", ").append("contextAsset = ").append(this.getContextAsset()).append("}");
            return result.toString();
        }
    }
}

