/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.cl.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.cl.ClContextAsset;
import com.arm.mgd.lightweight.asset.cl.ClMemoryAsset;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.model.api.CLApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractClMemoryAsset<SUB_TYPE extends ClMemoryAsset<SUB_TYPE, VALUE_TYPE>, VALUE_TYPE extends ClMemoryAsset.Value<SUB_TYPE, VALUE_TYPE>>
extends AbstractAssetItem<CLApi, VALUE_TYPE> {
    private final ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset;
    private final ImmutablePropertyValue<@NonNull Bitfield> flags;

    protected AbstractClMemoryAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, ClContextAsset contextAsset, Bitfield flags) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.contextAsset = new ImmutablePropertyValue<ClContextAsset>(this, ClMemoryAssetProperties.PROPERTY_CONTEXT_ASSET, contextAsset);
        this.flags = new ImmutablePropertyValue<Bitfield>(this, ClMemoryAssetProperties.PROPERTY_FLAGS, flags);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(ClMemoryAssetProperties.PROPERTY_CONTEXT_ASSET, ClMemoryAssetProperties.PROPERTY_FLAGS));
    }

    public ImmutablePropertyValue<@NonNull ClContextAsset> getImmutablePropertyContextAsset() {
        return this.contextAsset;
    }

    public ImmutablePropertyValue<@NonNull Bitfield> getImmutablePropertyFlags() {
        return this.flags;
    }

    @Override
    public String getAssetTypeLabel() {
        return "ClMemoryAsset";
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.CL.assetTables.MEMORY_TRAITS.SPEC;
    }

    public abstract String toString();

    @Override
    public abstract IAssetItemLifecycleManager<SUB_TYPE> getLifecycleManager();

    public static class ClMemoryAssetProperties {
        public static final SimpleAssetProperty<@NonNull ClContextAsset> PROPERTY_CONTEXT_ASSET = new SimpleAssetProperty("contextAsset");
        public static final SimpleAssetProperty<@NonNull Bitfield> PROPERTY_FLAGS = new SimpleAssetProperty("flags");
    }

    public static abstract class Value<SUB_TYPE extends ClMemoryAsset<SUB_TYPE, VALUE_TYPE>, VALUE_TYPE extends ClMemoryAsset.Value<SUB_TYPE, VALUE_TYPE>>
    extends AbstractAssetItemValue<SUB_TYPE> {
        private final IAssetPropertyValue<@NonNull ClContextAsset> contextAsset;
        private final IAssetPropertyValue<@NonNull Bitfield> flags;

        public Value(ClosedFunctionCallIDRange functionCallRange, SUB_TYPE assetObject, IAssetPropertyValue<@NonNull ClContextAsset> contextAsset, IAssetPropertyValue<@NonNull Bitfield> flags, IAssetPropertyValue<?> ... propertyValues) {
            super(functionCallRange, assetObject, Value.join(propertyValues, contextAsset, flags));
            this.contextAsset = contextAsset;
            this.flags = flags;
        }

        public final IAssetPropertyValue<@NonNull ClContextAsset> getContextAsset() {
            return this.contextAsset;
        }

        public final IAssetPropertyValue<@NonNull Bitfield> getFlags() {
            return this.flags;
        }

        public abstract String toString();
    }
}

