/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.cl.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.cl.ClKernelAsset;
import com.arm.mgd.lightweight.asset.cl.ClProgramAsset;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.ReferenceCountedAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.cl.ClAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.model.api.CLApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractClKernelAsset
extends AbstractAssetItem<CLApi, ClKernelAsset.Value> {
    private final ImmutablePropertyValue<@NonNull String> kernelName;
    private final ImmutablePropertyValue<@NonNull ClProgramAsset> programAsset;
    private final IAssetItemLifecycleManager<ClKernelAsset> lifecycleManager;

    protected AbstractClKernelAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, String kernelName, ClProgramAsset programAsset) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.kernelName = new ImmutablePropertyValue<String>(this, ClKernelAssetProperties.PROPERTY_KERNEL_NAME, kernelName);
        this.programAsset = new ImmutablePropertyValue<ClProgramAsset>(this, ClKernelAssetProperties.PROPERTY_PROGRAM_ASSET, programAsset);
        this.lifecycleManager = new ReferenceCountedAssetLifecycleManager<ClKernelAsset>((ClKernelAsset)this, this.lifecycleManagerPrivateInterface, true);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(ClKernelAssetProperties.PROPERTY_KERNEL_NAME, ClKernelAssetProperties.PROPERTY_PROGRAM_ASSET));
    }

    public ImmutablePropertyValue<@NonNull String> getImmutablePropertyKernelName() {
        return this.kernelName;
    }

    public ImmutablePropertyValue<@NonNull ClProgramAsset> getImmutablePropertyProgramAsset() {
        return this.programAsset;
    }

    @Override
    public String getAssetTypeLabel() {
        return "ClKernelAsset";
    }

    @Override
    protected ClKernelAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<CLApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return ClAssetValueProcessor.ClKernelAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (ClKernelAsset)this, lastCallID);
    }

    @Override
    protected ClKernelAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<CLApi> callbacks, ICoreProgressMonitor progressMonitor, ClKernelAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return ClAssetValueProcessor.ClKernelAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.CL.assetTables.KERNEL_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("ClKernelAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("kernelName = ").append(this.getImmutablePropertyKernelName()).append(", ").append("programAsset = ").append(this.getImmutablePropertyProgramAsset()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<ClKernelAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<CLApi, ?>> getImmutablePropertyAssetDependencies() {
        HashSet<@NonNull IAssetItem<CLApi, ?>> result = new HashSet();
        IAssetItem assetValue = this.getImmutablePropertyProgramAsset().getValue();
        if (assetValue != null) {
            result.add(assetValue);
        }
        return result;
    }

    public static class ClKernelAssetProperties {
        public static final SimpleAssetProperty<@NonNull String> PROPERTY_KERNEL_NAME = new SimpleAssetProperty("kernelName");
        public static final SimpleAssetProperty<@NonNull ClProgramAsset> PROPERTY_PROGRAM_ASSET = new SimpleAssetProperty("programAsset");
    }

    public static abstract class Value
    extends AbstractAssetItemValue<ClKernelAsset> {
        private final IAssetPropertyValue<@NonNull String> kernelName;
        private final IAssetPropertyValue<@NonNull ClProgramAsset> programAsset;

        public Value(ClosedFunctionCallIDRange functionCallRange, ClKernelAsset assetObject, IAssetPropertyValue<@NonNull String> kernelName, IAssetPropertyValue<@NonNull ClProgramAsset> programAsset) {
            super(functionCallRange, assetObject, kernelName, programAsset);
            this.kernelName = kernelName;
            this.programAsset = programAsset;
        }

        public final IAssetPropertyValue<@NonNull String> getKernelName() {
            return this.kernelName;
        }

        public final IAssetPropertyValue<@NonNull ClProgramAsset> getProgramAsset() {
            return this.programAsset;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("ClKernelAsset#").append(((ClKernelAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("kernelName = ").append(this.getKernelName()).append(", ").append("programAsset = ").append(this.getProgramAsset()).append("}");
            return result.toString();
        }
    }
}

