/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.cl.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.cl.ClContextAsset;
import com.arm.mgd.lightweight.asset.cl.ClImageMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.ClMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.gen.AbstractClMemoryAsset;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.ReferenceCountedAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.cl.ClAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.model.api.CLApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractClImageMemoryAsset
extends ClMemoryAsset<ClImageMemoryAsset, ClImageMemoryAsset.Value> {
    private final ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> channelDataType;
    private final ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> channelOrder;
    private final ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type;
    private final IAssetItemLifecycleManager<ClImageMemoryAsset> lifecycleManager;

    protected AbstractClImageMemoryAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, ClContextAsset contextAsset, Bitfield flags, AbstractConstantOrAliasSpecExtended channelDataType, AbstractConstantOrAliasSpecExtended channelOrder, AbstractConstantOrAliasSpecExtended type) {
        super(creatingFunctionCall, id, uniqueInstanceId, contextAsset, flags);
        this.channelDataType = new ImmutablePropertyValue<AbstractConstantOrAliasSpecExtended>(this, ClImageMemoryAssetProperties.PROPERTY_CHANNEL_DATA_TYPE, channelDataType);
        this.channelOrder = new ImmutablePropertyValue<AbstractConstantOrAliasSpecExtended>(this, ClImageMemoryAssetProperties.PROPERTY_CHANNEL_ORDER, channelOrder);
        this.type = new ImmutablePropertyValue<AbstractConstantOrAliasSpecExtended>(this, ClImageMemoryAssetProperties.PROPERTY_TYPE, type);
        this.lifecycleManager = new ReferenceCountedAssetLifecycleManager<ClImageMemoryAsset>((ClImageMemoryAsset)this, this.lifecycleManagerPrivateInterface, true);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        ArrayList result = new ArrayList(super.getAllProperties());
        result.add(ClImageMemoryAssetProperties.PROPERTY_CHANNEL_DATA_TYPE);
        result.add(ClImageMemoryAssetProperties.PROPERTY_CHANNEL_ORDER);
        result.add(ClImageMemoryAssetProperties.PROPERTY_DEPTH);
        result.add(ClImageMemoryAssetProperties.PROPERTY_HEIGHT);
        result.add(ClImageMemoryAssetProperties.PROPERTY_TYPE);
        result.add(ClImageMemoryAssetProperties.PROPERTY_WIDTH);
        return Collections.unmodifiableList(result);
    }

    public ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getImmutablePropertyChannelDataType() {
        return this.channelDataType;
    }

    public ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getImmutablePropertyChannelOrder() {
        return this.channelOrder;
    }

    public ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getImmutablePropertyType() {
        return this.type;
    }

    @Override
    public String getAssetTypeLabel() {
        return "ClImageMemoryAsset";
    }

    @Override
    protected ClImageMemoryAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<CLApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return ClAssetValueProcessor.ClImageMemoryAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (ClImageMemoryAsset)this, lastCallID);
    }

    @Override
    protected ClImageMemoryAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<CLApi> callbacks, ICoreProgressMonitor progressMonitor, ClImageMemoryAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return ClAssetValueProcessor.ClImageMemoryAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.CL.assetTables.MEMORY_TRAITS.SPEC;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("ClImageMemoryAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("contextAsset = ").append(this.getImmutablePropertyContextAsset()).append(", ").append("flags = ").append(this.getImmutablePropertyFlags()).append(", ").append("channelDataType = ").append(this.getImmutablePropertyChannelDataType()).append(", ").append("channelOrder = ").append(this.getImmutablePropertyChannelOrder()).append(", ").append("type = ").append(this.getImmutablePropertyType()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<ClImageMemoryAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<CLApi, ?>> getImmutablePropertyAssetDependencies() {
        HashSet<@NonNull IAssetItem<CLApi, ?>> result = new HashSet();
        IAssetItem assetValue = this.getImmutablePropertyContextAsset().getValue();
        if (assetValue != null) {
            result.add(assetValue);
        }
        return result;
    }

    public static class ClImageMemoryAssetProperties
    extends AbstractClMemoryAsset.ClMemoryAssetProperties {
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_CHANNEL_DATA_TYPE = new SimpleAssetProperty("channelDataType");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_CHANNEL_ORDER = new SimpleAssetProperty("channelOrder");
        public static final SimpleAssetProperty<@Nullable Long> PROPERTY_DEPTH = new SimpleAssetProperty("depth");
        public static final SimpleAssetProperty<@Nullable Long> PROPERTY_HEIGHT = new SimpleAssetProperty("height");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_TYPE = new SimpleAssetProperty("type");
        public static final SimpleAssetProperty<@Nullable Long> PROPERTY_WIDTH = new SimpleAssetProperty("width");
    }

    public static abstract class Value
    extends ClMemoryAsset.Value<ClImageMemoryAsset, ClImageMemoryAsset.Value> {
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> channelDataType;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> channelOrder;
        private final IAssetPropertyValue<@Nullable Long> depth;
        private final IAssetPropertyValue<@Nullable Long> height;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type;
        private final IAssetPropertyValue<@Nullable Long> width;

        public Value(ClosedFunctionCallIDRange functionCallRange, ClImageMemoryAsset assetObject, IAssetPropertyValue<@NonNull ClContextAsset> contextAsset, IAssetPropertyValue<@NonNull Bitfield> flags, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> channelDataType, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> channelOrder, IAssetPropertyValue<@Nullable Long> depth, IAssetPropertyValue<@Nullable Long> height, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type, IAssetPropertyValue<@Nullable Long> width) {
            super(functionCallRange, assetObject, contextAsset, flags, (IAssetPropertyValue<?>[])new IAssetPropertyValue[]{channelDataType, channelOrder, depth, height, type, width});
            this.channelDataType = channelDataType;
            this.channelOrder = channelOrder;
            this.depth = depth;
            this.height = height;
            this.type = type;
            this.width = width;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getChannelDataType() {
            return this.channelDataType;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getChannelOrder() {
            return this.channelOrder;
        }

        public final IAssetPropertyValue<@Nullable Long> getDepth() {
            return this.depth;
        }

        public final IAssetPropertyValue<@Nullable Long> getHeight() {
            return this.height;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getType() {
            return this.type;
        }

        public final IAssetPropertyValue<@Nullable Long> getWidth() {
            return this.width;
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("ClImageMemoryAsset#").append(((ClImageMemoryAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("contextAsset = ").append(this.getContextAsset()).append(", ").append("flags = ").append(this.getFlags()).append(", ").append("channelDataType = ").append(this.getChannelDataType()).append(", ").append("channelOrder = ").append(this.getChannelOrder()).append(", ").append("depth = ").append(this.getDepth()).append(", ").append("height = ").append(this.getHeight()).append(", ").append("type = ").append(this.getType()).append(", ").append("width = ").append(this.getWidth()).append("}");
            return result.toString();
        }
    }
}

