/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.cl;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AbstractAssetContainerMap;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.cl.ClContextAsset;
import com.arm.mgd.lightweight.asset.cl.ClKernelAsset;
import com.arm.mgd.lightweight.asset.cl.ClMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.ClProgramAsset;
import com.arm.mgd.lightweight.model.ClModel;
import com.arm.mgd.lightweight.model.api.CLApi;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class AllClAssets {

    public static final class CurrentAssetProvider {
        private final @NonNull ClModel apiModel;

        public CurrentAssetProvider(@NonNull ClModel apiModel) {
            this.apiModel = apiModel;
        }

        private @NonNull GlobalAssets getGlobalAssets() {
            return this.apiModel.getGlobalAssets();
        }

        public @Nullable ClContextAsset getClContextAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            ClContextAsset result = this.getGlobalAssets().getLastClContextAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable ClKernelAsset getClKernelAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            ClKernelAsset result = this.getGlobalAssets().getLastClKernelAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable ClMemoryAsset getClMemoryAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            ClMemoryAsset result = this.getGlobalAssets().getLastClMemoryAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable ClProgramAsset getClProgramAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            ClProgramAsset result = this.getGlobalAssets().getLastClProgramAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }
    }

    public static final class GlobalAssets
    extends AbstractAssetContainerMap<IAssetItem<CLApi, ?>> {
        @Override
        public boolean isAcceptableClass(AssetTableSpec assetTableSpec) {
            if (KapiSpec.CL.assetTables.CONTEXT_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.CL.assetTables.KERNEL_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.CL.assetTables.MEMORY_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            return KapiSpec.CL.assetTables.PROGRAM_TRAITS.SPEC.equals(assetTableSpec);
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> assetClass) {
            if (ClContextAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (ClKernelAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (ClMemoryAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            return ClProgramAsset.class.isAssignableFrom(assetClass);
        }

        public @Nullable ClContextAsset getLastClContextAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.CL.assetTables.CONTEXT_TRAITS, id, functionCallID, live);
        }

        public @Nullable ClKernelAsset getLastClKernelAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.CL.assetTables.KERNEL_TRAITS, id, functionCallID, live);
        }

        public @Nullable ClMemoryAsset getLastClMemoryAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.CL.assetTables.MEMORY_TRAITS, id, functionCallID, live);
        }

        public @Nullable ClProgramAsset getLastClProgramAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.CL.assetTables.PROGRAM_TRAITS, id, functionCallID, live);
        }
    }

    public static final class PerContextAssets
    extends AbstractAssetContainerMap<IAssetItem<CLApi, ?>> {
        @Override
        public boolean isAcceptableClass(AssetTableSpec assetTableSpec) {
            return false;
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> assetClass) {
            return false;
        }
    }

    public static final class PerContextGroupAssets
    extends AbstractAssetContainerMap<IAssetItem<CLApi, ?>> {
        @Override
        public boolean isAcceptableClass(AssetTableSpec assetTableSpec) {
            return false;
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> assetClass) {
            return false;
        }
    }
}

