/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset;

import com.arm.mgd.core.asset.ComputeWorkgroupSize;
import com.arm.mgd.core.asset.objects.gen.AllAssetClasses;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.LightweightAssetBuilder;
import com.arm.mgd.core.midstream.LightweightAssetValueBuilder;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.egl.EglConfigAsset;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.egl.EglDisplayAsset;
import com.arm.mgd.lightweight.asset.egl.EglImageAsset;
import com.arm.mgd.lightweight.asset.egl.EglPbufferSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglPixmapSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglSyncAsset;
import com.arm.mgd.lightweight.asset.egl.EglWindowSurfaceAsset;
import com.arm.mgd.lightweight.asset.gles.GlAtomicCounterBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlBufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferRenderbufferAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferTextureAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferTextureMultiviewAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferZeroAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlImageUnitAsset;
import com.arm.mgd.lightweight.asset.gles.GlProgramAsset;
import com.arm.mgd.lightweight.asset.gles.GlProgramPipelineAsset;
import com.arm.mgd.lightweight.asset.gles.GlQueryObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlRenderbufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlSamplerAsset;
import com.arm.mgd.lightweight.asset.gles.GlShaderAsset;
import com.arm.mgd.lightweight.asset.gles.GlShaderStorageBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlSyncObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureImageAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureSurfaceAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureUnitAsset;
import com.arm.mgd.lightweight.asset.gles.GlTransformFeedbackAsset;
import com.arm.mgd.lightweight.asset.gles.GlTransformFeedbackBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlUniformBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexArrayObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexAttributeAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexAttributeNonArrayValueAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexBufferBindingAsset;
import com.arm.mgd.lightweight.asset.gles.ShaderUniform;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetProcessorBase;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.gles.AbstractGlesAssetValueProcessorBase;
import com.arm.mgd.lightweight.asset.properties.ByteArrayPropertyValue;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.ListPropertyValue;
import com.arm.mgd.lightweight.asset.properties.MapPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ShaderUniformValuePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimplePropertyValue;
import com.arm.mgd.lightweight.model.api.EGLApi;
import com.arm.mgd.lightweight.model.api.GLESApi;
import com.arm.mgd.utils.NullUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MidstreamAssetFactory {
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_IMAGE_UNIT_ASSET_ACCESS = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_READ_WRITE, KapiSpec.GLES.constants.GL_READ_ONLY, KapiSpec.GLES.constants.GL_WRITE_ONLY));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_IMAGE_UNIT_ASSET_FORMAT = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_RGBA32I, KapiSpec.GLES.constants.GL_RGBA8I, KapiSpec.GLES.constants.GL_R32F, KapiSpec.GLES.constants.GL_RGBA8UI, KapiSpec.GLES.constants.GL_R32I, KapiSpec.GLES.constants.GL_RGBA8, KapiSpec.GLES.constants.GL_R32UI, KapiSpec.GLES.constants.GL_RGBA32UI, KapiSpec.GLES.constants.GL_RGBA16F, KapiSpec.GLES.constants.GL_RGBA8_SNORM, KapiSpec.GLES.constants.GL_RGBA16I, KapiSpec.GLES.constants.GL_RGBA16UI, KapiSpec.GLES.constants.GL_RGBA32F));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_QUERY_OBJECT_ASSET_QUERY_TARGET = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_ANY_SAMPLES_PASSED, KapiSpec.GLES.constants.GL_TIME_ELAPSED_EXT, KapiSpec.GLES.constants.GL_ANY_SAMPLES_PASSED_CONSERVATIVE, KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, KapiSpec.GLES.constants.GL_TIMESTAMP_EXT, KapiSpec.GLES.constants.GL_PRIMITIVES_GENERATED));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_SHADER_ASSET_TYPE = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_TESS_CONTROL_SHADER, KapiSpec.GLES.constants.GL_COMPUTE_SHADER, KapiSpec.GLES.constants.GL_GEOMETRY_SHADER, KapiSpec.GLES.constants.GL_FRAGMENT_SHADER, KapiSpec.GLES.constants.GL_TESS_EVALUATION_SHADER, KapiSpec.GLES.constants.GL_VERTEX_SHADER));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_SYNC_OBJECT_ASSET_CONDITION = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_SYNC_GPU_COMMANDS_COMPLETE));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_SYNC_OBJECT_ASSET_FLAGS = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_ZERO));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_SYNC_OBJECT_ASSET_STATUS = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_UNSIGNALED, KapiSpec.GLES.constants.GL_SIGNALED));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_SYNC_OBJECT_ASSET_TYPE = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_SYNC_FENCE));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_EGL_IMAGE_ASSET_TARGET = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_GL_RENDERBUFFER_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Y_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_X_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_2D_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Z_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_KHR, KapiSpec.EGL.constants.EGL_NATIVE_BUFFER_ANDROID, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_X_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_3D_KHR));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_EGL_SYNC_ASSET_STATUS = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_UNSIGNALED_KHR, KapiSpec.EGL.constants.EGL_SIGNALED_KHR));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_EGL_SYNC_ASSET_TYPE = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_SYNC_NATIVE_FENCE_ANDROID, KapiSpec.EGL.constants.EGL_SYNC_REUSABLE_KHR, KapiSpec.EGL.constants.EGL_SYNC_CL_EVENT_KHR, KapiSpec.EGL.constants.EGL_SYNC_FENCE_KHR));

    public static <API_MODEL, TYPE extends IAssetItem<API_MODEL, ?>, PARENT extends IAssetItem<API_MODEL, ?>> @NonNull TYPE findExisting(@NonNull LightweightAssetBuilder<API_MODEL> builder, @NonNull FindExistingAssetHelper helper, @NonNull KapiSpec.AssetTraits<?, TYPE, ?> traits, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @Nullable PARENT parentAsset) {
        LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks = builder.getCallbacks();
        AssetItemID id = AssetItemID.valueOf(assetAttachment.getId());
        long instanceId = assetAttachment.getInstanceCounter();
        AllAssetClasses classEnum = traits.ENUM;
        assert (classEnum != null);
        switch (classEnum) {
            case GL_ATOMIC_COUNTER_BUFFER_BINDING_POINT_ASSET: {
                return (TYPE)helper.findGlAtomicCounterBufferBindingPointAsset(callbacks, functionCall, id);
            }
            case GL_BUFFER_ASSET: {
                return (TYPE)helper.findGlBufferAsset(callbacks, functionCall, id, instanceId);
            }
            case GL_FRAMEBUFFER_ASSET: {
                return (TYPE)helper.findGlFramebufferAsset(callbacks, functionCall, id, instanceId);
            }
            case GL_IMAGE_UNIT_ASSET: {
                return (TYPE)helper.findGlImageUnitAsset(callbacks, functionCall, id);
            }
            case GL_PROGRAM_ASSET: {
                return (TYPE)helper.findGlProgramAsset(callbacks, functionCall, id, instanceId);
            }
            case GL_PROGRAM_PIPELINE_ASSET: {
                return (TYPE)helper.findGlProgramPipelineAsset(callbacks, functionCall, id, instanceId);
            }
            case GL_QUERY_OBJECT_ASSET: {
                return (TYPE)helper.findGlQueryObjectAsset(callbacks, functionCall, id, instanceId);
            }
            case GL_RENDERBUFFER_ASSET: {
                return (TYPE)helper.findGlRenderbufferAsset(callbacks, functionCall, id, instanceId);
            }
            case GL_SAMPLER_ASSET: {
                return (TYPE)helper.findGlSamplerAsset(callbacks, functionCall, id, instanceId);
            }
            case GL_SHADER_ASSET: {
                return (TYPE)helper.findGlShaderAsset(callbacks, functionCall, id, instanceId);
            }
            case GL_SHADER_STORAGE_BUFFER_BINDING_POINT_ASSET: {
                return (TYPE)helper.findGlShaderStorageBufferBindingPointAsset(callbacks, functionCall, id);
            }
            case GL_SYNC_OBJECT_ASSET: {
                return (TYPE)helper.findGlSyncObjectAsset(callbacks, functionCall, id, instanceId);
            }
            case GL_TEXTURE_ASSET: {
                return (TYPE)helper.findGlTextureAsset(callbacks, functionCall, id, instanceId);
            }
            case GL_TEXTURE_UNIT_ASSET: {
                return (TYPE)helper.findGlTextureUnitAsset(callbacks, functionCall, id);
            }
            case GL_TRANSFORM_FEEDBACK_ASSET: {
                return (TYPE)helper.findGlTransformFeedbackAsset(callbacks, functionCall, id, instanceId);
            }
            case GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_POINT_ASSET: {
                return (TYPE)helper.findGlTransformFeedbackBufferBindingPointAsset(callbacks, functionCall, id);
            }
            case GL_UNIFORM_BINDING_POINT_ASSET: {
                return (TYPE)helper.findGlUniformBindingPointAsset(callbacks, functionCall, id);
            }
            case GL_VERTEX_ARRAY_OBJECT_ASSET: {
                return (TYPE)helper.findGlVertexArrayObjectAsset(callbacks, functionCall, id, instanceId);
            }
            case GL_VERTEX_ATTRIBUTE_NON_ARRAY_VALUE_ASSET: {
                return (TYPE)helper.findGlVertexAttributeNonArrayValueAsset(callbacks, functionCall, id);
            }
            case GL_TEXTURE_IMAGE_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlTextureImageAsset(callbacks, functionCall, id, instanceId, (GlTextureSurfaceAsset)parentAsset);
                }
                return null;
            }
            case GL_TEXTURE_SURFACE_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlTextureSurfaceAsset(callbacks, functionCall, id, instanceId, (GlTextureAsset)parentAsset);
                }
                return null;
            }
            case GL_VERTEX_ATTRIBUTE_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlVertexAttributeAsset(callbacks, functionCall, id, (GlVertexArrayObjectAsset)parentAsset);
                }
                return null;
            }
            case GL_VERTEX_BUFFER_BINDING_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlVertexBufferBindingAsset(callbacks, functionCall, id, (GlVertexArrayObjectAsset)parentAsset);
                }
                return null;
            }
            case SHADER_UNIFORM: {
                if (parentAsset != null) {
                    return (TYPE)helper.findShaderUniform(callbacks, functionCall, id, instanceId, (GlProgramAsset)parentAsset);
                }
                return null;
            }
            case GL_FRAMEBUFFER_RENDERBUFFER_ATTACHMENT_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlFramebufferRenderbufferAttachmentAsset(callbacks, functionCall, id, instanceId, (GlFramebufferAsset)parentAsset);
                }
                return null;
            }
            case GL_FRAMEBUFFER_TEXTURE_ATTACHMENT_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlFramebufferTextureAttachmentAsset(callbacks, functionCall, id, instanceId, (GlFramebufferAsset)parentAsset);
                }
                return null;
            }
            case GL_FRAMEBUFFER_TEXTURE_MULTIVIEW_ATTACHMENT_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlFramebufferTextureMultiviewAttachmentAsset(callbacks, functionCall, id, instanceId, (GlFramebufferAsset)parentAsset);
                }
                return null;
            }
            case GL_FRAMEBUFFER_ZERO_ATTACHMENT_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlFramebufferZeroAttachmentAsset(callbacks, functionCall, id, instanceId, (GlFramebufferAsset)parentAsset);
                }
                return null;
            }
            case EGL_DISPLAY_ASSET: {
                return (TYPE)helper.findEglDisplayAsset(callbacks, functionCall, id, instanceId);
            }
            case EGL_CONFIG_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findEglConfigAsset(callbacks, functionCall, id, (EglDisplayAsset)parentAsset);
                }
                return null;
            }
            case EGL_CONTEXT_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findEglContextAsset(callbacks, functionCall, id, instanceId, (EglDisplayAsset)parentAsset);
                }
                return null;
            }
            case EGL_IMAGE_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findEglImageAsset(callbacks, functionCall, id, instanceId, (EglDisplayAsset)parentAsset);
                }
                return null;
            }
            case EGL_SYNC_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findEglSyncAsset(callbacks, functionCall, id, instanceId, (EglDisplayAsset)parentAsset);
                }
                return null;
            }
            case EGL_PBUFFER_SURFACE_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findEglPbufferSurfaceAsset(callbacks, functionCall, id, instanceId, (EglDisplayAsset)parentAsset);
                }
                return null;
            }
            case EGL_PIXMAP_SURFACE_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findEglPixmapSurfaceAsset(callbacks, functionCall, id, instanceId, (EglDisplayAsset)parentAsset);
                }
                return null;
            }
            case EGL_WINDOW_SURFACE_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findEglWindowSurfaceAsset(callbacks, functionCall, id, instanceId, (EglDisplayAsset)parentAsset);
                }
                return null;
            }
        }
        throw new AssertionError((Object)("Unexpected asset class for midstream trace processing in findExisting: " + (Object)((Object)classEnum)));
    }

    private static @NonNull GlAtomicCounterBufferBindingPointAsset createGlAtomicCounterBufferBindingPointAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlAtomicCounterBufferBindingPointAsset newAssetObject = GlAtomicCounterBufferBindingPointAsset.createForMidstreamTrace(builder, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlAtomicCounterBufferBindingPointAsset.Value updateGlAtomicCounterBufferBindingPointAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlAtomicCounterBufferBindingPointAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlAtomicCounterBufferBindingPointAsset assetObject = (GlAtomicCounterBufferBindingPointAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@Nullable GlBufferAsset> property_buffer = new SimplePropertyValue<GlBufferAsset>(assetObjectValue.getBuffer());
        GlBufferAsset value_buffer = builder.resolveAssetProperty(assetAttachment, "buffer", GlBufferAsset.class, true, null);
        property_buffer.setValue(functionCall, value_buffer);
        SimplePropertyValue<@NonNull Long> property_length = new SimplePropertyValue<Long>(assetObjectValue.getLength());
        long value_length = builder.resolveLongProperty(assetAttachment, "length", 0L);
        property_length.setValue(functionCall, value_length);
        SimplePropertyValue<@NonNull Long> property_offset = new SimplePropertyValue<Long>(assetObjectValue.getOffset());
        long value_offset = builder.resolveLongProperty(assetAttachment, "offset", 0L);
        property_offset.setValue(functionCall, value_offset);
        return new GlAtomicCounterBufferBindingPointAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<GlBufferAsset>)property_buffer, (IAssetPropertyValue<Long>)property_length, (IAssetPropertyValue<Long>)property_offset);
    }

    private static @NonNull GlBufferAsset createGlBufferAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlBufferAsset newAssetObject = GlBufferAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlBufferAsset.Value updateGlBufferAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlBufferAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlBufferAsset assetObject = (GlBufferAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@NonNull Long> property_accessFlags = new SimplePropertyValue<Long>(assetObjectValue.getAccessFlags());
        long value_accessFlags = builder.resolveLongProperty(assetAttachment, "accessFlags", 0L);
        property_accessFlags.setValue(functionCall, value_accessFlags);
        ByteArrayPropertyValue property_data = new ByteArrayPropertyValue(assetObjectValue.getData());
        byte[] value_data = builder.resolveByteDataProperty(assetAttachment, "data", true);
        property_data.setValue(functionCall, value_data);
        SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_firstBinding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getFirstBinding());
        AbstractConstantOrAliasSpecExtended value_firstBinding = builder.resolveProperty(assetAttachment, "firstBinding", AbstractConstantOrAliasSpecExtended.class, true, null);
        property_firstBinding.setValue(functionCall, value_firstBinding);
        SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_lastBoundTarget = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getLastBoundTarget());
        AbstractConstantOrAliasSpecExtended value_lastBoundTarget = builder.resolveProperty(assetAttachment, "lastBoundTarget", AbstractConstantOrAliasSpecExtended.class, true, null);
        property_lastBoundTarget.setValue(functionCall, value_lastBoundTarget);
        SimplePropertyValue<@NonNull Long> property_mapLength = new SimplePropertyValue<Long>(assetObjectValue.getMapLength());
        long value_mapLength = builder.resolveLongProperty(assetAttachment, "mapLength", 0L);
        property_mapLength.setValue(functionCall, value_mapLength);
        SimplePropertyValue<@NonNull Long> property_mapOffset = new SimplePropertyValue<Long>(assetObjectValue.getMapOffset());
        long value_mapOffset = builder.resolveLongProperty(assetAttachment, "mapOffset", 0L);
        property_mapOffset.setValue(functionCall, value_mapOffset);
        SimplePropertyValue<@NonNull Pointer> property_mapPointer = new SimplePropertyValue<Pointer>(assetObjectValue.getMapPointer());
        Pointer value_mapPointer = builder.resolveProperty(assetAttachment, "mapPointer", Pointer.class, false, Pointer.valueOf(0L));
        property_mapPointer.setValue(functionCall, value_mapPointer);
        SimplePropertyValue<@NonNull Boolean> property_mapped = new SimplePropertyValue<Boolean>(assetObjectValue.getMapped());
        boolean value_mapped = builder.resolveBooleanProperty(assetAttachment, "mapped", false);
        property_mapped.setValue(functionCall, value_mapped);
        SimplePropertyValue<@NonNull Long> property_size = new SimplePropertyValue<Long>(assetObjectValue.getSize());
        long value_size = builder.resolveLongProperty(assetAttachment, "size", 0L);
        property_size.setValue(functionCall, value_size);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_usage = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getUsage());
        AbstractConstantOrAliasSpecExtended value_usage = builder.resolveProperty(assetAttachment, "usage", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_STATIC_DRAW);
        property_usage.setValue(functionCall, value_usage);
        return new GlBufferAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Long>)property_accessFlags, property_data, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_firstBinding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_lastBoundTarget, (IAssetPropertyValue<Long>)property_mapLength, (IAssetPropertyValue<Long>)property_mapOffset, (IAssetPropertyValue<Pointer>)property_mapPointer, (IAssetPropertyValue<Boolean>)property_mapped, (IAssetPropertyValue<Long>)property_size, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_usage);
    }

    private static @NonNull GlFramebufferAsset createGlFramebufferAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlFramebufferAsset newAssetObject = GlFramebufferAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlFramebufferAsset.Value updateGlFramebufferAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlFramebufferAsset assetObject = (GlFramebufferAsset)assetObjectValue.getAssetObject();
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull GlFramebufferAttachmentAsset<?, ?>> property_attachments = new MapPropertyValue(assetObjectValue.getAttachments());
        SimplePropertyValue<@NonNull Boolean> property_defaultFixedSampleLocations = new SimplePropertyValue<Boolean>(assetObjectValue.getDefaultFixedSampleLocations());
        boolean value_defaultFixedSampleLocations = builder.resolveBooleanProperty(assetAttachment, "defaultFixedSampleLocations", false);
        property_defaultFixedSampleLocations.setValue(functionCall, value_defaultFixedSampleLocations);
        SimplePropertyValue<@NonNull Long> property_defaultHeight = new SimplePropertyValue<Long>(assetObjectValue.getDefaultHeight());
        long value_defaultHeight = builder.resolveLongProperty(assetAttachment, "defaultHeight", 0L);
        property_defaultHeight.setValue(functionCall, value_defaultHeight);
        SimplePropertyValue<@NonNull Long> property_defaultLayers = new SimplePropertyValue<Long>(assetObjectValue.getDefaultLayers());
        long value_defaultLayers = builder.resolveLongProperty(assetAttachment, "defaultLayers", 0L);
        property_defaultLayers.setValue(functionCall, value_defaultLayers);
        SimplePropertyValue<@NonNull Long> property_defaultSamples = new SimplePropertyValue<Long>(assetObjectValue.getDefaultSamples());
        long value_defaultSamples = builder.resolveLongProperty(assetAttachment, "defaultSamples", 0L);
        property_defaultSamples.setValue(functionCall, value_defaultSamples);
        SimplePropertyValue<@NonNull Long> property_defaultWidth = new SimplePropertyValue<Long>(assetObjectValue.getDefaultWidth());
        long value_defaultWidth = builder.resolveLongProperty(assetAttachment, "defaultWidth", 0L);
        property_defaultWidth.setValue(functionCall, value_defaultWidth);
        ListPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_drawBuffers = new ListPropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getDrawBuffers());
        List<AbstractConstantOrAliasSpecExtended> value_drawBuffers = builder.resolveListProperty(assetAttachment, "drawBuffers", AbstractConstantOrAliasSpecExtended.class, false, AbstractGlesAssetValueProcessorBase.getDefaultPropertyValueForGlFramebufferAssetDrawBuffers(callbacks, assetObject));
        property_drawBuffers.setValue(functionCall, value_drawBuffers);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_readBuffer = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getReadBuffer());
        AbstractConstantOrAliasSpecExtended value_readBuffer = builder.resolveProperty(assetAttachment, "readBuffer", AbstractConstantOrAliasSpecExtended.class, false, null);
        property_readBuffer.setValue(functionCall, value_readBuffer);
        return new GlFramebufferAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, property_attachments, (IAssetPropertyValue<Boolean>)property_defaultFixedSampleLocations, (IAssetPropertyValue<Long>)property_defaultHeight, (IAssetPropertyValue<Long>)property_defaultLayers, (IAssetPropertyValue<Long>)property_defaultSamples, (IAssetPropertyValue<Long>)property_defaultWidth, (IAssetPropertyValue<List<AbstractConstantOrAliasSpecExtended>>)property_drawBuffers, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_readBuffer);
    }

    private static @NonNull GlImageUnitAsset createGlImageUnitAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlImageUnitAsset newAssetObject = GlImageUnitAsset.createForMidstreamTrace(builder, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlImageUnitAsset.Value updateGlImageUnitAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlImageUnitAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlImageUnitAsset assetObject = (GlImageUnitAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_access = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getAccess());
        AbstractConstantOrAliasSpecExtended value_access = builder.resolveConstantProperty(assetAttachment, "access", CONSTANT_SET_GL_IMAGE_UNIT_ASSET_ACCESS, false, KapiSpec.GLES.constants.GL_READ_ONLY);
        property_access.setValue(functionCall, value_access);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_format = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getFormat());
        AbstractConstantOrAliasSpecExtended value_format = builder.resolveConstantProperty(assetAttachment, "format", CONSTANT_SET_GL_IMAGE_UNIT_ASSET_FORMAT, false, KapiSpec.GLES.constants.GL_R32UI);
        property_format.setValue(functionCall, value_format);
        SimplePropertyValue<@NonNull Long> property_layer = new SimplePropertyValue<Long>(assetObjectValue.getLayer());
        long value_layer = builder.resolveLongProperty(assetAttachment, "layer", 0L);
        property_layer.setValue(functionCall, value_layer);
        SimplePropertyValue<@NonNull Boolean> property_layered = new SimplePropertyValue<Boolean>(assetObjectValue.getLayered());
        boolean value_layered = builder.resolveBooleanProperty(assetAttachment, "layered", false);
        property_layered.setValue(functionCall, value_layered);
        SimplePropertyValue<@NonNull Long> property_level = new SimplePropertyValue<Long>(assetObjectValue.getLevel());
        long value_level = builder.resolveLongProperty(assetAttachment, "level", 0L);
        property_level.setValue(functionCall, value_level);
        SimplePropertyValue<@Nullable GlTextureAsset> property_texture = new SimplePropertyValue<GlTextureAsset>(assetObjectValue.getTexture());
        GlTextureAsset value_texture = builder.resolveAssetProperty(assetAttachment, "texture", GlTextureAsset.class, true, null);
        property_texture.setValue(functionCall, value_texture);
        return new GlImageUnitAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_access, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_format, (IAssetPropertyValue<Long>)property_layer, (IAssetPropertyValue<Boolean>)property_layered, (IAssetPropertyValue<Long>)property_level, (IAssetPropertyValue<GlTextureAsset>)property_texture);
    }

    private static @NonNull GlProgramAsset createGlProgramAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlProgramAsset newAssetObject = GlProgramAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlProgramAsset.Value updateGlProgramAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlProgramAsset assetObject = (GlProgramAsset)assetObjectValue.getAssetObject();
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_attachedShaders = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, GlShaderAsset>(assetObjectValue.getAttachedShaders());
        Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset> value_attachedShaders = builder.resolveMapProperty(assetAttachment, "attachedShaders", AbstractConstantOrAliasSpecExtended.class, GlShaderAsset.class);
        property_attachedShaders.setValue(functionCall, value_attachedShaders);
        SimplePropertyValue<@Nullable ComputeWorkgroupSize> property_computeWorkGroupSize = new SimplePropertyValue<ComputeWorkgroupSize>(assetObjectValue.getComputeWorkGroupSize());
        SimplePropertyValue<@NonNull Boolean> property_deleted = new SimplePropertyValue<Boolean>(assetObjectValue.getDeleted());
        boolean value_deleted = builder.resolveBooleanProperty(assetAttachment, "deleted", false);
        property_deleted.setValue(functionCall, value_deleted);
        SimplePropertyValue<@NonNull Boolean> property_linked = new SimplePropertyValue<Boolean>(assetObjectValue.getLinked());
        boolean value_linked = builder.resolveBooleanProperty(assetAttachment, "linked", false);
        property_linked.setValue(functionCall, value_linked);
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_linkedShaders = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, GlShaderAsset>(assetObjectValue.getLinkedShaders());
        Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset> value_linkedShaders = builder.resolveMapProperty(assetAttachment, "linkedShaders", AbstractConstantOrAliasSpecExtended.class, GlShaderAsset.class);
        property_linkedShaders.setValue(functionCall, value_linkedShaders);
        SimplePropertyValue<@NonNull String> property_programInfoLog = new SimplePropertyValue<String>(assetObjectValue.getProgramInfoLog());
        String value_programInfoLog = builder.resolveProperty(assetAttachment, "programInfoLog", String.class, false, "");
        property_programInfoLog.setValue(functionCall, value_programInfoLog);
        SimplePropertyValue<@NonNull Boolean> property_separable = new SimplePropertyValue<Boolean>(assetObjectValue.getSeparable());
        boolean value_separable = builder.resolveBooleanProperty(assetAttachment, "separable", false);
        property_separable.setValue(functionCall, value_separable);
        SimplePropertyValue<@NonNull Boolean> property_validated = new SimplePropertyValue<Boolean>(assetObjectValue.getValidated());
        boolean value_validated = builder.resolveBooleanProperty(assetAttachment, "validated", false);
        property_validated.setValue(functionCall, value_validated);
        return new GlProgramAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset>>)property_attachedShaders, (IAssetPropertyValue<ComputeWorkgroupSize>)property_computeWorkGroupSize, (IAssetPropertyValue<Boolean>)property_deleted, (IAssetPropertyValue<Boolean>)property_linked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset>>)property_linkedShaders, (IAssetPropertyValue<String>)property_programInfoLog, (IAssetPropertyValue<Boolean>)property_separable, (IAssetPropertyValue<Boolean>)property_validated);
    }

    private static @NonNull GlProgramPipelineAsset createGlProgramPipelineAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlProgramPipelineAsset newAssetObject = GlProgramPipelineAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlProgramPipelineAsset.Value updateGlProgramPipelineAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlProgramPipelineAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlProgramPipelineAsset assetObject = (GlProgramPipelineAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@Nullable GlProgramAsset> property_activeProgram = new SimplePropertyValue<GlProgramAsset>(assetObjectValue.getActiveProgram());
        GlProgramAsset value_activeProgram = builder.resolveAssetProperty(assetAttachment, "activeProgram", GlProgramAsset.class, true, null);
        property_activeProgram.setValue(functionCall, value_activeProgram);
        SimplePropertyValue<@Nullable GlProgramAsset> property_computeShader = new SimplePropertyValue<GlProgramAsset>(assetObjectValue.getComputeShader());
        GlProgramAsset value_computeShader = builder.resolveAssetProperty(assetAttachment, "computeShader", GlProgramAsset.class, true, null);
        property_computeShader.setValue(functionCall, value_computeShader);
        SimplePropertyValue<@Nullable GlProgramAsset> property_fragmentShader = new SimplePropertyValue<GlProgramAsset>(assetObjectValue.getFragmentShader());
        GlProgramAsset value_fragmentShader = builder.resolveAssetProperty(assetAttachment, "fragmentShader", GlProgramAsset.class, true, null);
        property_fragmentShader.setValue(functionCall, value_fragmentShader);
        SimplePropertyValue<@Nullable GlProgramAsset> property_geometryShader = new SimplePropertyValue<GlProgramAsset>(assetObjectValue.getGeometryShader());
        GlProgramAsset value_geometryShader = builder.resolveAssetProperty(assetAttachment, "geometryShader", GlProgramAsset.class, true, null);
        property_geometryShader.setValue(functionCall, value_geometryShader);
        SimplePropertyValue<@Nullable GlProgramAsset> property_tessControlShader = new SimplePropertyValue<GlProgramAsset>(assetObjectValue.getTessControlShader());
        GlProgramAsset value_tessControlShader = builder.resolveAssetProperty(assetAttachment, "tessControlShader", GlProgramAsset.class, true, null);
        property_tessControlShader.setValue(functionCall, value_tessControlShader);
        SimplePropertyValue<@Nullable GlProgramAsset> property_tessEvaluationShader = new SimplePropertyValue<GlProgramAsset>(assetObjectValue.getTessEvaluationShader());
        GlProgramAsset value_tessEvaluationShader = builder.resolveAssetProperty(assetAttachment, "tessEvaluationShader", GlProgramAsset.class, true, null);
        property_tessEvaluationShader.setValue(functionCall, value_tessEvaluationShader);
        SimplePropertyValue<@Nullable GlProgramAsset> property_vertexShader = new SimplePropertyValue<GlProgramAsset>(assetObjectValue.getVertexShader());
        GlProgramAsset value_vertexShader = builder.resolveAssetProperty(assetAttachment, "vertexShader", GlProgramAsset.class, true, null);
        property_vertexShader.setValue(functionCall, value_vertexShader);
        return new GlProgramPipelineAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<GlProgramAsset>)property_activeProgram, (IAssetPropertyValue<GlProgramAsset>)property_computeShader, (IAssetPropertyValue<GlProgramAsset>)property_fragmentShader, (IAssetPropertyValue<GlProgramAsset>)property_geometryShader, (IAssetPropertyValue<GlProgramAsset>)property_tessControlShader, (IAssetPropertyValue<GlProgramAsset>)property_tessEvaluationShader, (IAssetPropertyValue<GlProgramAsset>)property_vertexShader);
    }

    private static @NonNull GlQueryObjectAsset createGlQueryObjectAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlQueryObjectAsset newAssetObject = GlQueryObjectAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlQueryObjectAsset.Value updateGlQueryObjectAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlQueryObjectAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlQueryObjectAsset assetObject = (GlQueryObjectAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@NonNull Long> property_queryResult = new SimplePropertyValue<Long>(assetObjectValue.getQueryResult());
        long value_queryResult = builder.resolveLongProperty(assetAttachment, "queryResult", 0L);
        property_queryResult.setValue(functionCall, value_queryResult);
        SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_queryTarget = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getQueryTarget());
        AbstractConstantOrAliasSpecExtended value_queryTarget = builder.resolveConstantProperty(assetAttachment, "queryTarget", CONSTANT_SET_GL_QUERY_OBJECT_ASSET_QUERY_TARGET, true, null);
        property_queryTarget.setValue(functionCall, value_queryTarget);
        SimplePropertyValue<@NonNull Boolean> property_resultAvailable = new SimplePropertyValue<Boolean>(assetObjectValue.getResultAvailable());
        boolean value_resultAvailable = builder.resolveBooleanProperty(assetAttachment, "resultAvailable", false);
        property_resultAvailable.setValue(functionCall, value_resultAvailable);
        return new GlQueryObjectAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Long>)property_queryResult, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_queryTarget, (IAssetPropertyValue<Boolean>)property_resultAvailable);
    }

    private static @NonNull GlRenderbufferAsset createGlRenderbufferAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlRenderbufferAsset newAssetObject = GlRenderbufferAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlRenderbufferAsset.Value updateGlRenderbufferAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlRenderbufferAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlRenderbufferAsset assetObject = (GlRenderbufferAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@NonNull Long> property_alphaSize = new SimplePropertyValue<Long>(assetObjectValue.getAlphaSize());
        long value_alphaSize = builder.resolveLongProperty(assetAttachment, "alphaSize", 0L);
        property_alphaSize.setValue(functionCall, value_alphaSize);
        SimplePropertyValue<@NonNull Long> property_blueSize = new SimplePropertyValue<Long>(assetObjectValue.getBlueSize());
        long value_blueSize = builder.resolveLongProperty(assetAttachment, "blueSize", 0L);
        property_blueSize.setValue(functionCall, value_blueSize);
        SimplePropertyValue<@NonNull Long> property_depthSize = new SimplePropertyValue<Long>(assetObjectValue.getDepthSize());
        long value_depthSize = builder.resolveLongProperty(assetAttachment, "depthSize", 0L);
        property_depthSize.setValue(functionCall, value_depthSize);
        SimplePropertyValue<@NonNull Long> property_greenSize = new SimplePropertyValue<Long>(assetObjectValue.getGreenSize());
        long value_greenSize = builder.resolveLongProperty(assetAttachment, "greenSize", 0L);
        property_greenSize.setValue(functionCall, value_greenSize);
        SimplePropertyValue<@NonNull Integer> property_height = new SimplePropertyValue<Integer>(assetObjectValue.getHeight());
        int value_height = builder.resolveIntProperty(assetAttachment, "height", 0);
        property_height.setValue(functionCall, value_height);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getInternalFormat());
        AbstractConstantOrAliasSpecExtended value_internalFormat = builder.resolveProperty(assetAttachment, "internalFormat", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_RGBA4);
        property_internalFormat.setValue(functionCall, value_internalFormat);
        SimplePropertyValue<@NonNull Long> property_redSize = new SimplePropertyValue<Long>(assetObjectValue.getRedSize());
        long value_redSize = builder.resolveLongProperty(assetAttachment, "redSize", 0L);
        property_redSize.setValue(functionCall, value_redSize);
        SimplePropertyValue<@NonNull Long> property_samples = new SimplePropertyValue<Long>(assetObjectValue.getSamples());
        long value_samples = builder.resolveLongProperty(assetAttachment, "samples", 0L);
        property_samples.setValue(functionCall, value_samples);
        SimplePropertyValue<@NonNull Long> property_stencilSize = new SimplePropertyValue<Long>(assetObjectValue.getStencilSize());
        long value_stencilSize = builder.resolveLongProperty(assetAttachment, "stencilSize", 0L);
        property_stencilSize.setValue(functionCall, value_stencilSize);
        SimplePropertyValue<@NonNull Integer> property_width = new SimplePropertyValue<Integer>(assetObjectValue.getWidth());
        int value_width = builder.resolveIntProperty(assetAttachment, "width", 0);
        property_width.setValue(functionCall, value_width);
        return new GlRenderbufferAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Long>)property_alphaSize, (IAssetPropertyValue<Long>)property_blueSize, (IAssetPropertyValue<Long>)property_depthSize, (IAssetPropertyValue<Long>)property_greenSize, (IAssetPropertyValue<Integer>)property_height, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_internalFormat, (IAssetPropertyValue<Long>)property_redSize, (IAssetPropertyValue<Long>)property_samples, (IAssetPropertyValue<Long>)property_stencilSize, (IAssetPropertyValue<Integer>)property_width);
    }

    private static @NonNull GlSamplerAsset createGlSamplerAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlSamplerAsset newAssetObject = GlSamplerAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlSamplerAsset.Value updateGlSamplerAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlSamplerAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlSamplerAsset assetObject = (GlSamplerAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<float[]> property_borderColor = new SimplePropertyValue<float[]>(assetObjectValue.getBorderColor());
        float[] value_borderColor = builder.resolveFloatArrayProperty(assetAttachment, "borderColor", false);
        property_borderColor.setValue(functionCall, value_borderColor);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getCompareFunc());
        AbstractConstantOrAliasSpecExtended value_compareFunc = builder.resolveProperty(assetAttachment, "compareFunc", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LEQUAL);
        property_compareFunc.setValue(functionCall, value_compareFunc);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getCompareMode());
        AbstractConstantOrAliasSpecExtended value_compareMode = builder.resolveProperty(assetAttachment, "compareMode", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        property_compareMode.setValue(functionCall, value_compareMode);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getMagFilter());
        AbstractConstantOrAliasSpecExtended value_magFilter = builder.resolveProperty(assetAttachment, "magFilter", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LINEAR);
        property_magFilter.setValue(functionCall, value_magFilter);
        SimplePropertyValue<@NonNull Float> property_maxLod = new SimplePropertyValue<Float>(assetObjectValue.getMaxLod());
        float value_maxLod = builder.resolveFloatProperty(assetAttachment, "maxLod", 1000.0f);
        property_maxLod.setValue(functionCall, Float.valueOf(value_maxLod));
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getMinFilter());
        AbstractConstantOrAliasSpecExtended value_minFilter = builder.resolveProperty(assetAttachment, "minFilter", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NEAREST_MIPMAP_LINEAR);
        property_minFilter.setValue(functionCall, value_minFilter);
        SimplePropertyValue<@NonNull Float> property_minLod = new SimplePropertyValue<Float>(assetObjectValue.getMinLod());
        float value_minLod = builder.resolveFloatProperty(assetAttachment, "minLod", -1000.0f);
        property_minLod.setValue(functionCall, Float.valueOf(value_minLod));
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getWrapR());
        AbstractConstantOrAliasSpecExtended value_wrapR = builder.resolveProperty(assetAttachment, "wrapR", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_REPEAT);
        property_wrapR.setValue(functionCall, value_wrapR);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getWrapS());
        AbstractConstantOrAliasSpecExtended value_wrapS = builder.resolveProperty(assetAttachment, "wrapS", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_REPEAT);
        property_wrapS.setValue(functionCall, value_wrapS);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getWrapT());
        AbstractConstantOrAliasSpecExtended value_wrapT = builder.resolveProperty(assetAttachment, "wrapT", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_REPEAT);
        property_wrapT.setValue(functionCall, value_wrapT);
        return new GlSamplerAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<float[]>)property_borderColor, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_compareFunc, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_compareMode, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_magFilter, (IAssetPropertyValue<Float>)property_maxLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_minFilter, (IAssetPropertyValue<Float>)property_minLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_wrapR, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_wrapS, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_wrapT);
    }

    private static @NonNull GlShaderAsset createGlShaderAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended type = builder.resolveConstantProperty(assetAttachment, "type", CONSTANT_SET_GL_SHADER_ASSET_TYPE, false, null);
        GlShaderAsset newAssetObject = GlShaderAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()), type);
        return newAssetObject;
    }

    private static @NonNull GlShaderAsset.Value updateGlShaderAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlShaderAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlShaderAsset assetObject = (GlShaderAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_binaryFormat = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getBinaryFormat());
        AbstractConstantOrAliasSpecExtended value_binaryFormat = builder.resolveProperty(assetAttachment, "binaryFormat", AbstractConstantOrAliasSpecExtended.class, true, null);
        property_binaryFormat.setValue(functionCall, value_binaryFormat);
        SimplePropertyValue<@NonNull Boolean> property_compiled = new SimplePropertyValue<Boolean>(assetObjectValue.getCompiled());
        boolean value_compiled = builder.resolveBooleanProperty(assetAttachment, "compiled", false);
        property_compiled.setValue(functionCall, value_compiled);
        SimplePropertyValue<@NonNull Boolean> property_deleted = new SimplePropertyValue<Boolean>(assetObjectValue.getDeleted());
        boolean value_deleted = builder.resolveBooleanProperty(assetAttachment, "deleted", false);
        property_deleted.setValue(functionCall, value_deleted);
        SimplePropertyValue<@NonNull Boolean> property_flaggedForDeletion = new SimplePropertyValue<Boolean>(assetObjectValue.getFlaggedForDeletion());
        boolean value_flaggedForDeletion = builder.resolveBooleanProperty(assetAttachment, "flaggedForDeletion", false);
        property_flaggedForDeletion.setValue(functionCall, value_flaggedForDeletion);
        SimplePropertyValue<@NonNull String> property_shaderInfoLog = new SimplePropertyValue<String>(assetObjectValue.getShaderInfoLog());
        String value_shaderInfoLog = builder.resolveProperty(assetAttachment, "shaderInfoLog", String.class, false, "");
        property_shaderInfoLog.setValue(functionCall, value_shaderInfoLog);
        SimplePropertyValue<@NonNull String> property_shaderSource = new SimplePropertyValue<String>(assetObjectValue.getShaderSource());
        String value_shaderSource = builder.resolveProperty(assetAttachment, "shaderSource", String.class, false, "");
        property_shaderSource.setValue(functionCall, value_shaderSource);
        ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type = assetObject.getImmutablePropertyType();
        return new GlShaderAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_binaryFormat, (IAssetPropertyValue<Boolean>)property_compiled, (IAssetPropertyValue<Boolean>)property_deleted, (IAssetPropertyValue<Boolean>)property_flaggedForDeletion, (IAssetPropertyValue<String>)property_shaderInfoLog, (IAssetPropertyValue<String>)property_shaderSource, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_type);
    }

    private static @NonNull GlShaderStorageBufferBindingPointAsset createGlShaderStorageBufferBindingPointAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlShaderStorageBufferBindingPointAsset newAssetObject = GlShaderStorageBufferBindingPointAsset.createForMidstreamTrace(builder, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlShaderStorageBufferBindingPointAsset.Value updateGlShaderStorageBufferBindingPointAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlShaderStorageBufferBindingPointAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlShaderStorageBufferBindingPointAsset assetObject = (GlShaderStorageBufferBindingPointAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@Nullable GlBufferAsset> property_buffer = new SimplePropertyValue<GlBufferAsset>(assetObjectValue.getBuffer());
        GlBufferAsset value_buffer = builder.resolveAssetProperty(assetAttachment, "buffer", GlBufferAsset.class, true, null);
        property_buffer.setValue(functionCall, value_buffer);
        SimplePropertyValue<@NonNull Long> property_length = new SimplePropertyValue<Long>(assetObjectValue.getLength());
        long value_length = builder.resolveLongProperty(assetAttachment, "length", 0L);
        property_length.setValue(functionCall, value_length);
        SimplePropertyValue<@NonNull Long> property_offset = new SimplePropertyValue<Long>(assetObjectValue.getOffset());
        long value_offset = builder.resolveLongProperty(assetAttachment, "offset", 0L);
        property_offset.setValue(functionCall, value_offset);
        return new GlShaderStorageBufferBindingPointAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<GlBufferAsset>)property_buffer, (IAssetPropertyValue<Long>)property_length, (IAssetPropertyValue<Long>)property_offset);
    }

    private static @NonNull GlSyncObjectAsset createGlSyncObjectAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended type = builder.resolveConstantProperty(assetAttachment, "type", CONSTANT_SET_GL_SYNC_OBJECT_ASSET_TYPE, false, null);
        GlSyncObjectAsset newAssetObject = GlSyncObjectAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()), type);
        return newAssetObject;
    }

    private static @NonNull GlSyncObjectAsset.Value updateGlSyncObjectAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlSyncObjectAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlSyncObjectAsset assetObject = (GlSyncObjectAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_condition = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getCondition());
        AbstractConstantOrAliasSpecExtended value_condition = builder.resolveConstantProperty(assetAttachment, "condition", CONSTANT_SET_GL_SYNC_OBJECT_ASSET_CONDITION, false, KapiSpec.GLES.constants.GL_SYNC_GPU_COMMANDS_COMPLETE);
        property_condition.setValue(functionCall, value_condition);
        SimplePropertyValue<@NonNull Bitfield> property_flags = new SimplePropertyValue<Bitfield>(assetObjectValue.getFlags());
        Bitfield value_flags = builder.resolveBitfieldProperty(assetAttachment, "flags", CONSTANT_SET_GL_SYNC_OBJECT_ASSET_FLAGS, false, null);
        property_flags.setValue(functionCall, value_flags);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_status = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getStatus());
        AbstractConstantOrAliasSpecExtended value_status = builder.resolveConstantProperty(assetAttachment, "status", CONSTANT_SET_GL_SYNC_OBJECT_ASSET_STATUS, false, KapiSpec.GLES.constants.GL_UNSIGNALED);
        property_status.setValue(functionCall, value_status);
        ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type = assetObject.getImmutablePropertyType();
        return new GlSyncObjectAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_condition, (IAssetPropertyValue<Bitfield>)property_flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_status, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_type);
    }

    private static @NonNull GlTextureAsset createGlTextureAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlTextureAsset newAssetObject = GlTextureAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlTextureAsset.Value updateGlTextureAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlTextureAsset assetObject = (GlTextureAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@NonNull Long> property_baseLevel = new SimplePropertyValue<Long>(assetObjectValue.getBaseLevel());
        long value_baseLevel = builder.resolveLongProperty(assetAttachment, "baseLevel", 0L);
        property_baseLevel.setValue(functionCall, value_baseLevel);
        SimplePropertyValue<float[]> property_borderColor = new SimplePropertyValue<float[]>(assetObjectValue.getBorderColor());
        float[] value_borderColor = builder.resolveFloatArrayProperty(assetAttachment, "borderColor", false);
        property_borderColor.setValue(functionCall, value_borderColor);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getCompareFunc());
        AbstractConstantOrAliasSpecExtended value_compareFunc = builder.resolveProperty(assetAttachment, "compareFunc", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LEQUAL);
        property_compareFunc.setValue(functionCall, value_compareFunc);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getCompareMode());
        AbstractConstantOrAliasSpecExtended value_compareMode = builder.resolveProperty(assetAttachment, "compareMode", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        property_compareMode.setValue(functionCall, value_compareMode);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthStencilTextureMode = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getDepthStencilTextureMode());
        AbstractConstantOrAliasSpecExtended value_depthStencilTextureMode = builder.resolveProperty(assetAttachment, "depthStencilTextureMode", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_DEPTH_COMPONENT);
        property_depthStencilTextureMode.setValue(functionCall, value_depthStencilTextureMode);
        SimplePropertyValue<@Nullable Pointer> property_eglImage = new SimplePropertyValue<Pointer>(assetObjectValue.getEglImage());
        Pointer value_eglImage = builder.resolveProperty(assetAttachment, "eglImage", Pointer.class, true, null);
        property_eglImage.setValue(functionCall, value_eglImage);
        SimplePropertyValue<@NonNull Boolean> property_everBoundToFramebuffer = new SimplePropertyValue<Boolean>(assetObjectValue.getEverBoundToFramebuffer());
        SimplePropertyValue<@NonNull Boolean> property_immutableFormat = new SimplePropertyValue<Boolean>(assetObjectValue.getImmutableFormat());
        boolean value_immutableFormat = builder.resolveBooleanProperty(assetAttachment, "immutableFormat", false);
        property_immutableFormat.setValue(functionCall, value_immutableFormat);
        SimplePropertyValue<@NonNull Long> property_immutableLevels = new SimplePropertyValue<Long>(assetObjectValue.getImmutableLevels());
        long value_immutableLevels = builder.resolveLongProperty(assetAttachment, "immutableLevels", 0L);
        property_immutableLevels.setValue(functionCall, value_immutableLevels);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getMagFilter());
        AbstractConstantOrAliasSpecExtended value_magFilter = builder.resolveProperty(assetAttachment, "magFilter", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LINEAR);
        property_magFilter.setValue(functionCall, value_magFilter);
        SimplePropertyValue<@NonNull Long> property_maxLevel = new SimplePropertyValue<Long>(assetObjectValue.getMaxLevel());
        long value_maxLevel = builder.resolveLongProperty(assetAttachment, "maxLevel", 1000L);
        property_maxLevel.setValue(functionCall, value_maxLevel);
        SimplePropertyValue<@NonNull Float> property_maxLod = new SimplePropertyValue<Float>(assetObjectValue.getMaxLod());
        float value_maxLod = builder.resolveFloatProperty(assetAttachment, "maxLod", 1000.0f);
        property_maxLod.setValue(functionCall, Float.valueOf(value_maxLod));
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getMinFilter());
        AbstractConstantOrAliasSpecExtended value_minFilter = builder.resolveProperty(assetAttachment, "minFilter", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NEAREST_MIPMAP_LINEAR);
        property_minFilter.setValue(functionCall, value_minFilter);
        SimplePropertyValue<@NonNull Float> property_minLod = new SimplePropertyValue<Float>(assetObjectValue.getMinLod());
        float value_minLod = builder.resolveFloatProperty(assetAttachment, "minLod", -1000.0f);
        property_minLod.setValue(functionCall, Float.valueOf(value_minLod));
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleA = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getSwizzleA());
        AbstractConstantOrAliasSpecExtended value_swizzleA = builder.resolveProperty(assetAttachment, "swizzleA", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_ALPHA);
        property_swizzleA.setValue(functionCall, value_swizzleA);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleB = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getSwizzleB());
        AbstractConstantOrAliasSpecExtended value_swizzleB = builder.resolveProperty(assetAttachment, "swizzleB", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_BLUE);
        property_swizzleB.setValue(functionCall, value_swizzleB);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleG = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getSwizzleG());
        AbstractConstantOrAliasSpecExtended value_swizzleG = builder.resolveProperty(assetAttachment, "swizzleG", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_GREEN);
        property_swizzleG.setValue(functionCall, value_swizzleG);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleR = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getSwizzleR());
        AbstractConstantOrAliasSpecExtended value_swizzleR = builder.resolveProperty(assetAttachment, "swizzleR", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_RED);
        property_swizzleR.setValue(functionCall, value_swizzleR);
        SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureTarget = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getTextureTarget());
        AbstractConstantOrAliasSpecExtended value_textureTarget = builder.resolveProperty(assetAttachment, "textureTarget", AbstractConstantOrAliasSpecExtended.class, true, null);
        property_textureTarget.setValue(functionCall, value_textureTarget);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getWrapR());
        AbstractConstantOrAliasSpecExtended value_wrapR = builder.resolveProperty(assetAttachment, "wrapR", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_REPEAT);
        property_wrapR.setValue(functionCall, value_wrapR);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getWrapS());
        AbstractConstantOrAliasSpecExtended value_wrapS = builder.resolveProperty(assetAttachment, "wrapS", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_REPEAT);
        property_wrapS.setValue(functionCall, value_wrapS);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getWrapT());
        AbstractConstantOrAliasSpecExtended value_wrapT = builder.resolveProperty(assetAttachment, "wrapT", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_REPEAT);
        property_wrapT.setValue(functionCall, value_wrapT);
        return new GlTextureAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Long>)property_baseLevel, (IAssetPropertyValue<float[]>)property_borderColor, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_compareFunc, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_compareMode, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_depthStencilTextureMode, (IAssetPropertyValue<Pointer>)property_eglImage, (IAssetPropertyValue<Boolean>)property_everBoundToFramebuffer, (IAssetPropertyValue<Boolean>)property_immutableFormat, (IAssetPropertyValue<Long>)property_immutableLevels, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_magFilter, (IAssetPropertyValue<Long>)property_maxLevel, (IAssetPropertyValue<Float>)property_maxLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_minFilter, (IAssetPropertyValue<Float>)property_minLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_swizzleA, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_swizzleB, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_swizzleG, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_swizzleR, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_textureTarget, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_wrapR, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_wrapS, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_wrapT);
    }

    private static @NonNull GlTextureUnitAsset createGlTextureUnitAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlTextureUnitAsset newAssetObject = GlTextureUnitAsset.createForMidstreamTrace(builder, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlTextureUnitAsset.Value updateGlTextureUnitAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlTextureUnitAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlTextureUnitAsset assetObject = (GlTextureUnitAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@Nullable GlSamplerAsset> property_sampler = new SimplePropertyValue<GlSamplerAsset>(assetObjectValue.getSampler());
        GlSamplerAsset value_sampler = builder.resolveAssetProperty(assetAttachment, "sampler", GlSamplerAsset.class, true, null);
        property_sampler.setValue(functionCall, value_sampler);
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlTextureAsset> property_textureTargets = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, GlTextureAsset>(assetObjectValue.getTextureTargets());
        Map<AbstractConstantOrAliasSpecExtended, GlTextureAsset> value_textureTargets = builder.resolveMapProperty(assetAttachment, "textureTargets", AbstractConstantOrAliasSpecExtended.class, GlTextureAsset.class);
        property_textureTargets.setValue(functionCall, value_textureTargets);
        return new GlTextureUnitAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<GlSamplerAsset>)property_sampler, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlTextureAsset>>)property_textureTargets);
    }

    private static @NonNull GlTransformFeedbackAsset createGlTransformFeedbackAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlTransformFeedbackAsset newAssetObject = GlTransformFeedbackAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlTransformFeedbackAsset.Value updateGlTransformFeedbackAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlTransformFeedbackAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlTransformFeedbackAsset assetObject = (GlTransformFeedbackAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@NonNull Boolean> property_active = new SimplePropertyValue<Boolean>(assetObjectValue.getActive());
        boolean value_active = builder.resolveBooleanProperty(assetAttachment, "active", false);
        property_active.setValue(functionCall, value_active);
        SimplePropertyValue<@NonNull Boolean> property_paused = new SimplePropertyValue<Boolean>(assetObjectValue.getPaused());
        boolean value_paused = builder.resolveBooleanProperty(assetAttachment, "paused", false);
        property_paused.setValue(functionCall, value_paused);
        return new GlTransformFeedbackAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Boolean>)property_active, (IAssetPropertyValue<Boolean>)property_paused);
    }

    private static @NonNull GlTransformFeedbackBufferBindingPointAsset createGlTransformFeedbackBufferBindingPointAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlTransformFeedbackBufferBindingPointAsset newAssetObject = GlTransformFeedbackBufferBindingPointAsset.createForMidstreamTrace(builder, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlTransformFeedbackBufferBindingPointAsset.Value updateGlTransformFeedbackBufferBindingPointAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlTransformFeedbackBufferBindingPointAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlTransformFeedbackBufferBindingPointAsset assetObject = (GlTransformFeedbackBufferBindingPointAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@Nullable GlBufferAsset> property_buffer = new SimplePropertyValue<GlBufferAsset>(assetObjectValue.getBuffer());
        GlBufferAsset value_buffer = builder.resolveAssetProperty(assetAttachment, "buffer", GlBufferAsset.class, true, null);
        property_buffer.setValue(functionCall, value_buffer);
        SimplePropertyValue<@NonNull Long> property_length = new SimplePropertyValue<Long>(assetObjectValue.getLength());
        long value_length = builder.resolveLongProperty(assetAttachment, "length", 0L);
        property_length.setValue(functionCall, value_length);
        SimplePropertyValue<@NonNull Long> property_offset = new SimplePropertyValue<Long>(assetObjectValue.getOffset());
        long value_offset = builder.resolveLongProperty(assetAttachment, "offset", 0L);
        property_offset.setValue(functionCall, value_offset);
        return new GlTransformFeedbackBufferBindingPointAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<GlBufferAsset>)property_buffer, (IAssetPropertyValue<Long>)property_length, (IAssetPropertyValue<Long>)property_offset);
    }

    private static @NonNull GlUniformBindingPointAsset createGlUniformBindingPointAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlUniformBindingPointAsset newAssetObject = GlUniformBindingPointAsset.createForMidstreamTrace(builder, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlUniformBindingPointAsset.Value updateGlUniformBindingPointAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlUniformBindingPointAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlUniformBindingPointAsset assetObject = (GlUniformBindingPointAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@Nullable GlBufferAsset> property_buffer = new SimplePropertyValue<GlBufferAsset>(assetObjectValue.getBuffer());
        GlBufferAsset value_buffer = builder.resolveAssetProperty(assetAttachment, "buffer", GlBufferAsset.class, true, null);
        property_buffer.setValue(functionCall, value_buffer);
        SimplePropertyValue<@NonNull Long> property_length = new SimplePropertyValue<Long>(assetObjectValue.getLength());
        long value_length = builder.resolveLongProperty(assetAttachment, "length", 0L);
        property_length.setValue(functionCall, value_length);
        SimplePropertyValue<@NonNull Long> property_offset = new SimplePropertyValue<Long>(assetObjectValue.getOffset());
        long value_offset = builder.resolveLongProperty(assetAttachment, "offset", 0L);
        property_offset.setValue(functionCall, value_offset);
        return new GlUniformBindingPointAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<GlBufferAsset>)property_buffer, (IAssetPropertyValue<Long>)property_length, (IAssetPropertyValue<Long>)property_offset);
    }

    private static @NonNull GlVertexArrayObjectAsset createGlVertexArrayObjectAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlVertexArrayObjectAsset newAssetObject = GlVertexArrayObjectAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlVertexArrayObjectAsset.Value updateGlVertexArrayObjectAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlVertexArrayObjectAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlVertexArrayObjectAsset assetObject = (GlVertexArrayObjectAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<@Nullable GlBufferAsset> property_elementArrayBufferBinding = new SimplePropertyValue<GlBufferAsset>(assetObjectValue.getElementArrayBufferBinding());
        GlBufferAsset value_elementArrayBufferBinding = builder.resolveAssetProperty(assetAttachment, "elementArrayBufferBinding", GlBufferAsset.class, true, null);
        property_elementArrayBufferBinding.setValue(functionCall, value_elementArrayBufferBinding);
        return new GlVertexArrayObjectAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<GlBufferAsset>)property_elementArrayBufferBinding);
    }

    private static @NonNull GlVertexAttributeNonArrayValueAsset createGlVertexAttributeNonArrayValueAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        GlVertexAttributeNonArrayValueAsset newAssetObject = GlVertexAttributeNonArrayValueAsset.createForMidstreamTrace(builder, functionCall, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlVertexAttributeNonArrayValueAsset.Value updateGlVertexAttributeNonArrayValueAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlVertexAttributeNonArrayValueAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlVertexAttributeNonArrayValueAsset assetObject = (GlVertexAttributeNonArrayValueAsset)assetObjectValue.getAssetObject();
        SimplePropertyValue<Number[]> property_value = new SimplePropertyValue<Number[]>(assetObjectValue.getValue());
        Number[] value_value = builder.resolveArrayProperty(assetAttachment, "value", Number.class, false);
        property_value.setValue(functionCall, value_value);
        return new GlVertexAttributeNonArrayValueAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Number[]>)property_value);
    }

    private static @NonNull GlTextureImageAsset createGlTextureImageAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlTextureSurfaceAsset parentAsset) {
        GlTextureImageAsset newAssetObject = GlTextureImageAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlTextureImageAsset.Value updateGlTextureImageAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlTextureImageAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlTextureImageAsset assetObject = (GlTextureImageAsset)assetObjectValue.getAssetObject();
        GlTextureSurfaceAsset parentAsset = (GlTextureSurfaceAsset)assetObject.getParentAsset();
        SimplePropertyValue<@NonNull Long> property_alphaSize = new SimplePropertyValue<Long>(assetObjectValue.getAlphaSize());
        long value_alphaSize = builder.resolveLongProperty(assetAttachment, "alphaSize", 0L);
        property_alphaSize.setValue(functionCall, value_alphaSize);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_alphaType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getAlphaType());
        AbstractConstantOrAliasSpecExtended value_alphaType = builder.resolveProperty(assetAttachment, "alphaType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        property_alphaType.setValue(functionCall, value_alphaType);
        SimplePropertyValue<@NonNull Long> property_blueSize = new SimplePropertyValue<Long>(assetObjectValue.getBlueSize());
        long value_blueSize = builder.resolveLongProperty(assetAttachment, "blueSize", 0L);
        property_blueSize.setValue(functionCall, value_blueSize);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_blueType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getBlueType());
        AbstractConstantOrAliasSpecExtended value_blueType = builder.resolveProperty(assetAttachment, "blueType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        property_blueType.setValue(functionCall, value_blueType);
        SimplePropertyValue<@Nullable GlBufferAsset> property_bufferDataStoreBinding = new SimplePropertyValue<GlBufferAsset>(assetObjectValue.getBufferDataStoreBinding());
        GlBufferAsset value_bufferDataStoreBinding = builder.resolveAssetProperty(assetAttachment, "bufferDataStoreBinding", GlBufferAsset.class, true, null);
        property_bufferDataStoreBinding.setValue(functionCall, value_bufferDataStoreBinding);
        SimplePropertyValue<@NonNull Long> property_bufferOffset = new SimplePropertyValue<Long>(assetObjectValue.getBufferOffset());
        long value_bufferOffset = builder.resolveLongProperty(assetAttachment, "bufferOffset", 0L);
        property_bufferOffset.setValue(functionCall, value_bufferOffset);
        SimplePropertyValue<@NonNull Long> property_bufferSize = new SimplePropertyValue<Long>(assetObjectValue.getBufferSize());
        long value_bufferSize = builder.resolveLongProperty(assetAttachment, "bufferSize", 0L);
        property_bufferSize.setValue(functionCall, value_bufferSize);
        SimplePropertyValue<@NonNull Boolean> property_compressed = new SimplePropertyValue<Boolean>(assetObjectValue.getCompressed());
        boolean value_compressed = builder.resolveBooleanProperty(assetAttachment, "compressed", false);
        property_compressed.setValue(functionCall, value_compressed);
        SimplePropertyValue<@NonNull Long> property_depth = new SimplePropertyValue<Long>(assetObjectValue.getDepth());
        long value_depth = builder.resolveLongProperty(assetAttachment, "depth", 0L);
        property_depth.setValue(functionCall, value_depth);
        SimplePropertyValue<@NonNull Long> property_depthSize = new SimplePropertyValue<Long>(assetObjectValue.getDepthSize());
        long value_depthSize = builder.resolveLongProperty(assetAttachment, "depthSize", 0L);
        property_depthSize.setValue(functionCall, value_depthSize);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getDepthType());
        AbstractConstantOrAliasSpecExtended value_depthType = builder.resolveProperty(assetAttachment, "depthType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        property_depthType.setValue(functionCall, value_depthType);
        SimplePropertyValue<@NonNull Boolean> property_fixedSampleLocations = new SimplePropertyValue<Boolean>(assetObjectValue.getFixedSampleLocations());
        boolean value_fixedSampleLocations = builder.resolveBooleanProperty(assetAttachment, "fixedSampleLocations", true);
        property_fixedSampleLocations.setValue(functionCall, value_fixedSampleLocations);
        SimplePropertyValue<@NonNull Long> property_greenSize = new SimplePropertyValue<Long>(assetObjectValue.getGreenSize());
        long value_greenSize = builder.resolveLongProperty(assetAttachment, "greenSize", 0L);
        property_greenSize.setValue(functionCall, value_greenSize);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_greenType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getGreenType());
        AbstractConstantOrAliasSpecExtended value_greenType = builder.resolveProperty(assetAttachment, "greenType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        property_greenType.setValue(functionCall, value_greenType);
        SimplePropertyValue<@NonNull Long> property_height = new SimplePropertyValue<Long>(assetObjectValue.getHeight());
        long value_height = builder.resolveLongProperty(assetAttachment, "height", 0L);
        property_height.setValue(functionCall, value_height);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getInternalFormat());
        AbstractConstantOrAliasSpecExtended value_internalFormat = builder.resolveProperty(assetAttachment, "internalFormat", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_RGBA);
        property_internalFormat.setValue(functionCall, value_internalFormat);
        SimplePropertyValue<@NonNull Long> property_redSize = new SimplePropertyValue<Long>(assetObjectValue.getRedSize());
        long value_redSize = builder.resolveLongProperty(assetAttachment, "redSize", 0L);
        property_redSize.setValue(functionCall, value_redSize);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_redType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getRedType());
        AbstractConstantOrAliasSpecExtended value_redType = builder.resolveProperty(assetAttachment, "redType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        property_redType.setValue(functionCall, value_redType);
        SimplePropertyValue<@NonNull Long> property_samples = new SimplePropertyValue<Long>(assetObjectValue.getSamples());
        long value_samples = builder.resolveLongProperty(assetAttachment, "samples", 0L);
        property_samples.setValue(functionCall, value_samples);
        SimplePropertyValue<@NonNull Long> property_sharedSize = new SimplePropertyValue<Long>(assetObjectValue.getSharedSize());
        long value_sharedSize = builder.resolveLongProperty(assetAttachment, "sharedSize", 0L);
        property_sharedSize.setValue(functionCall, value_sharedSize);
        SimplePropertyValue<@NonNull Long> property_stencilSize = new SimplePropertyValue<Long>(assetObjectValue.getStencilSize());
        long value_stencilSize = builder.resolveLongProperty(assetAttachment, "stencilSize", 0L);
        property_stencilSize.setValue(functionCall, value_stencilSize);
        SimplePropertyValue<@NonNull Long> property_width = new SimplePropertyValue<Long>(assetObjectValue.getWidth());
        long value_width = builder.resolveLongProperty(assetAttachment, "width", 0L);
        property_width.setValue(functionCall, value_width);
        return new GlTextureImageAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Long>)property_alphaSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_alphaType, (IAssetPropertyValue<Long>)property_blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_blueType, (IAssetPropertyValue<GlBufferAsset>)property_bufferDataStoreBinding, (IAssetPropertyValue<Long>)property_bufferOffset, (IAssetPropertyValue<Long>)property_bufferSize, (IAssetPropertyValue<Boolean>)property_compressed, (IAssetPropertyValue<Long>)property_depth, (IAssetPropertyValue<Long>)property_depthSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_depthType, (IAssetPropertyValue<Boolean>)property_fixedSampleLocations, (IAssetPropertyValue<Long>)property_greenSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_greenType, (IAssetPropertyValue<Long>)property_height, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_internalFormat, (IAssetPropertyValue<Long>)property_redSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_redType, (IAssetPropertyValue<Long>)property_samples, (IAssetPropertyValue<Long>)property_sharedSize, (IAssetPropertyValue<Long>)property_stencilSize, (IAssetPropertyValue<Long>)property_width);
    }

    private static @NonNull GlTextureSurfaceAsset createGlTextureSurfaceAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset parentAsset) {
        GlTextureSurfaceAsset newAssetObject = GlTextureSurfaceAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlTextureSurfaceAsset.Value updateGlTextureSurfaceAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlTextureSurfaceAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlTextureSurfaceAsset assetObject = (GlTextureSurfaceAsset)assetObjectValue.getAssetObject();
        GlTextureAsset parentAsset = (GlTextureAsset)assetObject.getParentAsset();
        return new GlTextureSurfaceAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject);
    }

    private static @NonNull GlVertexAttributeAsset createGlVertexAttributeAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlVertexArrayObjectAsset parentAsset) {
        GlVertexAttributeAsset newAssetObject = GlVertexAttributeAsset.createForMidstreamTrace(builder, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlVertexAttributeAsset.Value updateGlVertexAttributeAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlVertexAttributeAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlVertexAttributeAsset assetObject = (GlVertexAttributeAsset)assetObjectValue.getAssetObject();
        GlVertexArrayObjectAsset parentAsset = (GlVertexArrayObjectAsset)assetObject.getParentAsset();
        SimplePropertyValue<@NonNull Boolean> property_arrayEnabled = new SimplePropertyValue<Boolean>(assetObjectValue.getArrayEnabled());
        boolean value_arrayEnabled = builder.resolveBooleanProperty(assetAttachment, "arrayEnabled", false);
        property_arrayEnabled.setValue(functionCall, value_arrayEnabled);
        SimplePropertyValue<@NonNull Boolean> property_arrayInteger = new SimplePropertyValue<Boolean>(assetObjectValue.getArrayInteger());
        boolean value_arrayInteger = builder.resolveBooleanProperty(assetAttachment, "arrayInteger", false);
        property_arrayInteger.setValue(functionCall, value_arrayInteger);
        SimplePropertyValue<@NonNull Boolean> property_arrayNormalized = new SimplePropertyValue<Boolean>(assetObjectValue.getArrayNormalized());
        boolean value_arrayNormalized = builder.resolveBooleanProperty(assetAttachment, "arrayNormalized", false);
        property_arrayNormalized.setValue(functionCall, value_arrayNormalized);
        SimplePropertyValue<@Nullable Pointer> property_arrayPointer = new SimplePropertyValue<Pointer>(assetObjectValue.getArrayPointer());
        Pointer value_arrayPointer = builder.resolveProperty(assetAttachment, "arrayPointer", Pointer.class, false, Pointer.valueOf(0L));
        property_arrayPointer.setValue(functionCall, value_arrayPointer);
        SimplePropertyValue<@NonNull Long> property_arraySize = new SimplePropertyValue<Long>(assetObjectValue.getArraySize());
        long value_arraySize = builder.resolveLongProperty(assetAttachment, "arraySize", 4L);
        property_arraySize.setValue(functionCall, value_arraySize);
        SimplePropertyValue<@NonNull Long> property_arrayStride = new SimplePropertyValue<Long>(assetObjectValue.getArrayStride());
        long value_arrayStride = builder.resolveLongProperty(assetAttachment, "arrayStride", 0L);
        property_arrayStride.setValue(functionCall, value_arrayStride);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_arrayType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getArrayType());
        AbstractConstantOrAliasSpecExtended value_arrayType = builder.resolveProperty(assetAttachment, "arrayType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_FLOAT);
        property_arrayType.setValue(functionCall, value_arrayType);
        ImmutablePropertyValue<@NonNull GlVertexAttributeNonArrayValueAsset> property_nonArrayDataSource = assetObject.getImmutablePropertyNonArrayDataSource();
        SimplePropertyValue<@Nullable GlVertexBufferBindingAsset> property_vboBinding = new SimplePropertyValue<GlVertexBufferBindingAsset>(assetObjectValue.getVboBinding());
        GlVertexBufferBindingAsset value_vboBinding = builder.resolveAssetProperty(assetAttachment, "vboBinding", GlVertexBufferBindingAsset.class, parentAsset, true, null);
        property_vboBinding.setValue(functionCall, value_vboBinding);
        SimplePropertyValue<@NonNull Long> property_vboRelativeOffset = new SimplePropertyValue<Long>(assetObjectValue.getVboRelativeOffset());
        long value_vboRelativeOffset = builder.resolveLongProperty(assetAttachment, "vboRelativeOffset", 0L);
        property_vboRelativeOffset.setValue(functionCall, value_vboRelativeOffset);
        return new GlVertexAttributeAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, property_arrayEnabled, property_arrayInteger, (IAssetPropertyValue<Boolean>)property_arrayNormalized, property_arrayPointer, property_arraySize, property_arrayStride, property_arrayType, property_nonArrayDataSource, (IAssetPropertyValue<GlVertexBufferBindingAsset>)property_vboBinding, (IAssetPropertyValue<Long>)property_vboRelativeOffset);
    }

    private static @NonNull GlVertexBufferBindingAsset createGlVertexBufferBindingAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlVertexArrayObjectAsset parentAsset) {
        GlVertexBufferBindingAsset newAssetObject = GlVertexBufferBindingAsset.createForMidstreamTrace(builder, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlVertexBufferBindingAsset.Value updateGlVertexBufferBindingAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlVertexBufferBindingAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlVertexBufferBindingAsset assetObject = (GlVertexBufferBindingAsset)assetObjectValue.getAssetObject();
        GlVertexArrayObjectAsset parentAsset = (GlVertexArrayObjectAsset)assetObject.getParentAsset();
        SimplePropertyValue<@Nullable GlBufferAsset> property_buffer = new SimplePropertyValue<GlBufferAsset>(assetObjectValue.getBuffer());
        GlBufferAsset value_buffer = builder.resolveAssetProperty(assetAttachment, "buffer", GlBufferAsset.class, true, null);
        property_buffer.setValue(functionCall, value_buffer);
        SimplePropertyValue<@NonNull Long> property_divisor = new SimplePropertyValue<Long>(assetObjectValue.getDivisor());
        long value_divisor = builder.resolveLongProperty(assetAttachment, "divisor", 0L);
        property_divisor.setValue(functionCall, value_divisor);
        SimplePropertyValue<@NonNull Long> property_offset = new SimplePropertyValue<Long>(assetObjectValue.getOffset());
        long value_offset = builder.resolveLongProperty(assetAttachment, "offset", 0L);
        property_offset.setValue(functionCall, value_offset);
        SimplePropertyValue<@NonNull Long> property_stride = new SimplePropertyValue<Long>(assetObjectValue.getStride());
        long value_stride = builder.resolveLongProperty(assetAttachment, "stride", 0L);
        property_stride.setValue(functionCall, value_stride);
        return new GlVertexBufferBindingAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<GlBufferAsset>)property_buffer, (IAssetPropertyValue<Long>)property_divisor, (IAssetPropertyValue<Long>)property_offset, (IAssetPropertyValue<Long>)property_stride);
    }

    private static @NonNull ShaderUniform createShaderUniform(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset parentAsset) {
        ShaderUniform newAssetObject = ShaderUniform.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull ShaderUniform.Value updateShaderUniform(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull ShaderUniform.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        ShaderUniform assetObject = (ShaderUniform)assetObjectValue.getAssetObject();
        GlProgramAsset parentAsset = (GlProgramAsset)assetObject.getParentAsset();
        ImmutablePropertyValue<@NonNull Integer> property_arrayLength = assetObject.getImmutablePropertyArrayLength();
        ImmutablePropertyValue<@NonNull String> property_blockName = assetObject.getImmutablePropertyBlockName();
        ImmutablePropertyValue<@NonNull Integer> property_elementLength = assetObject.getImmutablePropertyElementLength();
        ImmutablePropertyValue<@NonNull Integer> property_location = assetObject.getImmutablePropertyLocation();
        ImmutablePropertyValue<@NonNull String> property_name = assetObject.getImmutablePropertyName();
        ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type = assetObject.getImmutablePropertyType();
        ShaderUniformValuePropertyValue property_value = new ShaderUniformValuePropertyValue(assetObjectValue.getValue());
        Number[] value_value = builder.resolveArrayProperty(assetAttachment, "value", Number.class, false);
        property_value.setValue(functionCall, value_value);
        return new ShaderUniform.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Integer>)property_arrayLength, (IAssetPropertyValue<String>)property_blockName, (IAssetPropertyValue<Integer>)property_elementLength, (IAssetPropertyValue<Integer>)property_location, (IAssetPropertyValue<String>)property_name, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_type, property_value);
    }

    private static @NonNull GlFramebufferRenderbufferAttachmentAsset createGlFramebufferRenderbufferAttachmentAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset) {
        GlRenderbufferAsset renderbuffer = builder.resolveAssetProperty(assetAttachment, "renderbuffer", GlRenderbufferAsset.class, false, null);
        GlFramebufferRenderbufferAttachmentAsset newAssetObject = GlFramebufferRenderbufferAttachmentAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()), renderbuffer);
        return newAssetObject;
    }

    private static @NonNull GlFramebufferRenderbufferAttachmentAsset.Value updateGlFramebufferRenderbufferAttachmentAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferRenderbufferAttachmentAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlFramebufferRenderbufferAttachmentAsset assetObject = (GlFramebufferRenderbufferAttachmentAsset)assetObjectValue.getAssetObject();
        GlFramebufferAsset parentAsset = (GlFramebufferAsset)assetObject.getParentAsset();
        SimplePropertyValue<@NonNull Long> property_alphaSize = new SimplePropertyValue<Long>(assetObjectValue.getAlphaSize());
        long value_alphaSize = builder.resolveLongProperty(assetAttachment, "alphaSize", 0L);
        property_alphaSize.setValue(functionCall, value_alphaSize);
        SimplePropertyValue<@NonNull Long> property_blueSize = new SimplePropertyValue<Long>(assetObjectValue.getBlueSize());
        long value_blueSize = builder.resolveLongProperty(assetAttachment, "blueSize", 0L);
        property_blueSize.setValue(functionCall, value_blueSize);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_colorEncoding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getColorEncoding());
        AbstractConstantOrAliasSpecExtended value_colorEncoding = builder.resolveProperty(assetAttachment, "colorEncoding", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LINEAR);
        property_colorEncoding.setValue(functionCall, value_colorEncoding);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_componentType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getComponentType());
        AbstractConstantOrAliasSpecExtended value_componentType = builder.resolveProperty(assetAttachment, "componentType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_FLOAT);
        property_componentType.setValue(functionCall, value_componentType);
        SimplePropertyValue<@NonNull Long> property_depthSize = new SimplePropertyValue<Long>(assetObjectValue.getDepthSize());
        long value_depthSize = builder.resolveLongProperty(assetAttachment, "depthSize", 0L);
        property_depthSize.setValue(functionCall, value_depthSize);
        SimplePropertyValue<@NonNull Long> property_greenSize = new SimplePropertyValue<Long>(assetObjectValue.getGreenSize());
        long value_greenSize = builder.resolveLongProperty(assetAttachment, "greenSize", 0L);
        property_greenSize.setValue(functionCall, value_greenSize);
        SimplePropertyValue<@NonNull Long> property_redSize = new SimplePropertyValue<Long>(assetObjectValue.getRedSize());
        long value_redSize = builder.resolveLongProperty(assetAttachment, "redSize", 0L);
        property_redSize.setValue(functionCall, value_redSize);
        SimplePropertyValue<@NonNull Long> property_stencilSize = new SimplePropertyValue<Long>(assetObjectValue.getStencilSize());
        long value_stencilSize = builder.resolveLongProperty(assetAttachment, "stencilSize", 0L);
        property_stencilSize.setValue(functionCall, value_stencilSize);
        ImmutablePropertyValue<@NonNull GlRenderbufferAsset> property_renderbuffer = assetObject.getImmutablePropertyRenderbuffer();
        return new GlFramebufferRenderbufferAttachmentAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Long>)property_alphaSize, (IAssetPropertyValue<Long>)property_blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_componentType, (IAssetPropertyValue<Long>)property_depthSize, (IAssetPropertyValue<Long>)property_greenSize, (IAssetPropertyValue<Long>)property_redSize, (IAssetPropertyValue<Long>)property_stencilSize, (IAssetPropertyValue<GlRenderbufferAsset>)property_renderbuffer);
    }

    private static @NonNull GlFramebufferTextureAttachmentAsset createGlFramebufferTextureAttachmentAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset) {
        GlTextureAsset texture = builder.resolveAssetProperty(assetAttachment, "texture", GlTextureAsset.class, false, null);
        AbstractConstantOrAliasSpecExtended textureCubeMapFace = builder.resolveProperty(assetAttachment, "textureCubeMapFace", AbstractConstantOrAliasSpecExtended.class, true, KapiSpec.GLES.constants.GL_NONE);
        Integer textureLayer = builder.resolveProperty(assetAttachment, "textureLayer", Integer.class, true, 0);
        long textureLevel = builder.resolveLongProperty(assetAttachment, "textureLevel", 0L);
        GlFramebufferTextureAttachmentAsset newAssetObject = GlFramebufferTextureAttachmentAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()), texture, textureCubeMapFace, textureLayer, textureLevel);
        return newAssetObject;
    }

    private static @NonNull GlFramebufferTextureAttachmentAsset.Value updateGlFramebufferTextureAttachmentAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferTextureAttachmentAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlFramebufferTextureAttachmentAsset assetObject = (GlFramebufferTextureAttachmentAsset)assetObjectValue.getAssetObject();
        GlFramebufferAsset parentAsset = (GlFramebufferAsset)assetObject.getParentAsset();
        SimplePropertyValue<@NonNull Long> property_alphaSize = new SimplePropertyValue<Long>(assetObjectValue.getAlphaSize());
        long value_alphaSize = builder.resolveLongProperty(assetAttachment, "alphaSize", 0L);
        property_alphaSize.setValue(functionCall, value_alphaSize);
        SimplePropertyValue<@NonNull Long> property_blueSize = new SimplePropertyValue<Long>(assetObjectValue.getBlueSize());
        long value_blueSize = builder.resolveLongProperty(assetAttachment, "blueSize", 0L);
        property_blueSize.setValue(functionCall, value_blueSize);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_colorEncoding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getColorEncoding());
        AbstractConstantOrAliasSpecExtended value_colorEncoding = builder.resolveProperty(assetAttachment, "colorEncoding", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LINEAR);
        property_colorEncoding.setValue(functionCall, value_colorEncoding);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_componentType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getComponentType());
        AbstractConstantOrAliasSpecExtended value_componentType = builder.resolveProperty(assetAttachment, "componentType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_FLOAT);
        property_componentType.setValue(functionCall, value_componentType);
        SimplePropertyValue<@NonNull Long> property_depthSize = new SimplePropertyValue<Long>(assetObjectValue.getDepthSize());
        long value_depthSize = builder.resolveLongProperty(assetAttachment, "depthSize", 0L);
        property_depthSize.setValue(functionCall, value_depthSize);
        SimplePropertyValue<@NonNull Long> property_greenSize = new SimplePropertyValue<Long>(assetObjectValue.getGreenSize());
        long value_greenSize = builder.resolveLongProperty(assetAttachment, "greenSize", 0L);
        property_greenSize.setValue(functionCall, value_greenSize);
        SimplePropertyValue<@NonNull Long> property_redSize = new SimplePropertyValue<Long>(assetObjectValue.getRedSize());
        long value_redSize = builder.resolveLongProperty(assetAttachment, "redSize", 0L);
        property_redSize.setValue(functionCall, value_redSize);
        SimplePropertyValue<@NonNull Long> property_stencilSize = new SimplePropertyValue<Long>(assetObjectValue.getStencilSize());
        long value_stencilSize = builder.resolveLongProperty(assetAttachment, "stencilSize", 0L);
        property_stencilSize.setValue(functionCall, value_stencilSize);
        ImmutablePropertyValue<@NonNull GlTextureAsset> property_texture = assetObject.getImmutablePropertyTexture();
        ImmutablePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureCubeMapFace = assetObject.getImmutablePropertyTextureCubeMapFace();
        ImmutablePropertyValue<@Nullable Integer> property_textureLayer = assetObject.getImmutablePropertyTextureLayer();
        ImmutablePropertyValue<@NonNull Long> property_textureLevel = assetObject.getImmutablePropertyTextureLevel();
        return new GlFramebufferTextureAttachmentAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Long>)property_alphaSize, (IAssetPropertyValue<Long>)property_blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_componentType, (IAssetPropertyValue<Long>)property_depthSize, (IAssetPropertyValue<Long>)property_greenSize, (IAssetPropertyValue<Long>)property_redSize, (IAssetPropertyValue<Long>)property_stencilSize, (IAssetPropertyValue<GlTextureAsset>)property_texture, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_textureCubeMapFace, (IAssetPropertyValue<Integer>)property_textureLayer, (IAssetPropertyValue<Long>)property_textureLevel);
    }

    private static @NonNull GlFramebufferTextureMultiviewAttachmentAsset createGlFramebufferTextureMultiviewAttachmentAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset) {
        GlTextureAsset arrayTexture = builder.resolveAssetProperty(assetAttachment, "arrayTexture", GlTextureAsset.class, false, null);
        long arrayTextureLevel = builder.resolveLongProperty(assetAttachment, "arrayTextureLevel", 0L);
        long baseViewIndex = builder.resolveLongProperty(assetAttachment, "baseViewIndex", 0L);
        int numViews = builder.resolveIntProperty(assetAttachment, "numViews", 0);
        int samples = builder.resolveIntProperty(assetAttachment, "samples", 0);
        GlFramebufferTextureMultiviewAttachmentAsset newAssetObject = GlFramebufferTextureMultiviewAttachmentAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()), arrayTexture, arrayTextureLevel, baseViewIndex, numViews, samples);
        return newAssetObject;
    }

    private static @NonNull GlFramebufferTextureMultiviewAttachmentAsset.Value updateGlFramebufferTextureMultiviewAttachmentAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferTextureMultiviewAttachmentAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlFramebufferTextureMultiviewAttachmentAsset assetObject = (GlFramebufferTextureMultiviewAttachmentAsset)assetObjectValue.getAssetObject();
        GlFramebufferAsset parentAsset = (GlFramebufferAsset)assetObject.getParentAsset();
        SimplePropertyValue<@NonNull Long> property_alphaSize = new SimplePropertyValue<Long>(assetObjectValue.getAlphaSize());
        long value_alphaSize = builder.resolveLongProperty(assetAttachment, "alphaSize", 0L);
        property_alphaSize.setValue(functionCall, value_alphaSize);
        SimplePropertyValue<@NonNull Long> property_blueSize = new SimplePropertyValue<Long>(assetObjectValue.getBlueSize());
        long value_blueSize = builder.resolveLongProperty(assetAttachment, "blueSize", 0L);
        property_blueSize.setValue(functionCall, value_blueSize);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_colorEncoding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getColorEncoding());
        AbstractConstantOrAliasSpecExtended value_colorEncoding = builder.resolveProperty(assetAttachment, "colorEncoding", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LINEAR);
        property_colorEncoding.setValue(functionCall, value_colorEncoding);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_componentType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getComponentType());
        AbstractConstantOrAliasSpecExtended value_componentType = builder.resolveProperty(assetAttachment, "componentType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_FLOAT);
        property_componentType.setValue(functionCall, value_componentType);
        SimplePropertyValue<@NonNull Long> property_depthSize = new SimplePropertyValue<Long>(assetObjectValue.getDepthSize());
        long value_depthSize = builder.resolveLongProperty(assetAttachment, "depthSize", 0L);
        property_depthSize.setValue(functionCall, value_depthSize);
        SimplePropertyValue<@NonNull Long> property_greenSize = new SimplePropertyValue<Long>(assetObjectValue.getGreenSize());
        long value_greenSize = builder.resolveLongProperty(assetAttachment, "greenSize", 0L);
        property_greenSize.setValue(functionCall, value_greenSize);
        SimplePropertyValue<@NonNull Long> property_redSize = new SimplePropertyValue<Long>(assetObjectValue.getRedSize());
        long value_redSize = builder.resolveLongProperty(assetAttachment, "redSize", 0L);
        property_redSize.setValue(functionCall, value_redSize);
        SimplePropertyValue<@NonNull Long> property_stencilSize = new SimplePropertyValue<Long>(assetObjectValue.getStencilSize());
        long value_stencilSize = builder.resolveLongProperty(assetAttachment, "stencilSize", 0L);
        property_stencilSize.setValue(functionCall, value_stencilSize);
        ImmutablePropertyValue<@NonNull GlTextureAsset> property_arrayTexture = assetObject.getImmutablePropertyArrayTexture();
        ImmutablePropertyValue<@NonNull Long> property_arrayTextureLevel = assetObject.getImmutablePropertyArrayTextureLevel();
        ImmutablePropertyValue<@NonNull Long> property_baseViewIndex = assetObject.getImmutablePropertyBaseViewIndex();
        ImmutablePropertyValue<@NonNull Integer> property_numViews = assetObject.getImmutablePropertyNumViews();
        ImmutablePropertyValue<@NonNull Integer> property_samples = assetObject.getImmutablePropertySamples();
        return new GlFramebufferTextureMultiviewAttachmentAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Long>)property_alphaSize, (IAssetPropertyValue<Long>)property_blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_componentType, (IAssetPropertyValue<Long>)property_depthSize, (IAssetPropertyValue<Long>)property_greenSize, (IAssetPropertyValue<Long>)property_redSize, (IAssetPropertyValue<Long>)property_stencilSize, (IAssetPropertyValue<GlTextureAsset>)property_arrayTexture, (IAssetPropertyValue<Long>)property_arrayTextureLevel, (IAssetPropertyValue<Long>)property_baseViewIndex, (IAssetPropertyValue<Integer>)property_numViews, (IAssetPropertyValue<Integer>)property_samples);
    }

    private static @NonNull GlFramebufferZeroAttachmentAsset createGlFramebufferZeroAttachmentAsset(@NonNull LightweightAssetBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset) {
        GlFramebufferZeroAttachmentAsset newAssetObject = GlFramebufferZeroAttachmentAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull GlFramebufferZeroAttachmentAsset.Value updateGlFramebufferZeroAttachmentAsset(@NonNull LightweightAssetValueBuilder<GLESApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferZeroAttachmentAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<GLESApi> callbacks = builder.getAssetProcessorCallbacks();
        GlFramebufferZeroAttachmentAsset assetObject = (GlFramebufferZeroAttachmentAsset)assetObjectValue.getAssetObject();
        GlFramebufferAsset parentAsset = (GlFramebufferAsset)assetObject.getParentAsset();
        SimplePropertyValue<@NonNull Long> property_alphaSize = new SimplePropertyValue<Long>(assetObjectValue.getAlphaSize());
        long value_alphaSize = builder.resolveLongProperty(assetAttachment, "alphaSize", 0L);
        property_alphaSize.setValue(functionCall, value_alphaSize);
        SimplePropertyValue<@NonNull Long> property_blueSize = new SimplePropertyValue<Long>(assetObjectValue.getBlueSize());
        long value_blueSize = builder.resolveLongProperty(assetAttachment, "blueSize", 0L);
        property_blueSize.setValue(functionCall, value_blueSize);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_colorEncoding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getColorEncoding());
        AbstractConstantOrAliasSpecExtended value_colorEncoding = builder.resolveProperty(assetAttachment, "colorEncoding", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LINEAR);
        property_colorEncoding.setValue(functionCall, value_colorEncoding);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_componentType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getComponentType());
        AbstractConstantOrAliasSpecExtended value_componentType = builder.resolveProperty(assetAttachment, "componentType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_FLOAT);
        property_componentType.setValue(functionCall, value_componentType);
        SimplePropertyValue<@NonNull Long> property_depthSize = new SimplePropertyValue<Long>(assetObjectValue.getDepthSize());
        long value_depthSize = builder.resolveLongProperty(assetAttachment, "depthSize", 0L);
        property_depthSize.setValue(functionCall, value_depthSize);
        SimplePropertyValue<@NonNull Long> property_greenSize = new SimplePropertyValue<Long>(assetObjectValue.getGreenSize());
        long value_greenSize = builder.resolveLongProperty(assetAttachment, "greenSize", 0L);
        property_greenSize.setValue(functionCall, value_greenSize);
        SimplePropertyValue<@NonNull Long> property_redSize = new SimplePropertyValue<Long>(assetObjectValue.getRedSize());
        long value_redSize = builder.resolveLongProperty(assetAttachment, "redSize", 0L);
        property_redSize.setValue(functionCall, value_redSize);
        SimplePropertyValue<@NonNull Long> property_stencilSize = new SimplePropertyValue<Long>(assetObjectValue.getStencilSize());
        long value_stencilSize = builder.resolveLongProperty(assetAttachment, "stencilSize", 0L);
        property_stencilSize.setValue(functionCall, value_stencilSize);
        return new GlFramebufferZeroAttachmentAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Long>)property_alphaSize, (IAssetPropertyValue<Long>)property_blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_componentType, (IAssetPropertyValue<Long>)property_depthSize, (IAssetPropertyValue<Long>)property_greenSize, (IAssetPropertyValue<Long>)property_redSize, (IAssetPropertyValue<Long>)property_stencilSize);
    }

    private static @NonNull EglDisplayAsset createEglDisplayAsset(@NonNull LightweightAssetBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        Pointer nativeDisplayID = builder.resolveProperty(assetAttachment, "nativeDisplayID", Pointer.class, false, Pointer.NULL);
        EglDisplayAsset newAssetObject = EglDisplayAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, AssetItemID.valueOf(assetAttachment.getId()), nativeDisplayID);
        return newAssetObject;
    }

    private static @NonNull EglDisplayAsset.Value updateEglDisplayAsset(@NonNull LightweightAssetValueBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<EGLApi> callbacks = builder.getAssetProcessorCallbacks();
        EglDisplayAsset assetObject = (EglDisplayAsset)assetObjectValue.getAssetObject();
        ImmutablePropertyValue<@Nullable Pointer> property_nativeDisplayID = assetObject.getImmutablePropertyNativeDisplayId();
        return new EglDisplayAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Pointer>)property_nativeDisplayID);
    }

    private static @NonNull EglConfigAsset createEglConfigAsset(@NonNull LightweightAssetBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        EglConfigAsset newAssetObject = EglConfigAsset.createForMidstreamTrace(builder, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()));
        return newAssetObject;
    }

    private static @NonNull EglConfigAsset.Value updateEglConfigAsset(@NonNull LightweightAssetValueBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglConfigAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<EGLApi> callbacks = builder.getAssetProcessorCallbacks();
        EglConfigAsset assetObject = (EglConfigAsset)assetObjectValue.getAssetObject();
        EglDisplayAsset parentAsset = (EglDisplayAsset)assetObject.getParentAsset();
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(assetObjectValue.getAttributes());
        Map<AbstractConstantOrAliasSpecExtended, Long> value_attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        property_attributes.setValue(functionCall, value_attributes);
        return new EglConfigAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)property_attributes);
    }

    private static @NonNull EglContextAsset createEglContextAsset(@NonNull LightweightAssetBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        EglConfigAsset config = builder.resolveAssetProperty(assetAttachment, "config", EglConfigAsset.class, parentAsset, false, null);
        EglContextAsset sharedContext = builder.resolveAssetProperty(assetAttachment, "sharedContext", EglContextAsset.class, parentAsset, true, null);
        EglContextAsset newAssetObject = EglContextAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()), config, sharedContext);
        return newAssetObject;
    }

    private static @NonNull EglContextAsset.Value updateEglContextAsset(@NonNull LightweightAssetValueBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglContextAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<EGLApi> callbacks = builder.getAssetProcessorCallbacks();
        EglContextAsset assetObject = (EglContextAsset)assetObjectValue.getAssetObject();
        EglDisplayAsset parentAsset = (EglDisplayAsset)assetObject.getParentAsset();
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(assetObjectValue.getAttributes());
        Map<AbstractConstantOrAliasSpecExtended, Long> value_attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        property_attributes.setValue(functionCall, value_attributes);
        ImmutablePropertyValue<@NonNull EglConfigAsset> property_config = assetObject.getImmutablePropertyConfig();
        ImmutablePropertyValue<@Nullable EglContextAsset> property_sharedContext = assetObject.getImmutablePropertySharedContext();
        return new EglContextAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)property_attributes, (IAssetPropertyValue<EglConfigAsset>)property_config, (IAssetPropertyValue<EglContextAsset>)property_sharedContext);
    }

    private static @NonNull EglImageAsset createEglImageAsset(@NonNull LightweightAssetBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        Pointer clientObjectID = builder.resolveProperty(assetAttachment, "clientObjectID", Pointer.class, false, null);
        EglContextAsset sourceContext = builder.resolveAssetProperty(assetAttachment, "sourceContext", EglContextAsset.class, parentAsset, true, null);
        AbstractConstantOrAliasSpecExtended target = builder.resolveConstantProperty(assetAttachment, "target", CONSTANT_SET_EGL_IMAGE_ASSET_TARGET, false, null);
        EglImageAsset newAssetObject = EglImageAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()), clientObjectID, sourceContext, target);
        return newAssetObject;
    }

    private static @NonNull EglImageAsset.Value updateEglImageAsset(@NonNull LightweightAssetValueBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglImageAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<EGLApi> callbacks = builder.getAssetProcessorCallbacks();
        EglImageAsset assetObject = (EglImageAsset)assetObjectValue.getAssetObject();
        EglDisplayAsset parentAsset = (EglDisplayAsset)assetObject.getParentAsset();
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(assetObjectValue.getAttributes());
        Map<AbstractConstantOrAliasSpecExtended, Long> value_attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        property_attributes.setValue(functionCall, value_attributes);
        ImmutablePropertyValue<@Nullable Pointer> property_clientObjectID = assetObject.getImmutablePropertyClientObjectId();
        ImmutablePropertyValue<@Nullable EglContextAsset> property_sourceContext = assetObject.getImmutablePropertySourceContext();
        ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_target = assetObject.getImmutablePropertyTarget();
        return new EglImageAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)property_attributes, (IAssetPropertyValue<Pointer>)property_clientObjectID, (IAssetPropertyValue<EglContextAsset>)property_sourceContext, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_target);
    }

    private static @NonNull EglSyncAsset createEglSyncAsset(@NonNull LightweightAssetBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        AbstractConstantOrAliasSpecExtended type = builder.resolveConstantProperty(assetAttachment, "type", CONSTANT_SET_EGL_SYNC_ASSET_TYPE, false, null);
        EglSyncAsset newAssetObject = EglSyncAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()), type);
        return newAssetObject;
    }

    private static @NonNull EglSyncAsset.Value updateEglSyncAsset(@NonNull LightweightAssetValueBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglSyncAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<EGLApi> callbacks = builder.getAssetProcessorCallbacks();
        EglSyncAsset assetObject = (EglSyncAsset)assetObjectValue.getAssetObject();
        EglDisplayAsset parentAsset = (EglDisplayAsset)assetObject.getParentAsset();
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(assetObjectValue.getAttributes());
        Map<AbstractConstantOrAliasSpecExtended, Long> value_attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        property_attributes.setValue(functionCall, value_attributes);
        SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_status = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObjectValue.getStatus());
        AbstractConstantOrAliasSpecExtended value_status = builder.resolveConstantProperty(assetAttachment, "status", CONSTANT_SET_EGL_SYNC_ASSET_STATUS, false, KapiSpec.EGL.constants.EGL_UNSIGNALED_KHR);
        property_status.setValue(functionCall, value_status);
        ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type = assetObject.getImmutablePropertyType();
        return new EglSyncAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)property_attributes, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_status, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)property_type);
    }

    private static @NonNull EglPbufferSurfaceAsset createEglPbufferSurfaceAsset(@NonNull LightweightAssetBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        EglConfigAsset config = builder.resolveAssetProperty(assetAttachment, "config", EglConfigAsset.class, parentAsset, false, null);
        EglPbufferSurfaceAsset newAssetObject = EglPbufferSurfaceAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()), config);
        return newAssetObject;
    }

    private static @NonNull EglPbufferSurfaceAsset.Value updateEglPbufferSurfaceAsset(@NonNull LightweightAssetValueBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglPbufferSurfaceAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<EGLApi> callbacks = builder.getAssetProcessorCallbacks();
        EglPbufferSurfaceAsset assetObject = (EglPbufferSurfaceAsset)assetObjectValue.getAssetObject();
        EglDisplayAsset parentAsset = (EglDisplayAsset)assetObject.getParentAsset();
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(assetObjectValue.getAttributes());
        Map<AbstractConstantOrAliasSpecExtended, Long> value_attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        property_attributes.setValue(functionCall, value_attributes);
        ImmutablePropertyValue<@NonNull EglConfigAsset> property_config = assetObject.getImmutablePropertyConfig();
        SimplePropertyValue<@Nullable Boolean> property_locked = new SimplePropertyValue<Boolean>(assetObjectValue.getLocked());
        Boolean value_locked = builder.resolveProperty(assetAttachment, "locked", Boolean.class, true, null);
        property_locked.setValue(functionCall, value_locked);
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(assetObjectValue.getPendingAttributes());
        Map<AbstractConstantOrAliasSpecExtended, Long> value_pendingAttributes = builder.resolveMapProperty(assetAttachment, "pendingAttributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        property_pendingAttributes.setValue(functionCall, value_pendingAttributes);
        SimplePropertyValue<@Nullable Integer> property_boundTexture = new SimplePropertyValue<Integer>(assetObjectValue.getBoundTexture());
        Integer value_boundTexture = builder.resolveProperty(assetAttachment, "boundTexture", Integer.class, true, null);
        property_boundTexture.setValue(functionCall, value_boundTexture);
        SimplePropertyValue<@Nullable EglContextAsset> property_sourceContext = new SimplePropertyValue<EglContextAsset>(assetObjectValue.getSourceContext());
        EglContextAsset value_sourceContext = builder.resolveAssetProperty(assetAttachment, "sourceContext", EglContextAsset.class, parentAsset, true, null);
        property_sourceContext.setValue(functionCall, value_sourceContext);
        return new EglPbufferSurfaceAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)property_attributes, (IAssetPropertyValue<EglConfigAsset>)property_config, (IAssetPropertyValue<Boolean>)property_locked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)property_pendingAttributes, (IAssetPropertyValue<Integer>)property_boundTexture, (IAssetPropertyValue<EglContextAsset>)property_sourceContext);
    }

    private static @NonNull EglPixmapSurfaceAsset createEglPixmapSurfaceAsset(@NonNull LightweightAssetBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        EglConfigAsset config = builder.resolveAssetProperty(assetAttachment, "config", EglConfigAsset.class, parentAsset, false, null);
        Pointer nativePixmap = builder.resolveProperty(assetAttachment, "nativePixmap", Pointer.class, false, null);
        EglPixmapSurfaceAsset newAssetObject = EglPixmapSurfaceAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()), config, nativePixmap);
        return newAssetObject;
    }

    private static @NonNull EglPixmapSurfaceAsset.Value updateEglPixmapSurfaceAsset(@NonNull LightweightAssetValueBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglPixmapSurfaceAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<EGLApi> callbacks = builder.getAssetProcessorCallbacks();
        EglPixmapSurfaceAsset assetObject = (EglPixmapSurfaceAsset)assetObjectValue.getAssetObject();
        EglDisplayAsset parentAsset = (EglDisplayAsset)assetObject.getParentAsset();
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(assetObjectValue.getAttributes());
        Map<AbstractConstantOrAliasSpecExtended, Long> value_attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        property_attributes.setValue(functionCall, value_attributes);
        ImmutablePropertyValue<@NonNull EglConfigAsset> property_config = assetObject.getImmutablePropertyConfig();
        SimplePropertyValue<@Nullable Boolean> property_locked = new SimplePropertyValue<Boolean>(assetObjectValue.getLocked());
        Boolean value_locked = builder.resolveProperty(assetAttachment, "locked", Boolean.class, true, null);
        property_locked.setValue(functionCall, value_locked);
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(assetObjectValue.getPendingAttributes());
        Map<AbstractConstantOrAliasSpecExtended, Long> value_pendingAttributes = builder.resolveMapProperty(assetAttachment, "pendingAttributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        property_pendingAttributes.setValue(functionCall, value_pendingAttributes);
        ImmutablePropertyValue<@Nullable Pointer> property_nativePixmap = assetObject.getImmutablePropertyNativePixmap();
        return new EglPixmapSurfaceAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)property_attributes, (IAssetPropertyValue<EglConfigAsset>)property_config, (IAssetPropertyValue<Boolean>)property_locked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)property_pendingAttributes, (IAssetPropertyValue<Pointer>)property_nativePixmap);
    }

    private static @NonNull EglWindowSurfaceAsset createEglWindowSurfaceAsset(@NonNull LightweightAssetBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        EglConfigAsset config = builder.resolveAssetProperty(assetAttachment, "config", EglConfigAsset.class, parentAsset, false, null);
        Pointer nativeWindow = builder.resolveProperty(assetAttachment, "nativeWindow", Pointer.class, false, null);
        EglWindowSurfaceAsset newAssetObject = EglWindowSurfaceAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, AssetItemID.valueOf(assetAttachment.getId()), config, nativeWindow);
        return newAssetObject;
    }

    private static @NonNull EglWindowSurfaceAsset.Value updateEglWindowSurfaceAsset(@NonNull LightweightAssetValueBuilder<EGLApi> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglWindowSurfaceAsset.Value assetObjectValue) {
        ILightweightAssetProcessorCallbacks<EGLApi> callbacks = builder.getAssetProcessorCallbacks();
        EglWindowSurfaceAsset assetObject = (EglWindowSurfaceAsset)assetObjectValue.getAssetObject();
        EglDisplayAsset parentAsset = (EglDisplayAsset)assetObject.getParentAsset();
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(assetObjectValue.getAttributes());
        Map<AbstractConstantOrAliasSpecExtended, Long> value_attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        property_attributes.setValue(functionCall, value_attributes);
        ImmutablePropertyValue<@NonNull EglConfigAsset> property_config = assetObject.getImmutablePropertyConfig();
        SimplePropertyValue<@Nullable Boolean> property_locked = new SimplePropertyValue<Boolean>(assetObjectValue.getLocked());
        Boolean value_locked = builder.resolveProperty(assetAttachment, "locked", Boolean.class, true, null);
        property_locked.setValue(functionCall, value_locked);
        MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(assetObjectValue.getPendingAttributes());
        Map<AbstractConstantOrAliasSpecExtended, Long> value_pendingAttributes = builder.resolveMapProperty(assetAttachment, "pendingAttributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        property_pendingAttributes.setValue(functionCall, value_pendingAttributes);
        ImmutablePropertyValue<@Nullable Pointer> property_nativeWindow = assetObject.getImmutablePropertyNativeWindow();
        return new EglWindowSurfaceAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)property_attributes, (IAssetPropertyValue<EglConfigAsset>)property_config, (IAssetPropertyValue<Boolean>)property_locked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)property_pendingAttributes, (IAssetPropertyValue<Pointer>)property_nativeWindow);
    }

    public static <API_MODEL, TYPE extends IAssetItem<API_MODEL, ?>, PARENT extends IAssetItem<API_MODEL, ?>> @NonNull TYPE create(@NonNull LightweightAssetBuilder<API_MODEL> builder, @NonNull KapiSpec.AssetTraits<?, TYPE, ?> traits, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @Nullable PARENT parentAsset) {
        AllAssetClasses classEnum = traits.ENUM;
        assert (classEnum != null);
        switch (classEnum) {
            case GL_ATOMIC_COUNTER_BUFFER_BINDING_POINT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlAtomicCounterBufferBindingPointAsset(builder, assetAttachment, functionCall);
            }
            case GL_BUFFER_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlBufferAsset(builder, assetAttachment, functionCall);
            }
            case GL_FRAMEBUFFER_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlFramebufferAsset(builder, assetAttachment, functionCall);
            }
            case GL_IMAGE_UNIT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlImageUnitAsset(builder, assetAttachment, functionCall);
            }
            case GL_PROGRAM_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlProgramAsset(builder, assetAttachment, functionCall);
            }
            case GL_PROGRAM_PIPELINE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlProgramPipelineAsset(builder, assetAttachment, functionCall);
            }
            case GL_QUERY_OBJECT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlQueryObjectAsset(builder, assetAttachment, functionCall);
            }
            case GL_RENDERBUFFER_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlRenderbufferAsset(builder, assetAttachment, functionCall);
            }
            case GL_SAMPLER_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlSamplerAsset(builder, assetAttachment, functionCall);
            }
            case GL_SHADER_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlShaderAsset(builder, assetAttachment, functionCall);
            }
            case GL_SHADER_STORAGE_BUFFER_BINDING_POINT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlShaderStorageBufferBindingPointAsset(builder, assetAttachment, functionCall);
            }
            case GL_SYNC_OBJECT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlSyncObjectAsset(builder, assetAttachment, functionCall);
            }
            case GL_TEXTURE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlTextureAsset(builder, assetAttachment, functionCall);
            }
            case GL_TEXTURE_UNIT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlTextureUnitAsset(builder, assetAttachment, functionCall);
            }
            case GL_TRANSFORM_FEEDBACK_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlTransformFeedbackAsset(builder, assetAttachment, functionCall);
            }
            case GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_POINT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlTransformFeedbackBufferBindingPointAsset(builder, assetAttachment, functionCall);
            }
            case GL_UNIFORM_BINDING_POINT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlUniformBindingPointAsset(builder, assetAttachment, functionCall);
            }
            case GL_VERTEX_ARRAY_OBJECT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlVertexArrayObjectAsset(builder, assetAttachment, functionCall);
            }
            case GL_VERTEX_ATTRIBUTE_NON_ARRAY_VALUE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlVertexAttributeNonArrayValueAsset(builder, assetAttachment, functionCall);
            }
            case GL_TEXTURE_IMAGE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlTextureImageAsset(builder, assetAttachment, functionCall, (GlTextureSurfaceAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_TEXTURE_SURFACE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlTextureSurfaceAsset(builder, assetAttachment, functionCall, (GlTextureAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_VERTEX_ATTRIBUTE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlVertexAttributeAsset(builder, assetAttachment, functionCall, (GlVertexArrayObjectAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_VERTEX_BUFFER_BINDING_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlVertexBufferBindingAsset(builder, assetAttachment, functionCall, (GlVertexArrayObjectAsset)NullUtils.neverNull(parentAsset));
            }
            case SHADER_UNIFORM: {
                return (TYPE)MidstreamAssetFactory.createShaderUniform(builder, assetAttachment, functionCall, (GlProgramAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_FRAMEBUFFER_RENDERBUFFER_ATTACHMENT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlFramebufferRenderbufferAttachmentAsset(builder, assetAttachment, functionCall, (GlFramebufferAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_FRAMEBUFFER_TEXTURE_ATTACHMENT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlFramebufferTextureAttachmentAsset(builder, assetAttachment, functionCall, (GlFramebufferAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_FRAMEBUFFER_TEXTURE_MULTIVIEW_ATTACHMENT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlFramebufferTextureMultiviewAttachmentAsset(builder, assetAttachment, functionCall, (GlFramebufferAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_FRAMEBUFFER_ZERO_ATTACHMENT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlFramebufferZeroAttachmentAsset(builder, assetAttachment, functionCall, (GlFramebufferAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_DISPLAY_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglDisplayAsset(builder, assetAttachment, functionCall);
            }
            case EGL_CONFIG_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglConfigAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_CONTEXT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglContextAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_IMAGE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglImageAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_SYNC_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglSyncAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_PBUFFER_SURFACE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglPbufferSurfaceAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_PIXMAP_SURFACE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglPixmapSurfaceAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_WINDOW_SURFACE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglWindowSurfaceAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
        }
        throw new AssertionError((Object)("Unexpected asset class for midstream trace processing in create: " + (Object)((Object)classEnum)));
    }

    public static <API_MODEL, TYPE extends IAssetItem<API_MODEL, VALUE>, VALUE extends IAssetItem.Value<TYPE>> @NonNull VALUE update(@NonNull LightweightAssetValueBuilder<API_MODEL> builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull VALUE assetObjectValue) {
        if (assetObjectValue instanceof GlAtomicCounterBufferBindingPointAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlAtomicCounterBufferBindingPointAsset(builder, assetAttachment, functionCall, (GlAtomicCounterBufferBindingPointAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlBufferAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlBufferAsset(builder, assetAttachment, functionCall, (GlBufferAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlFramebufferAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlFramebufferAsset(builder, assetAttachment, functionCall, (GlFramebufferAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlImageUnitAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlImageUnitAsset(builder, assetAttachment, functionCall, (GlImageUnitAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlProgramAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlProgramAsset(builder, assetAttachment, functionCall, (GlProgramAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlProgramPipelineAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlProgramPipelineAsset(builder, assetAttachment, functionCall, (GlProgramPipelineAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlQueryObjectAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlQueryObjectAsset(builder, assetAttachment, functionCall, (GlQueryObjectAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlRenderbufferAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlRenderbufferAsset(builder, assetAttachment, functionCall, (GlRenderbufferAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlSamplerAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlSamplerAsset(builder, assetAttachment, functionCall, (GlSamplerAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlShaderAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlShaderAsset(builder, assetAttachment, functionCall, (GlShaderAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlShaderStorageBufferBindingPointAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlShaderStorageBufferBindingPointAsset(builder, assetAttachment, functionCall, (GlShaderStorageBufferBindingPointAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlSyncObjectAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlSyncObjectAsset(builder, assetAttachment, functionCall, (GlSyncObjectAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlTextureAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlTextureAsset(builder, assetAttachment, functionCall, (GlTextureAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlTextureUnitAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlTextureUnitAsset(builder, assetAttachment, functionCall, (GlTextureUnitAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlTransformFeedbackAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlTransformFeedbackAsset(builder, assetAttachment, functionCall, (GlTransformFeedbackAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlTransformFeedbackBufferBindingPointAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlTransformFeedbackBufferBindingPointAsset(builder, assetAttachment, functionCall, (GlTransformFeedbackBufferBindingPointAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlUniformBindingPointAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlUniformBindingPointAsset(builder, assetAttachment, functionCall, (GlUniformBindingPointAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlVertexArrayObjectAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlVertexArrayObjectAsset(builder, assetAttachment, functionCall, (GlVertexArrayObjectAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlVertexAttributeNonArrayValueAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlVertexAttributeNonArrayValueAsset(builder, assetAttachment, functionCall, (GlVertexAttributeNonArrayValueAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlTextureImageAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlTextureImageAsset(builder, assetAttachment, functionCall, (GlTextureImageAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlTextureSurfaceAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlTextureSurfaceAsset(builder, assetAttachment, functionCall, (GlTextureSurfaceAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlVertexAttributeAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlVertexAttributeAsset(builder, assetAttachment, functionCall, (GlVertexAttributeAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlVertexBufferBindingAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlVertexBufferBindingAsset(builder, assetAttachment, functionCall, (GlVertexBufferBindingAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof ShaderUniform.Value) {
            return (VALUE)MidstreamAssetFactory.updateShaderUniform(builder, assetAttachment, functionCall, (ShaderUniform.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlFramebufferRenderbufferAttachmentAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlFramebufferRenderbufferAttachmentAsset(builder, assetAttachment, functionCall, (GlFramebufferRenderbufferAttachmentAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlFramebufferTextureAttachmentAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlFramebufferTextureAttachmentAsset(builder, assetAttachment, functionCall, (GlFramebufferTextureAttachmentAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlFramebufferTextureMultiviewAttachmentAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlFramebufferTextureMultiviewAttachmentAsset(builder, assetAttachment, functionCall, (GlFramebufferTextureMultiviewAttachmentAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof GlFramebufferZeroAttachmentAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateGlFramebufferZeroAttachmentAsset(builder, assetAttachment, functionCall, (GlFramebufferZeroAttachmentAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof EglDisplayAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateEglDisplayAsset(builder, assetAttachment, functionCall, (EglDisplayAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof EglConfigAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateEglConfigAsset(builder, assetAttachment, functionCall, (EglConfigAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof EglContextAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateEglContextAsset(builder, assetAttachment, functionCall, (EglContextAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof EglImageAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateEglImageAsset(builder, assetAttachment, functionCall, (EglImageAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof EglSyncAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateEglSyncAsset(builder, assetAttachment, functionCall, (EglSyncAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof EglPbufferSurfaceAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateEglPbufferSurfaceAsset(builder, assetAttachment, functionCall, (EglPbufferSurfaceAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof EglPixmapSurfaceAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateEglPixmapSurfaceAsset(builder, assetAttachment, functionCall, (EglPixmapSurfaceAsset.Value)assetObjectValue);
        }
        if (assetObjectValue instanceof EglWindowSurfaceAsset.Value) {
            return (VALUE)MidstreamAssetFactory.updateEglWindowSurfaceAsset(builder, assetAttachment, functionCall, (EglWindowSurfaceAsset.Value)assetObjectValue);
        }
        throw new AssertionError((Object)("Unexpected asset class for midstream trace processing in update: " + assetObjectValue));
    }

    public static abstract class FindExistingAssetHelper
    extends AbstractLightweightAssetProcessorBase<Object> {
        public @Nullable GlAtomicCounterBufferBindingPointAsset findGlAtomicCounterBufferBindingPointAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
            return FindExistingAssetHelper.getOrCreateNewGlAtomicCounterBufferBindingPointAsset(callbacks, functionCall, id);
        }

        public @Nullable GlBufferAsset findGlBufferAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getGlBufferAsset(callbacks, functionCall, instanceId, id);
        }

        public @Nullable GlFramebufferAsset findGlFramebufferAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getGlFramebufferAsset(callbacks, functionCall, instanceId, id, AssetItemID.valueOf(0));
        }

        public @Nullable GlImageUnitAsset findGlImageUnitAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
            return FindExistingAssetHelper.getOrCreateNewGlImageUnitAsset(callbacks, functionCall, id);
        }

        public @Nullable GlProgramAsset findGlProgramAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getGlProgramAsset(callbacks, functionCall, instanceId, id);
        }

        public @Nullable GlProgramPipelineAsset findGlProgramPipelineAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getGlProgramPipelineAsset(callbacks, functionCall, instanceId, id);
        }

        public @Nullable GlQueryObjectAsset findGlQueryObjectAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getGlQueryObjectAsset(callbacks, functionCall, instanceId, id);
        }

        public @Nullable GlRenderbufferAsset findGlRenderbufferAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getGlRenderbufferAsset(callbacks, functionCall, instanceId, id);
        }

        public @Nullable GlSamplerAsset findGlSamplerAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getGlSamplerAsset(callbacks, functionCall, instanceId, id);
        }

        public @Nullable GlShaderAsset findGlShaderAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getGlShaderAsset(callbacks, functionCall, instanceId, id);
        }

        public @Nullable GlShaderStorageBufferBindingPointAsset findGlShaderStorageBufferBindingPointAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
            return FindExistingAssetHelper.getOrCreateNewGlShaderStorageBufferBindingPointAsset(callbacks, functionCall, id);
        }

        public @Nullable GlSyncObjectAsset findGlSyncObjectAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getGlSyncObjectAsset(callbacks, functionCall, instanceId, id);
        }

        public @Nullable GlTextureAsset findGlTextureAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getGlTextureAsset(callbacks, functionCall, instanceId, id, AssetItemID.valueOf(0));
        }

        public @Nullable GlTextureUnitAsset findGlTextureUnitAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
            return FindExistingAssetHelper.getOrCreateNewGlTextureUnitAsset(callbacks, functionCall, id);
        }

        public @Nullable GlTransformFeedbackAsset findGlTransformFeedbackAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getGlTransformFeedbackAsset(callbacks, functionCall, instanceId, id, AssetItemID.valueOf(0));
        }

        public @Nullable GlTransformFeedbackBufferBindingPointAsset findGlTransformFeedbackBufferBindingPointAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
            return FindExistingAssetHelper.getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(callbacks, functionCall, id);
        }

        public @Nullable GlUniformBindingPointAsset findGlUniformBindingPointAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
            return FindExistingAssetHelper.getOrCreateNewGlUniformBindingPointAsset(callbacks, functionCall, id);
        }

        public @Nullable GlVertexArrayObjectAsset findGlVertexArrayObjectAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getGlVertexArrayObjectAsset(callbacks, functionCall, instanceId, id, AssetItemID.valueOf(0));
        }

        public @Nullable GlVertexAttributeNonArrayValueAsset findGlVertexAttributeNonArrayValueAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
            return FindExistingAssetHelper.getOrCreateNewGlVertexAttributeNonArrayValueAsset(callbacks, functionCall, id);
        }

        public @Nullable GlTextureImageAsset findGlTextureImageAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull GlTextureSurfaceAsset parentAsset) {
            return FindExistingAssetHelper.getGlTextureImageAsset(callbacks, functionCall, instanceId, parentAsset, id);
        }

        public @Nullable GlTextureSurfaceAsset findGlTextureSurfaceAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull GlTextureAsset parentAsset) {
            return FindExistingAssetHelper.getGlTextureSurfaceAsset(callbacks, functionCall, instanceId, parentAsset, id);
        }

        public @Nullable GlVertexAttributeAsset findGlVertexAttributeAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, @NonNull GlVertexArrayObjectAsset parentAsset) {
            GlVertexAttributeNonArrayValueAsset temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_0 = AbstractGlesAssetValueProcessorBase.getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource(callbacks, functionCall, id);
            assert (temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_0 != null);
            return FindExistingAssetHelper.getOrCreateNewGlVertexAttributeAsset(callbacks, functionCall, parentAsset, id, temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_0);
        }

        public @Nullable GlVertexBufferBindingAsset findGlVertexBufferBindingAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, @NonNull GlVertexArrayObjectAsset parentAsset) {
            return FindExistingAssetHelper.getOrCreateNewGlVertexBufferBindingAsset(callbacks, functionCall, parentAsset, id);
        }

        public @Nullable ShaderUniform findShaderUniform(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull GlProgramAsset parentAsset) {
            return FindExistingAssetHelper.getShaderUniform(callbacks, functionCall, instanceId, parentAsset, id);
        }

        public @Nullable GlFramebufferRenderbufferAttachmentAsset findGlFramebufferRenderbufferAttachmentAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull GlFramebufferAsset parentAsset) {
            return FindExistingAssetHelper.getGlFramebufferRenderbufferAttachmentAsset(callbacks, functionCall, instanceId, parentAsset, id);
        }

        public @Nullable GlFramebufferTextureAttachmentAsset findGlFramebufferTextureAttachmentAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull GlFramebufferAsset parentAsset) {
            return FindExistingAssetHelper.getGlFramebufferTextureAttachmentAsset(callbacks, functionCall, instanceId, parentAsset, id);
        }

        public @Nullable GlFramebufferTextureMultiviewAttachmentAsset findGlFramebufferTextureMultiviewAttachmentAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull GlFramebufferAsset parentAsset) {
            return FindExistingAssetHelper.getGlFramebufferTextureMultiviewAttachmentAsset(callbacks, functionCall, instanceId, parentAsset, id);
        }

        public @Nullable GlFramebufferZeroAttachmentAsset findGlFramebufferZeroAttachmentAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull GlFramebufferAsset parentAsset) {
            return FindExistingAssetHelper.getGlFramebufferZeroAttachmentAsset(callbacks, functionCall, instanceId, parentAsset, id);
        }

        public @Nullable EglDisplayAsset findEglDisplayAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId) {
            return FindExistingAssetHelper.getEglDisplayAsset(callbacks, functionCall, instanceId, id);
        }

        public @Nullable EglConfigAsset findEglConfigAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, @NonNull EglDisplayAsset parentAsset) {
            return FindExistingAssetHelper.getOrCreateNewEglConfigAsset(callbacks, functionCall, parentAsset, id);
        }

        public @Nullable EglContextAsset findEglContextAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull EglDisplayAsset parentAsset) {
            return FindExistingAssetHelper.getEglContextAsset(callbacks, functionCall, instanceId, parentAsset, id);
        }

        public @Nullable EglImageAsset findEglImageAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull EglDisplayAsset parentAsset) {
            return FindExistingAssetHelper.getEglImageAsset(callbacks, functionCall, instanceId, parentAsset, id);
        }

        public @Nullable EglSyncAsset findEglSyncAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull EglDisplayAsset parentAsset) {
            return FindExistingAssetHelper.getEglSyncAsset(callbacks, functionCall, instanceId, parentAsset, id);
        }

        public @Nullable EglPbufferSurfaceAsset findEglPbufferSurfaceAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull EglDisplayAsset parentAsset) {
            return FindExistingAssetHelper.getEglPbufferSurfaceAsset(callbacks, functionCall, instanceId, parentAsset, id);
        }

        public @Nullable EglPixmapSurfaceAsset findEglPixmapSurfaceAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull EglDisplayAsset parentAsset) {
            return FindExistingAssetHelper.getEglPixmapSurfaceAsset(callbacks, functionCall, instanceId, parentAsset, id);
        }

        public @Nullable EglWindowSurfaceAsset findEglWindowSurfaceAsset(@NonNull LightweightAssetBuilder.ILightweightAssetBuilderCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, long instanceId, @NonNull EglDisplayAsset parentAsset) {
            return FindExistingAssetHelper.getEglWindowSurfaceAsset(callbacks, functionCall, instanceId, parentAsset, id);
        }
    }
}

