/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset;

import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.lang.handle.HandleArrayAttachment;
import com.arm.mgd.core.lang.handle.HandleAttachment;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.lightweight.state.IStateItemValue;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AssetItemID
implements Comparable<AssetItemID> {
    public static final @NonNull AssetItemID ZERO = new AssetItemID(0L);
    private static final int CACHE_LIMIT_SIZE = 900;
    private static final int CACHE_MAX_SIZE = 1024;
    private static final Map<@NonNull Long, SoftReference<AssetItemID>> valueCache = new LinkedHashMap<Long, SoftReference<AssetItemID>>();
    private final long id;

    public static @NonNull AssetItemID valueOf(int id) {
        return AssetItemID.valueOf((long)id & 0xFFFFFFFFL);
    }

    public static @NonNull AssetItemID valueOf(@NonNull IStateItemValue<?> stateValue) {
        return AssetItemID.valueOf(stateValue.getValueAsLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull AssetItemID valueOf(long id) {
        Long idObject = NullUtils.longValueOf((long)id);
        Map<Long, SoftReference<AssetItemID>> map = valueCache;
        synchronized (map) {
            AssetItemID result;
            SoftReference<AssetItemID> weakRef = valueCache.get(idObject);
            AssetItemID assetItemID = result = weakRef != null ? weakRef.get() : null;
            if (result != null) {
                return result;
            }
            if (valueCache.size() > 1024) {
                Iterator<Map.Entry<@NonNull Long, SoftReference<AssetItemID>>> iterator = valueCache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<@NonNull Long, SoftReference<AssetItemID>> entry = iterator.next();
                    if (entry.getValue().get() != null) continue;
                    iterator.remove();
                }
                iterator = valueCache.entrySet().iterator();
                while (iterator.hasNext() && valueCache.size() > 900) {
                    iterator.next();
                    iterator.remove();
                }
            }
            AssetItemID newResult = new AssetItemID(id);
            valueCache.put(idObject, new SoftReference<AssetItemID>(newResult));
            return newResult;
        }
    }

    public static @NonNull AssetItemID valueOf(@NonNull Long id) {
        return AssetItemID.valueOf((long)id);
    }

    public static @NonNull AssetItemID valueOf(@NonNull LongPtrArgAttachment id) {
        return AssetItemID.valueOf(id.getValue());
    }

    public static @NonNull List<@NonNull AssetItemID> valueOf(@Nullable LongsArgAttachment longs) {
        return longs != null ? longs.asList().stream().map(AssetItemID::valueOf).collect(Collectors.toList()) : Collections.EMPTY_LIST;
    }

    public static @NonNull List<@NonNull AssetItemID> valueOf(@Nullable HandleArrayAttachment handles) {
        return handles != null ? handles.asList().stream().map(AssetItemID::valueOf).collect(Collectors.toList()) : Collections.EMPTY_LIST;
    }

    public static @NonNull AssetItemID valueOf(@NonNull Pointer id) {
        return AssetItemID.valueOf(id.address());
    }

    public static @NonNull AssetItemID valueOf(Handle handle) {
        return AssetItemID.valueOf(handle.getHandleValue());
    }

    public static @NonNull AssetItemID valueOf(HandleAttachment handlePointer) {
        return AssetItemID.valueOf(handlePointer.getValue().getHandleValue());
    }

    private AssetItemID(long id) {
        this.id = id;
    }

    public long asLong() {
        return this.id;
    }

    @Override
    public int compareTo(@NonNull AssetItemID o) {
        return Long.compare(this.id, o.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AssetItemID) {
            AssetItemID that = (AssetItemID)obj;
            return this.id == that.id;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return Long.toString(this.id);
    }
}

