/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset;

import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.util.BinarySearchList;
import com.arm.mgd.core.util.Neighbours;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.FunctionCallIDRange;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AssetContainer<ASSET_CLASS extends IAssetItem<?, ?>>
implements Iterable<ASSET_CLASS> {
    private final @NonNull Map<@NonNull AssetItemID, @Nullable AssetList<ASSET_CLASS>> assets = new HashMap<AssetItemID, AssetList<ASSET_CLASS>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NonNull ASSET_CLASS newAsset) throws IllegalArgumentException {
        Map<AssetItemID, AssetList<ASSET_CLASS>> map = this.assets;
        synchronized (map) {
            AssetList<ASSET_CLASS> assetList = this.assets.get(newAsset.getId());
            if (assetList == null) {
                assetList = new AssetList();
                this.assets.put(newAsset.getId(), assetList);
            }
            assetList.add(newAsset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull Map<@NonNull AssetItemID, @NonNull List<@NonNull ASSET_CLASS>> getAllChildren() {
        Map<AssetItemID, AssetList<ASSET_CLASS>> map = this.assets;
        synchronized (map) {
            TreeMap<@NonNull AssetItemID, @NonNull List<@NonNull ASSET_CLASS>> result = new TreeMap<AssetItemID, List<ASSET_CLASS>>();
            for (Map.Entry<AssetItemID, AssetList<ASSET_CLASS>> entry : this.assets.entrySet()) {
                result.put(entry.getKey(), entry.getValue().getAsList());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ASSET_CLASS getLastAssetBefore(@NonNull AssetItemID id, @NonNull FunctionCallID callID, boolean live) {
        Map<AssetItemID, AssetList<ASSET_CLASS>> map = this.assets;
        synchronized (map) {
            AssetList<ASSET_CLASS> assetList;
            block6: {
                assetList = this.assets.get(id);
                if (assetList != null && !assetList.isEmpty()) break block6;
                return null;
            }
            @NonNull List<@NonNull ASSET_CLASS> assets = assetList.getAsList();
            @NonNull IAssetItem lastAsset = (IAssetItem)NullUtils.neverNull((Object)((IAssetItem)assets.get(assets.size() - 1)));
            if (this.compareAssetForLastLiveBefore(lastAsset, callID, live) == 0) {
                return (ASSET_CLASS)lastAsset;
            }
            Neighbours<@Nullable IAssetItem> neighbours = BinarySearchList.findNeighbours(assets, a -> this.compareAssetForLastLiveBefore((IAssetItem)NullUtils.neverNull((Object)a), callID, live));
            if (neighbours.getMatching() != null) {
                return (ASSET_CLASS)neighbours.getMatching();
            }
            return (ASSET_CLASS)neighbours.getBefore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ASSET_CLASS getLastAssetBefore(@NonNull AssetItemID id, @NonNull FunctionCallID callID, long specificInstanceId) {
        Map<AssetItemID, AssetList<ASSET_CLASS>> map = this.assets;
        synchronized (map) {
            AssetList<ASSET_CLASS> assetList;
            block6: {
                assetList = this.assets.get(id);
                if (assetList != null && !assetList.isEmpty()) break block6;
                return null;
            }
            List<@NonNull ASSET_CLASS> assets = assetList.getAsList();
            for (IAssetItem asset : assets) {
                if (asset.getUniqueInstanceId().equals(UniqueInstanceId.NO_UNIQUE_INSTANCE_ID) || asset.getUniqueInstanceId().instanceCounter != specificInstanceId) continue;
                assert (callID.compareTo(asset.getCreatingFunction().getID()) >= 0);
                return (ASSET_CLASS)asset;
            }
            return null;
        }
    }

    @Override
    public @NonNull Iterator<@NonNull ASSET_CLASS> iterator() {
        return this.getAllChildren().values().stream().flatMap(l -> l.stream()).collect(Collectors.toList()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull String toString() {
        Map<AssetItemID, AssetList<ASSET_CLASS>> map = this.assets;
        synchronized (map) {
            return this.assets.toString();
        }
    }

    private int compareAssetForLastLiveBefore(@NonNull ASSET_CLASS asset, @NonNull FunctionCallID callID, boolean live) {
        FunctionCallIDRange bounds;
        FunctionCallIDRange functionCallIDRange = bounds = live ? asset.getLifecycleManager().getAssetLiveBounds() : asset.getLifecycleManager().getAssetRetainedBounds();
        if (bounds.contains(callID)) {
            return 0;
        }
        if (bounds.getFrom().compareTo(callID) > 0) {
            return 1;
        }
        assert (bounds.isClosedRange() && ((FunctionCallID)NullUtils.neverNull((Object)bounds.getTo())).compareTo(callID) <= 0);
        return -1;
    }

    private static class AssetList<ASSET_CLASS extends IAssetItem<?, ?>>
    implements Iterable<ASSET_CLASS> {
        private final @NonNull List<@NonNull ASSET_CLASS> assets = new ArrayList<ASSET_CLASS>();

        private AssetList() {
        }

        public void add(@NonNull ASSET_CLASS newAsset) throws IllegalArgumentException {
            FunctionCallID creationID = newAsset.getCreatingFunction().getID();
            for (IAssetItem asset : this.assets) {
                FunctionCallIDRange bounds = asset.getLifecycleManager().getAssetLiveBounds();
                if (bounds.isClosedRange() && ((FunctionCallID)NullUtils.neverNull((Object)bounds.getTo())).compareTo(creationID) <= 0) continue;
                throw new IllegalArgumentException("Overlapping asset lifecycle detected: " + bounds + " vs " + creationID + " for " + asset + " vs " + newAsset);
            }
            this.assets.add(newAsset);
        }

        public @NonNull List<@NonNull ASSET_CLASS> getAsList() {
            return Collections.unmodifiableList(this.assets.subList(0, this.assets.size()));
        }

        public boolean isEmpty() {
            return this.assets.isEmpty();
        }

        @Override
        public @NonNull Iterator<@NonNull ASSET_CLASS> iterator() {
            return this.assets.iterator();
        }

        public @NonNull String toString() {
            return this.assets.toString();
        }
    }
}

