/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetContainer;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractAssetContainerMap<CHILD_TYPE extends IAssetItem<?, ?>> {
    private final Map<@NonNull AssetTableSpec, @Nullable AssetContainer<CHILD_TYPE>> childAssets = new HashMap<AssetTableSpec, AssetContainer<CHILD_TYPE>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildAsset(@NonNull CHILD_TYPE newAsset) throws IllegalArgumentException {
        if (!this.isAcceptableClass(newAsset.getAssetTableSpec())) {
            throw new IllegalArgumentException("Invalid child asset " + newAsset.getClass().getSimpleName() + ". Unexpected type.");
        }
        Map<AssetTableSpec, AssetContainer<CHILD_TYPE>> map = this.childAssets;
        synchronized (map) {
            AssetTableSpec type = newAsset.getAssetTableSpec();
            AssetContainer<Object> container = this.childAssets.get(type);
            if (container == null) {
                container = new AssetContainer();
                this.childAssets.put(type, container);
            }
            container.add(newAsset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends CHILD_TYPE> Iterator<@NonNull T> childAssetIterator(KapiSpec.AssetTraits<?, T, ?> traits) {
        Map<AssetTableSpec, AssetContainer<CHILD_TYPE>> map = this.childAssets;
        synchronized (map) {
            AssetContainer<CHILD_TYPE> children = this.childAssets.get(traits.SPEC);
            if (children == null) {
                return Collections.EMPTY_LIST.iterator();
            }
            return children.iterator();
        }
    }

    public Iterator<@NonNull AssetTableSpec> childTypeIterator() {
        return this.childAssets.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<CHILD_TYPE> callback) {
        Map<AssetTableSpec, AssetContainer<CHILD_TYPE>> map = this.childAssets;
        synchronized (map) {
            for (AssetContainer<CHILD_TYPE> entry : this.childAssets.values()) {
                assert (entry != null) : "Not expecting the entry to be null.";
                for (IAssetItem childAsset : entry) {
                    callback.accept(childAsset);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends CHILD_TYPE> Map<@NonNull AssetItemID, @NonNull List<@NonNull T>> getAllChildren(KapiSpec.AssetTraits<?, T, ?> traits) {
        Map<AssetTableSpec, AssetContainer<CHILD_TYPE>> map = this.childAssets;
        synchronized (map) {
            AssetContainer<CHILD_TYPE> container = this.childAssets.get(traits.SPEC);
            if (container == null) {
                return Collections.EMPTY_MAP;
            }
            return container.getAllChildren();
        }
    }

    public <T extends CHILD_TYPE> @Nullable T getLastAssetBefore(KapiSpec.AssetTraits<?, T, ?> traits, AssetItemID id, FunctionCallID atCallID, boolean live) {
        Map<AssetTableSpec, AssetContainer<CHILD_TYPE>> map = this.childAssets;
        synchronized (map) {
            AssetContainer<CHILD_TYPE> container;
            block5: {
                container = this.childAssets.get(traits.SPEC);
                if (container != null) break block5;
                return null;
            }
            @Nullable CHILD_TYPE result = container.getLastAssetBefore(id, atCallID, live);
            if (result == null || traits.LIGHTWEIGHT_ASSET_CLASS.isAssignableFrom(result.getClass())) {
                return (T)result;
            }
            throw new ClassCastException(String.format("Cannot cast from %s to %s", result.getClass().getName(), traits.LIGHTWEIGHT_ASSET_CLASS.getName()));
        }
    }

    public <T extends CHILD_TYPE> @Nullable T getLastAssetBefore(KapiSpec.AssetTraits<?, T, ?> traits, AssetItemID id, FunctionCallID atCallID, long specificInstanceId) {
        Map<AssetTableSpec, AssetContainer<CHILD_TYPE>> map = this.childAssets;
        synchronized (map) {
            AssetContainer<CHILD_TYPE> container;
            block5: {
                container = this.childAssets.get(traits.SPEC);
                if (container != null) break block5;
                return null;
            }
            @Nullable CHILD_TYPE result = container.getLastAssetBefore(id, atCallID, specificInstanceId);
            if (result == null || traits.LIGHTWEIGHT_ASSET_CLASS.isAssignableFrom(result.getClass())) {
                return (T)result;
            }
            throw new ClassCastException(String.format("Cannot cast from %s to %s", result.getClass().getName(), traits.LIGHTWEIGHT_ASSET_CLASS.getName()));
        }
    }

    public abstract boolean isAcceptableClass(AssetTableSpec var1);

    public abstract <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAllAsDeleted(KapiSpec.AssetTraits<?, ? extends CHILD_TYPE, ?> traits, FunctionCall deletingFunction) {
        Map<AssetTableSpec, AssetContainer<CHILD_TYPE>> map = this.childAssets;
        synchronized (map) {
            AssetContainer<CHILD_TYPE> entry = this.childAssets.get(traits.SPEC);
            if (entry != null) {
                for (IAssetItem childAsset : entry) {
                    assert (childAsset != null) : "Not expecting the child asset to be null.";
                    if (childAsset.getLifecycleManager().isDeleted()) continue;
                    childAsset.getLifecycleManager().delete(deletingFunction);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAllAsDeleted(FunctionCall deletingFunction) {
        Map<AssetTableSpec, AssetContainer<CHILD_TYPE>> map = this.childAssets;
        synchronized (map) {
            for (AssetContainer<CHILD_TYPE> entry : this.childAssets.values()) {
                assert (entry != null) : "Not expecting the entry to be null.";
                for (IAssetItem childAsset : entry) {
                    assert (childAsset != null) : "Not expecting the child asset to be null.";
                    if (childAsset.getLifecycleManager().isDeleted()) continue;
                    childAsset.getLifecycleManager().delete(deletingFunction);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<AssetTableSpec, AssetContainer<CHILD_TYPE>> map = this.childAssets;
        synchronized (map) {
            return this.childAssets.toString();
        }
    }
}

