/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight;

import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.lightweight.processors.TraceDataTraceItemProcessor;
import com.arm.mgd.utils.NullUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class LightweightModel
implements ICoreLoggingSource {
    private final AbstractTarget abstractTarget;
    private final TraceDataTraceItemProcessor processor;
    private final Map<Integer, TracedProcess> tracedProcesses = new HashMap<Integer, TracedProcess>();

    public LightweightModel(AbstractTarget abstractTarget) {
        this.abstractTarget = abstractTarget;
        this.processor = new TraceDataTraceItemProcessor(this, null);
    }

    @Override
    public String getCoreLoggingSourceKey() {
        return (String)NullUtils.neverNull((Object)this.abstractTarget.getCoreLoggingSourceKey());
    }

    public TraceDataTraceItemProcessor getProcessor() {
        return this.processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TracedProcess getTracedProcess(int processId) {
        Integer key = processId;
        Map<Integer, TracedProcess> map = this.tracedProcesses;
        synchronized (map) {
            TracedProcess result = this.tracedProcesses.get(key);
            if (result == null) {
                result = new TracedProcess(this, processId);
                this.tracedProcesses.put(key, result);
                this.processor.addDependentProcessor(result.getProcessModelProcessor());
            }
            return result;
        }
    }

    public void setIsComplete() {
        if (!this.processor.isShutdownRequested()) {
            this.processor.shutdown();
        }
    }

    public boolean waitForModelProcessorToComplete(long timeoutMs) {
        long startTime = System.currentTimeMillis();
        while (!this.processor.isShutdown()) {
            try {
                this.processor.waitOnEvent();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - startTime <= timeoutMs) continue;
            return false;
        }
        return true;
    }
}

