/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight;

import com.arm.mgd.core.util.ComparatorUtils;
import com.arm.mgd.lightweight.FunctionCallID;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class FunctionCallIDRange {
    private final FunctionCallID from;
    private final @Nullable FunctionCallID to;

    public FunctionCallIDRange(FunctionCallID from) {
        this(from, null);
    }

    public FunctionCallIDRange(FunctionCallID from, @Nullable FunctionCallID to) {
        if (to != null && from.compareTo(to) > 0) {
            throw new IllegalArgumentException("Invalid function call range [" + from + ", " + to + ")");
        }
        this.from = from;
        this.to = to;
    }

    public boolean contains(FunctionCallID at) {
        if (at.compareTo(this.from) >= 0) {
            if (this.to != null) {
                return at.compareTo(this.to) < 0;
            }
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof FunctionCallIDRange) {
            FunctionCallIDRange that = (FunctionCallIDRange)obj;
            return this.from.equals(that.from) && ComparatorUtils.equalNullables(this.to, that.to);
        }
        return false;
    }

    public FunctionCallID getFrom() {
        return this.from;
    }

    public @Nullable FunctionCallID getTo() {
        return this.to;
    }

    public int hashCode() {
        return this.from.hashCode() ^ (this.to != null ? this.to.hashCode() : 0) * 31;
    }

    public boolean isClosedRange() {
        return this.to != null;
    }

    public String toString() {
        return String.format("[%s,%s)", this.from, this.to != null ? this.to : "");
    }
}

