/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.gen;

import com.arm.mgd.kapi.ApiBase;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.gen.AssetObjectSpec;
import com.arm.mgd.kapi.gen.TargetBindingGroupSpec;
import com.arm.mgd.kapi.gen.TargetBindingSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="XTargetBindingGroupSpec", propOrder={"targetBinding"})
@XmlSeeAlso(value={TargetBindingGroupSpec.class})
public class XTargetBindingGroupSpec
extends ApiBase {
    @XmlElement(required=true)
    protected List<TargetBindingSpec> targetBinding;
    @XmlAttribute(name="name", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    protected String name;
    @XmlTransient
    private final Map<AbstractConstantOrAliasSpecExtended, TargetBindingSpec> targetByConstantMap = new HashMap<AbstractConstantOrAliasSpecExtended, TargetBindingSpec>();
    @XmlTransient
    private final Map<String, TargetBindingSpec> targetByNameMap = new HashMap<String, TargetBindingSpec>();
    @XmlTransient
    private boolean providesStateInformation = false;
    @XmlTransient
    private AssetObjectSpec stateAssetRef;

    public List<TargetBindingSpec> getTargetBinding() {
        if (this.targetBinding == null) {
            this.targetBinding = new ArrayList<TargetBindingSpec>();
        }
        return this.targetBinding;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    protected final void resolveThis() {
        boolean ignoreStateType = false;
        for (TargetBindingSpec tbs : this.getTargetBinding()) {
            AssetObjectSpec currentAssetSpec;
            this.targetByConstantMap.put(tbs.getTarget(), tbs);
            this.targetByNameMap.put(tbs.getTarget().getName(), tbs);
            this.providesStateInformation |= tbs.state != null;
            AssetObjectSpec assetObjectSpec = currentAssetSpec = tbs.state != null ? tbs.state.getAssetClass() : null;
            if (tbs.state != null && tbs.state.isIndexed()) {
                ignoreStateType = true;
                this.stateAssetRef = null;
                continue;
            }
            if (this.stateAssetRef == null && currentAssetSpec != null && !ignoreStateType) {
                this.stateAssetRef = currentAssetSpec;
                continue;
            }
            if (this.stateAssetRef == null || currentAssetSpec == null || this.stateAssetRef == currentAssetSpec) continue;
            ignoreStateType = true;
            this.stateAssetRef = null;
        }
    }

    public final TargetBindingSpec getTargetBinding(AbstractConstantOrAliasSpecExtended target) {
        return this.targetByConstantMap.get(target);
    }

    public final TargetBindingSpec getTargetBinding(String targetName) {
        return this.targetByNameMap.get(targetName);
    }

    public final boolean isStateInformationProvided() {
        return this.providesStateInformation;
    }

    public final AssetObjectSpec getStateAssetRef() {
        return this.stateAssetRef;
    }
}

