/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.gen;

import com.arm.mgd.kapi.ApiBase;
import com.arm.mgd.kapi.gen.AssetPluginDetailsSpec;
import com.arm.mgd.kapi.gen.AssetPluginItemSpec;
import com.arm.mgd.kapi.gen.InterceptorAssetPluginSpec;
import com.arm.mgd.kapi.gen.InterceptorPluginSpec;
import com.arm.mgd.kapi.gen.InterceptorSettingsSpec;
import com.arm.mgd.kapi.gen.StoreImplicitBuffersSpec;
import com.arm.mgd.kapi.gen.StoreOutputBuffersSpec;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="XInterceptorSettingsSpec", propOrder={"plugin", "assetPlugin", "storeImplicitBuffers", "storeOutputBuffers"})
@XmlSeeAlso(value={InterceptorSettingsSpec.class})
public class XInterceptorSettingsSpec
extends ApiBase {
    @XmlSchemaType(name="string")
    protected List<InterceptorPluginSpec> plugin;
    protected List<InterceptorAssetPluginSpec> assetPlugin;
    protected List<StoreImplicitBuffersSpec> storeImplicitBuffers;
    protected List<StoreOutputBuffersSpec> storeOutputBuffers;

    public List<InterceptorPluginSpec> getPlugin() {
        if (this.plugin == null) {
            this.plugin = new ArrayList<InterceptorPluginSpec>();
        }
        return this.plugin;
    }

    public List<InterceptorAssetPluginSpec> getAssetPlugin() {
        if (this.assetPlugin == null) {
            this.assetPlugin = new ArrayList<InterceptorAssetPluginSpec>();
        }
        return this.assetPlugin;
    }

    public List<StoreImplicitBuffersSpec> getStoreImplicitBuffers() {
        if (this.storeImplicitBuffers == null) {
            this.storeImplicitBuffers = new ArrayList<StoreImplicitBuffersSpec>();
        }
        return this.storeImplicitBuffers;
    }

    public List<StoreOutputBuffersSpec> getStoreOutputBuffers() {
        if (this.storeOutputBuffers == null) {
            this.storeOutputBuffers = new ArrayList<StoreOutputBuffersSpec>();
        }
        return this.storeOutputBuffers;
    }

    public final boolean requiresPlugin(InterceptorPluginSpec r) {
        for (InterceptorPluginSpec p : this.getPlugin()) {
            if (!p.equals((Object)r)) continue;
            return true;
        }
        return false;
    }

    public final String[] getAllAssetPluginNames() {
        return this.getAllAssetPluginNames(false);
    }

    public final String[] getAllAlwaysAssetPluginNames() {
        return this.getAllAssetPluginNames(true);
    }

    private final String[] getAllAssetPluginNames(boolean onlyAlwaysPlugins) {
        ArrayList<String> assetPluginNames = new ArrayList<String>();
        for (InterceptorAssetPluginSpec p : this.getAssetPlugin()) {
            XInterceptorSettingsSpec.addPluginNameToList(assetPluginNames, p.getBefore(), onlyAlwaysPlugins);
            XInterceptorSettingsSpec.addPluginNameToList(assetPluginNames, p.getReplace(), onlyAlwaysPlugins);
            XInterceptorSettingsSpec.addPluginNameToList(assetPluginNames, p.getAfter(), onlyAlwaysPlugins);
            XInterceptorSettingsSpec.addPluginNameToList(assetPluginNames, p.getEnd(), onlyAlwaysPlugins);
        }
        return assetPluginNames.toArray(new String[assetPluginNames.size()]);
    }

    private static void addPluginNameToList(List<String> assetPluginNames, AssetPluginItemSpec itemSpec, boolean onlyAlwaysPlugins) {
        if (itemSpec != null) {
            for (AssetPluginDetailsSpec d : itemSpec.getPlugin()) {
                if ((!onlyAlwaysPlugins || !XInterceptorSettingsSpec.isAlways(d)) && onlyAlwaysPlugins || assetPluginNames.contains(d.getName())) continue;
                assetPluginNames.add(d.getName());
            }
        }
    }

    private static boolean isAlways(AssetPluginDetailsSpec spec) {
        return Boolean.TRUE.equals(spec.isAlways());
    }

    public final List<AssetPluginDetailsSpec> getAssetPlugins(InterceptorPluginSpec r) {
        ArrayList<AssetPluginDetailsSpec> assetPluginDetailsSpecs = new ArrayList<AssetPluginDetailsSpec>();
        for (InterceptorAssetPluginSpec p : this.getAssetPlugin()) {
            AssetPluginItemSpec spec;
            switch (r) {
                case BEFORE_INTERCEPT: {
                    spec = p.getBefore();
                    break;
                }
                case REPLACE_INTERCEPT: {
                    spec = p.getReplace();
                    break;
                }
                case AFTER_INTERCEPT: {
                    spec = p.getAfter();
                    break;
                }
                case END_INTERCEPT: {
                    spec = p.getEnd();
                    break;
                }
                default: {
                    throw new AssertionError((Object)r);
                }
            }
            if (spec == null) continue;
            assetPluginDetailsSpecs.addAll(spec.getPlugin());
        }
        if (r == InterceptorPluginSpec.REPLACE_INTERCEPT) {
            if (assetPluginDetailsSpecs.size() > 1) {
                throw new AssertionError((Object)"More than one replace asset plugin");
            }
            if (assetPluginDetailsSpecs.size() == 1 && this.requiresPlugin(InterceptorPluginSpec.REPLACE_INTERCEPT)) {
                throw new AssertionError((Object)"Both a replace plugin and a replace asset plugin have been specified");
            }
        } else if (r == InterceptorPluginSpec.END_INTERCEPT) {
            for (AssetPluginDetailsSpec spec : assetPluginDetailsSpecs) {
                if (XInterceptorSettingsSpec.isAlways(spec)) {
                    throw new AssertionError((Object)"End always plugins should be marked as after rather than end");
                }
            }
        }
        return assetPluginDetailsSpecs;
    }

    public final List<AssetPluginDetailsSpec> getAlwaysAssetPlugins(InterceptorPluginSpec r) {
        List<AssetPluginDetailsSpec> assetPluginDetailsSpecs = this.getAssetPlugins(r);
        assetPluginDetailsSpecs.removeIf(spec -> !XInterceptorSettingsSpec.isAlways(spec));
        return assetPluginDetailsSpecs;
    }
}

