/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.gen;

import com.arm.mgd.kapi.IFunctionOrAliasSpec;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.FunctionAliasSpec;
import com.arm.mgd.kapi.extended.FunctionSpec;
import com.arm.mgd.kapi.gen.Api;
import com.arm.mgd.kapi.gen.FunctionSpecNoName;
import com.arm.mgd.kapi.gen.VersionsSpec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="XFunctionSpec")
public class XFunctionSpec
extends FunctionSpecNoName
implements IFunctionOrAliasSpec {
    @XmlAttribute(name="name", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    protected String name;
    @XmlAttribute(name="annotationClass")
    protected String annotationClass;
    @XmlTransient
    protected boolean isGetError_;
    protected final Map<String, ArgumentSpec> argumentNameMap = new HashMap<String, ArgumentSpec>();
    protected final Map<ArgumentSpec, Integer> argumentIndexMap = new HashMap<ArgumentSpec, Integer>();
    protected final Map<String, FunctionAliasSpec> aliasNameMap = new HashMap<String, FunctionAliasSpec>();
    protected boolean isAlwaysFrameEnd = false;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getAnnotationClass() {
        if (this.annotationClass == null) {
            return "";
        }
        return this.annotationClass;
    }

    public void setAnnotationClass(String value) {
        this.annotationClass = value;
    }

    @Override
    protected final void resolveThis() {
        Api api = this.findAncestor(Api.class);
        assert (api != null);
        this.isGetError_ = this.equals(api.getApiInfo().getErrorFunction());
        List<ArgumentSpec> args = this.getArg();
        int i = 0;
        while (i < args.size()) {
            ArgumentSpec argSpec = args.get(i);
            this.argumentNameMap.put(argSpec.getName(), argSpec);
            this.argumentIndexMap.put(argSpec, i);
            ++i;
        }
        for (FunctionAliasSpec a : this.getAliases()) {
            this.aliasNameMap.put(a.getName(), a);
        }
        if ("true".equals(this.getFrameEndWhen())) {
            this.isAlwaysFrameEnd = true;
        }
    }

    @Override
    public final boolean isDrawCall() {
        return this.drawCallInfo != null;
    }

    @Override
    public final boolean isPlatformSpecific() {
        return this.getVersionInfo().getPlatformSpecific().size() > 0;
    }

    @Override
    public final boolean isClEnqueueCall() {
        return this.clEnqueueCallInfo != null;
    }

    @Override
    public final boolean isInterestingCall() {
        return this.interestingCall != null || this.isDrawCall() || this.isClEnqueueCall();
    }

    @Override
    public final boolean isGetError() {
        return this.isGetError_;
    }

    @Override
    public final boolean hasFunctionVariableErrorCode() {
        return this.functionVariableErrorCode != null;
    }

    @Override
    public boolean isAlwaysFrameEnd() {
        return this.isAlwaysFrameEnd;
    }

    @Override
    public final boolean isVulkanCommand() {
        return this.vulkanCommand != null;
    }

    @Override
    public final boolean isVulkanDrawCommand() {
        return this.vulkanCommand != null && this.vulkanCommand.isDrawCommand();
    }

    @Override
    public final int getArgIndex(ArgumentSpec arg) {
        Integer result = this.argumentIndexMap.get(arg);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("arg is not a child of this function");
    }

    @Override
    public final ArgumentSpec getArgumentSpecByName(String name) {
        assert (name != null && !name.isEmpty());
        return this.argumentNameMap.get(name);
    }

    public final FunctionAliasSpec getAliasByName(String name) {
        return this.aliasNameMap.get(name);
    }

    @Override
    public FunctionSpec getAsFunctionSpec() {
        return (FunctionSpec)this;
    }

    @Override
    public boolean hasAliases() {
        return !this.getAliases().isEmpty();
    }

    @Override
    public boolean isAlias() {
        return false;
    }

    @Override
    public boolean isUnrecognisedFunction() {
        return false;
    }

    @SuppressFBWarnings(justification="Identity comparison allowed", value={"RC_REF_COMPARISON"})
    public final @SuppressFBWarnings(justification="Identity comparison allowed", value={"RC_REF_COMPARISON"}) boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof IFunctionOrAliasSpec) {
            return this == ((IFunctionOrAliasSpec)obj).getAsFunctionSpec();
        }
        return false;
    }

    @Override
    public final String getHighestApiVersionSupportedIn() {
        return VersionsSpec.getHighestApiVersionSupportedIn(this, this.getVersionInfo());
    }

    @Override
    public final boolean isExtension() {
        return VersionsSpec.isExtension(this, this.getVersionInfo());
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }
}

