/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.gen;

import com.arm.mgd.kapi.ApiBase;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.UsageSpec;
import com.arm.mgd.kapi.gen.BasicTypeContainerSpec;
import com.arm.mgd.kapi.gen.BasicTypeContainerTypeSpec;
import com.arm.mgd.kapi.gen.BasicTypeRefSpec;
import com.arm.mgd.kapi.gen.DisplayEnum;
import com.arm.mgd.kapi.gen.ElementTypeSpec;
import com.arm.mgd.kapi.gen.FormatSpec;
import com.arm.mgd.kapi.gen.FunctionSpecNoName;
import com.arm.mgd.kapi.gen.MappableTypeRefSpec;
import com.arm.mgd.kapi.gen.VersionsSpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="XBasicTypeSpec", propOrder={"ctype", "jtype", "usage", "format", "container", "function", "mappableType", "versionInfo"})
public class XBasicTypeSpec
extends ApiBase
implements Comparable<XBasicTypeSpec> {
    protected String ctype;
    @XmlSchemaType(name="string")
    protected ElementTypeSpec jtype;
    protected UsageSpec usage;
    protected FormatSpec format;
    protected BasicTypeContainerSpec container;
    protected FunctionSpecNoName function;
    protected MappableTypeRefSpec mappableType;
    protected VersionsSpec versionInfo;
    @XmlAttribute(name="id", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    protected String id;
    @XmlAttribute(name="byteSize")
    @XmlSchemaType(name="unsignedShort")
    protected Integer byteSize;
    @XmlAttribute(name="display")
    protected DisplayEnum display;
    @XmlTransient
    protected final Map<String, ArgumentSpec> argumentNameMap = new HashMap<String, ArgumentSpec>();

    public String getCtype() {
        return this.ctype;
    }

    public void setCtype(String value) {
        this.ctype = value;
    }

    public ElementTypeSpec getJtype() {
        return this.jtype;
    }

    public void setJtype(ElementTypeSpec value) {
        this.jtype = value;
    }

    public UsageSpec getUsage() {
        return this.usage;
    }

    public void setUsage(UsageSpec value) {
        this.usage = value;
    }

    public FormatSpec getFormat() {
        return this.format;
    }

    public void setFormat(FormatSpec value) {
        this.format = value;
    }

    public BasicTypeContainerSpec getContainer() {
        return this.container;
    }

    public void setContainer(BasicTypeContainerSpec value) {
        this.container = value;
    }

    public FunctionSpecNoName getFunction() {
        return this.function;
    }

    public void setFunction(FunctionSpecNoName value) {
        this.function = value;
    }

    public MappableTypeRefSpec getMappableType() {
        return this.mappableType;
    }

    public void setMappableType(MappableTypeRefSpec value) {
        this.mappableType = value;
    }

    public VersionsSpec getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(VersionsSpec value) {
        this.versionInfo = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Integer getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(Integer value) {
        this.byteSize = value;
    }

    public DisplayEnum getDisplay() {
        if (this.display == null) {
            return DisplayEnum.DEFAULT;
        }
        return this.display;
    }

    public void setDisplay(DisplayEnum value) {
        this.display = value;
    }

    @Override
    protected final void resolveThis() {
        BasicTypeContainerSpec container = this.getContainer();
        if (container != null) {
            List<ArgumentSpec> members = container.getMember();
            int i = 0;
            while (i < members.size()) {
                ArgumentSpec argSpec = members.get(i);
                this.argumentNameMap.put(argSpec.getName(), argSpec);
                ++i;
            }
        }
    }

    public final ArgumentSpec getArgumentSpecByName(String name) {
        assert (name != null && !name.isEmpty());
        return this.argumentNameMap.get(name);
    }

    public final boolean isVoid() {
        return "void".equals(this.getCtype()) || "GLvoid".equals(this.getCtype());
    }

    @Override
    public final int compareTo(XBasicTypeSpec o) {
        return this.ctype.compareTo(o.ctype);
    }

    public final String formatCtypeWithName(String name) {
        name = name != null ? name : "";
        return String.format("%s%s%s", this.getCtype(), name.isEmpty() ? "" : " ", name);
    }

    protected final ElementTypeSpec processJType() {
        if (this.jtype != null) {
            return this.jtype;
        }
        BasicTypeContainerSpec containerSpec = this.getContainer();
        if (containerSpec != null) {
            return containerSpec.getType() == BasicTypeContainerTypeSpec.STRUCT ? ElementTypeSpec.STRUCT : ElementTypeSpec.UNION;
        }
        assert (false) : "No able to get jtype for " + this.getId();
        return null;
    }

    public final boolean isStruct() {
        return this.getJtype() == ElementTypeSpec.STRUCT;
    }

    public final boolean isUnion() {
        return this.getJtype() == ElementTypeSpec.UNION;
    }

    public final boolean isString() {
        return this.getJtype() == ElementTypeSpec.STRING;
    }

    public final boolean isHandle() {
        return this.getJtype() == ElementTypeSpec.HANDLE;
    }

    public final boolean isPointingToHandle() {
        FormatSpec format = this.getFormat();
        if (format == null || format.getScalar() == null) {
            return false;
        }
        BasicTypeRefSpec basicTypeRef = format.getScalar().getBasicTypeRef();
        if (basicTypeRef == null) {
            return false;
        }
        return basicTypeRef.getValue().isHandle();
    }
}

