/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.gen;

import com.arm.mgd.kapi.AbstractFunctionVariableSpec;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.BasicTypeSpec;
import com.arm.mgd.kapi.extended.FunctionSpec;
import com.arm.mgd.kapi.extended.UsageSpec;
import com.arm.mgd.kapi.gen.AccessSpec;
import com.arm.mgd.kapi.gen.BasicTypeContainerSpec;
import com.arm.mgd.kapi.gen.BasicTypeRefSpec;
import com.arm.mgd.kapi.gen.BasicTypesSpec;
import com.arm.mgd.kapi.gen.FormatSpec;
import com.arm.mgd.kapi.gen.MappableTypeRefSpec;
import com.arm.mgd.kapi.gen.ScalarSpec;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="XArgumentSpec", propOrder={"name", "basicTypeRef", "rawFormat", "rawUsage", "access", "mappableType", "rawDependsOn"})
public class XArgumentSpec
extends AbstractFunctionVariableSpec {
    @XmlElement(required=true)
    protected String name;
    @XmlElement(name="basicType", required=true)
    protected BasicTypeRefSpec basicTypeRef;
    @XmlElement(name="format")
    protected FormatSpec rawFormat;
    @XmlElement(name="usage")
    protected UsageSpec rawUsage;
    @XmlElement(defaultValue="in")
    @XmlSchemaType(name="string")
    protected AccessSpec access;
    protected MappableTypeRefSpec mappableType;
    @XmlElement(name="dependsOn")
    protected String rawDependsOn;
    @XmlTransient
    protected int argIndex_;
    @XmlTransient
    protected FunctionSpec parentFunction_;
    @XmlTransient
    protected ArgumentSpec dependsOn;

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public BasicTypeRefSpec getBasicTypeRef() {
        return this.basicTypeRef;
    }

    public void setBasicTypeRef(BasicTypeRefSpec value) {
        this.basicTypeRef = value;
    }

    public FormatSpec getRawFormat() {
        return this.rawFormat;
    }

    public void setRawFormat(FormatSpec value) {
        this.rawFormat = value;
    }

    public UsageSpec getRawUsage() {
        return this.rawUsage;
    }

    public void setRawUsage(UsageSpec value) {
        this.rawUsage = value;
    }

    public AccessSpec getAccess() {
        return this.access;
    }

    public void setAccess(AccessSpec value) {
        this.access = value;
    }

    public MappableTypeRefSpec getMappableType() {
        return this.mappableType;
    }

    public void setMappableType(MappableTypeRefSpec value) {
        this.mappableType = value;
    }

    public String getRawDependsOn() {
        return this.rawDependsOn;
    }

    public void setRawDependsOn(String value) {
        this.rawDependsOn = value;
    }

    @Override
    protected final void resolveThis() {
        BasicTypeContainerSpec parentContainer_ = this.findAncestor(BasicTypeContainerSpec.class);
        if (parentContainer_ != null) {
            this.argIndex_ = parentContainer_.getMember().indexOf(this);
            if (this.rawDependsOn != null) {
                this.dependsOn = this.findSibling(this.rawDependsOn, parentContainer_.getMember());
            }
        } else {
            this.parentFunction_ = this.findAncestor(FunctionSpec.class);
            int n = this.argIndex_ = this.parentFunction_ != null ? this.parentFunction_.getArg().indexOf(this) : -1;
            if (this.rawDependsOn != null) {
                this.dependsOn = this.findSibling(this.rawDependsOn, this.parentFunction_.getArg());
            }
        }
    }

    private ArgumentSpec findSibling(String siblingName, List<ArgumentSpec> siblings) {
        for (ArgumentSpec sibling : siblings) {
            if (!sibling.name.equals(siblingName)) continue;
            return sibling;
        }
        assert (this.dependsOn != null) : "Cannot find dependent argument/member " + siblingName + "for argument " + this.name;
        return null;
    }

    public FunctionSpec getParentFunctionSpec() {
        return this.parentFunction_;
    }

    public final int getArgIndex() {
        return this.argIndex_;
    }

    public final boolean isAccessOut() {
        return this.access == AccessSpec.OUT;
    }

    public final boolean isAccessIn() {
        return this.access == AccessSpec.IN;
    }

    public final boolean isAccessInOut() {
        return this.access == AccessSpec.IN_OUT;
    }

    public final boolean isAccessExternal() {
        return this.access == AccessSpec.EXTERNAL;
    }

    @Override
    public final BasicTypeSpec getBasicType() {
        if (this.basicTypeRef == null) {
            return null;
        }
        if (this.basicTypeRef.getValue().getFunction() != null) {
            return BasicTypesSpec.POINTER;
        }
        return this.basicTypeRef.getValue();
    }

    public boolean isContainer() {
        BasicTypeRefSpec scalarBasicTypeRef;
        ScalarSpec scalarSpec;
        if (this.getFormat() != null && (scalarSpec = this.getFormat().getScalar()) != null && (scalarBasicTypeRef = scalarSpec.getBasicTypeRef()) != null && scalarBasicTypeRef.getValue().getContainer() != null) {
            return true;
        }
        return this.basicTypeRef != null && this.basicTypeRef.getValue().getContainer() != null;
    }

    public boolean isEGLAttributeArray() {
        if (this.getUsage() != null && this.getUsage().getEglAttributeList() != null) {
            assert (this.getFormat().getArray() != null) : "EGL attribute type not sent as an array for argument: " + this.getName();
            return true;
        }
        return false;
    }

    public FormatSpec getFormat() {
        if (this.rawFormat != null) {
            return this.rawFormat;
        }
        if (this.basicTypeRef != null) {
            return this.basicTypeRef.getValue().getFormat();
        }
        return null;
    }

    @Override
    public UsageSpec getUsage() {
        if (this.rawUsage != null) {
            return this.rawUsage;
        }
        if (this.basicTypeRef != null) {
            return this.basicTypeRef.getValue().getUsage();
        }
        return null;
    }

    public ArgumentSpec getDependsOn() {
        return this.dependsOn;
    }
}

