/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.gen;

import com.arm.mgd.kapi.ApiBase;
import com.arm.mgd.kapi.gen.Api;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="VersionsSpec", propOrder={"deprecated", "extension", "platformSpecific"})
public class VersionsSpec
extends ApiBase {
    protected List<String> deprecated;
    protected List<String> extension;
    protected List<String> platformSpecific;
    @XmlAttribute(name="min")
    protected Float min;
    @XmlAttribute(name="max")
    protected Float max;

    public List<String> getDeprecated() {
        if (this.deprecated == null) {
            this.deprecated = new ArrayList<String>();
        }
        return this.deprecated;
    }

    public List<String> getExtension() {
        if (this.extension == null) {
            this.extension = new ArrayList<String>();
        }
        return this.extension;
    }

    public List<String> getPlatformSpecific() {
        if (this.platformSpecific == null) {
            this.platformSpecific = new ArrayList<String>();
        }
        return this.platformSpecific;
    }

    public Float getMin() {
        return this.min;
    }

    public void setMin(Float value) {
        this.min = value;
    }

    public Float getMax() {
        return this.max;
    }

    public void setMax(Float value) {
        this.max = value;
    }

    public static final String getHighestApiVersionSupportedIn(ApiBase element, VersionsSpec versionSpec) {
        Api api = element.findAncestor(Api.class);
        assert (api != null);
        String highestApiVersion = api.getApiInfo().getVersion();
        if (versionSpec == null) {
            return highestApiVersion;
        }
        Float minimumVersion = versionSpec.getMin();
        Float maximumVersion = versionSpec.getMax();
        if (minimumVersion == null) {
            assert (maximumVersion == null) : "Version max must not be set";
            return highestApiVersion;
        }
        assert (maximumVersion == null || maximumVersion.compareTo(minimumVersion) >= 0) : "Max must be >= min";
        if (maximumVersion != null) {
            return String.valueOf(maximumVersion);
        }
        return highestApiVersion;
    }

    public static final boolean isExtension(ApiBase element, VersionsSpec versionSpec) {
        if (versionSpec == null) {
            return false;
        }
        return versionSpec.getMin() == null && versionSpec.getMax() == null && !versionSpec.getExtension().isEmpty();
    }

    public boolean equals(Object o) {
        if (o instanceof VersionsSpec) {
            VersionsSpec that = (VersionsSpec)o;
            return VersionsSpec.eq(this.min, that.min) && VersionsSpec.eq(this.max, that.max) && this.getExtension().equals(that.getExtension()) && this.getDeprecated().equals(that.getDeprecated());
        }
        return false;
    }

    public int hashCode() {
        return (this.min != null ? this.min.hashCode() : 0) ^ (this.max != null ? this.max.hashCode() : 0) ^ this.getExtension().hashCode();
    }

    private static <T> boolean eq(T a, T b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }
}

