/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.gen;

import com.arm.mgd.kapi.ApiBase;
import com.arm.mgd.kapi.IFunctionOrAliasSpec;
import com.arm.mgd.kapi.extended.FunctionAliasSpec;
import com.arm.mgd.kapi.extended.FunctionSpec;
import com.arm.mgd.kapi.gen.Api;
import com.arm.mgd.kapi.gen.ApiName;
import com.arm.mgd.kapi.gen.XFunctionAliasSpec;
import com.arm.mgd.kapi.gen.XFunctionSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="FunctionsSpec", propOrder={"functions"})
public class FunctionsSpec
extends ApiBase {
    @XmlElement(name="function", required=true)
    protected List<FunctionSpec> functions;
    @XmlTransient
    private Collection<IFunctionOrAliasSpec> functionsAndAliases = null;

    public List<FunctionSpec> getFunctions() {
        if (this.functions == null) {
            this.functions = new ArrayList<FunctionSpec>();
        }
        return this.functions;
    }

    @Override
    protected final void resolveThis() {
        Api api = this.findAncestor(Api.class);
        assert (api != null);
        if (!api.getApiInfo().getName().equals((Object)ApiName.CL)) {
            this.functionsAndAliases = new TreeSet<IFunctionOrAliasSpec>(new FunctionAliasComparator());
            for (FunctionSpec fs : this.getFunctions()) {
                this.functionsAndAliases.add(fs);
                for (FunctionAliasSpec fa : fs.getAliases()) {
                    this.functionsAndAliases.add(fa);
                }
            }
        } else {
            this.functionsAndAliases = new ArrayList<IFunctionOrAliasSpec>();
            for (FunctionSpec fs : this.getFunctions()) {
                this.functionsAndAliases.add(fs);
                assert (fs.getAliases().isEmpty()) : "CL should not have any aliases";
            }
        }
    }

    public Collection<IFunctionOrAliasSpec> getFunctionsAndAliases() {
        return Collections.unmodifiableCollection(this.functionsAndAliases);
    }

    public static class FunctionAliasComparator
    implements Comparator<IFunctionOrAliasSpec> {
        @Override
        public int compare(IFunctionOrAliasSpec o1, IFunctionOrAliasSpec o2) {
            assert (o1 != null);
            assert (o2 != null);
            if (o1 instanceof XFunctionSpec && o2 instanceof XFunctionAliasSpec) {
                return this.compareFunctionWithAlias((XFunctionSpec)o1, (XFunctionAliasSpec)o2);
            }
            if (o1 instanceof XFunctionAliasSpec && o2 instanceof XFunctionSpec) {
                return -this.compareFunctionWithAlias((XFunctionSpec)o2, (XFunctionAliasSpec)o1);
            }
            return o1.getName().compareTo(o2.getName());
        }

        private int compareFunctionWithAlias(XFunctionSpec f, XFunctionAliasSpec a) {
            FunctionSpec af = a.getAsFunctionSpec();
            assert (af != null);
            if (af.equals(f)) {
                return -1;
            }
            return f.getName().compareTo(af.getName());
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

