/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.gen;

import com.arm.mgd.kapi.ApiBase;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.ConstantAliasSpec;
import com.arm.mgd.kapi.extended.ConstantSpec;
import com.arm.mgd.kapi.gen.Api;
import com.arm.mgd.kapi.gen.ApiName;
import com.arm.mgd.kapi.gen.XConstantAliasSpec;
import com.arm.mgd.kapi.gen.XConstantSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ConstantsSpec", propOrder={"constants"})
public class ConstantsSpec
extends ApiBase {
    @XmlElement(name="constant")
    protected List<ConstantSpec> constants;
    @XmlTransient
    private Collection<AbstractConstantOrAliasSpecExtended> constantsAndAliases = null;

    public List<ConstantSpec> getConstants() {
        if (this.constants == null) {
            this.constants = new ArrayList<ConstantSpec>();
        }
        return this.constants;
    }

    @Override
    protected final void resolveThis() {
        Api api = this.findAncestor(Api.class);
        assert (api != null);
        if (!api.getApiInfo().getName().equals((Object)ApiName.CL)) {
            this.constantsAndAliases = new TreeSet<AbstractConstantOrAliasSpecExtended>(new ConstantAliasComparator());
            for (ConstantSpec fs : this.getConstants()) {
                this.constantsAndAliases.add(fs);
                for (ConstantAliasSpec fa : fs.getAliases()) {
                    this.constantsAndAliases.add(fa);
                }
            }
        } else {
            this.constantsAndAliases = new ArrayList<AbstractConstantOrAliasSpecExtended>();
            for (ConstantSpec fs : this.getConstants()) {
                this.constantsAndAliases.add(fs);
                assert (fs.getAliases().isEmpty()) : "CL should not have any aliases";
            }
        }
    }

    public Collection<AbstractConstantOrAliasSpecExtended> getConstantsAndAliases() {
        return Collections.unmodifiableCollection(this.constantsAndAliases);
    }

    private static class ConstantAliasComparator
    implements Comparator<AbstractConstantOrAliasSpecExtended> {
        private ConstantAliasComparator() {
        }

        @Override
        public int compare(AbstractConstantOrAliasSpecExtended o1, AbstractConstantOrAliasSpecExtended o2) {
            assert (o1 != null);
            assert (o2 != null);
            assert (o1.getName() != null);
            assert (o2.getName() != null);
            if (o1 instanceof XConstantSpec && o2 instanceof XConstantAliasSpec) {
                return this.compareConstantWithAlias((XConstantSpec)o1, (XConstantAliasSpec)o2);
            }
            if (o1 instanceof XConstantAliasSpec && o2 instanceof XConstantSpec) {
                return -this.compareConstantWithAlias((XConstantSpec)o2, (XConstantAliasSpec)o1);
            }
            return o1.getName().compareTo(o2.getName());
        }

        private int compareConstantWithAlias(XConstantSpec c, XConstantAliasSpec a) {
            ConstantSpec ac = a.getAsConstantSpec();
            assert (ac != null);
            if (ac.equals(c)) {
                return -1;
            }
            return c.getName().compareTo(ac.getName());
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

