/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.extended;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.state.StateId;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.state.StateValue;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.gen.ReadStateFromSpec;
import com.arm.mgd.kapi.gen.StateTypeSpec;
import com.arm.mgd.kapi.gen.StateVariableTypeSpec;
import com.arm.mgd.kapi.gen.XReadStateSpec;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import org.eclipse.jdt.annotation.Nullable;

public class ReadStateSpec
extends XReadStateSpec {
    public @Nullable StateId getStateId(FunctionCall fc) {
        IFunctionOrAliasSpecExtended functionSpec = fc.getFunctionSpec();
        if (this.key.getState() == null) {
            String argId = this.key.getArgId();
            assert (argId != null);
            ArgumentSpec argumentSpec = functionSpec.getArgumentSpecByName(argId);
            Serializable argument = fc.getArgValue(argumentSpec.getArgIndex());
            if (argument instanceof AbstractConstantOrAliasSpecExtended) {
                AbstractConstantOrAliasSpecExtended constant = (AbstractConstantOrAliasSpecExtended)argument;
                StateSpec stateSpec = functionSpec.getKapiSpec().getStateSpecByName(new StateId(constant, false));
                if (stateSpec != null) {
                    return new StateId(stateSpec);
                }
            }
            CoreLogging.warning(null, "Could not locate state spec for " + fc + "@" + fc.getIndex() + " (" + argument + ")");
            return null;
        }
        return new StateId((StateSpec)NullUtils.neverNull((Object)this.key.getState()));
    }

    public StateValue[] getStateValueFromGetterFunction(FunctionCall fc, StateItem stateItem) {
        assert (stateItem != null);
        assert (fc != null);
        StateValue[] values = null;
        Object candidateNewStateValue = ReadStateSpec.getCandidateNewStateValue(fc);
        StateTypeSpec stateType = stateItem.getStateSpec().getStateType();
        if (stateType == null) {
            return null;
        }
        StateVariableTypeSpec stateVariableTypeSpec = stateType.getStateVariableType();
        switch (stateVariableTypeSpec) {
            case B: {
                values = ReadStateSpec.convertValueToBoolean(candidateNewStateValue);
                break;
            }
            case Z: {
                values = ReadStateSpec.convertValueToInteger(candidateNewStateValue);
                break;
            }
            case Zplus: {
                values = ReadStateSpec.convertValueToNonNegativeInteger(candidateNewStateValue);
                break;
            }
            case E: {
                values = ReadStateSpec.convertValueToEnumeration(fc, candidateNewStateValue);
                break;
            }
            case R: 
            case Rplus: {
                values = ReadStateSpec.convertValueToFloatingPoint(candidateNewStateValue);
                break;
            }
            default: {
                assert (false) : "Unable to process StateVariableTypeSpec." + (Object)((Object)stateType.getStateVariableType());
                break;
            }
        }
        return values;
    }

    private static StateValue[] convertValueToNonNegativeInteger(Object candidateNewStateValue) {
        StateValue[] values = null;
        if (candidateNewStateValue instanceof LongsArgAttachment) {
            LongsArgAttachment longs = (LongsArgAttachment)candidateNewStateValue;
            values = new StateValue[longs.size()];
            int i = 0;
            while (i < longs.size()) {
                Long unsignedValue = 0xFFFFFFFFL & longs.getLong(i);
                values[i] = new StateValue(unsignedValue);
                ++i;
            }
        }
        return values;
    }

    private static StateValue[] convertValueToEnumeration(FunctionCall fc, Object candidateNewStateValue) {
        StateValue[] values = null;
        if (candidateNewStateValue instanceof LongsArgAttachment) {
            LongsArgAttachment longs = (LongsArgAttachment)candidateNewStateValue;
            values = new StateValue[longs.size()];
            int i = 0;
            while (i < longs.size()) {
                AbstractConstantOrAliasSpecExtended constantValue = fc.getFunctionSpec().getKapiSpec().getConstantSpecByValue(longs.get(i));
                values[i] = new StateValue(constantValue);
                ++i;
            }
        }
        return values;
    }

    private static StateValue[] convertValueToFloatingPoint(Object candidateNewStateValue) {
        StateValue[] values = null;
        if (candidateNewStateValue instanceof FloatsArgAttachment) {
            FloatsArgAttachment floats = (FloatsArgAttachment)candidateNewStateValue;
            values = new StateValue[floats.size()];
            int i = 0;
            while (i < floats.size()) {
                values[i] = new StateValue(floats.get(i));
                ++i;
            }
        }
        return values;
    }

    private static StateValue[] convertValueToInteger(Object candidateNewStateValue) {
        StateValue[] values = null;
        if (candidateNewStateValue instanceof LongsArgAttachment) {
            LongsArgAttachment longs = (LongsArgAttachment)candidateNewStateValue;
            values = new StateValue[longs.size()];
            int i = 0;
            while (i < longs.size()) {
                values[i] = new StateValue(longs.get(i));
                ++i;
            }
        }
        return values;
    }

    private static StateValue[] convertValueToBoolean(Object candidateNewStateValue) {
        StateValue[] values = null;
        if (candidateNewStateValue instanceof AbstractConstantOrAliasSpecExtended) {
            values = new StateValue[]{new StateValue(candidateNewStateValue)};
        }
        return values;
    }

    private static Object getCandidateNewStateValue(FunctionCall fc) {
        Serializable o = null;
        ReadStateFromSpec fromItem = fc.getFunctionSpec().getReadState().getFrom();
        if (fromItem.getReturnValue() != null) {
            o = fc.getReturnValue();
        } else if (fromItem.getArgument() != null) {
            IFunctionOrAliasSpecExtended functionSpec = fc.getFunctionSpec();
            String argument = fromItem.getArgument();
            assert (argument != null);
            ArgumentSpec argumentSpec = functionSpec.getArgumentSpecByName(argument);
            o = fc.getArgValue(argumentSpec.getArgIndex());
        }
        assert (o != null);
        return o;
    }
}

