/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.extended;

import com.arm.mgd.core.asset.AssetProcessor;
import com.arm.mgd.core.asset.processors.AbortActionException;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.processors.GeneratedAssetProcessor;
import com.arm.mgd.core.asset.processors.MissingAssetException;
import com.arm.mgd.core.counters.CountersProcessor;
import com.arm.mgd.core.kapi.DuplicateSpecItemException;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.kapi.UnresolvedSpecItemException;
import com.arm.mgd.kapi.extended.AffectsStateSpec;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.ReturnTypeSpec;
import com.arm.mgd.kapi.extended.UsageSpec;
import com.arm.mgd.kapi.gen.XFunctionSpec;
import com.arm.mgd.utils.NullUtils;
import java.lang.reflect.Method;
import org.eclipse.jdt.annotation.NonNull;

public class FunctionSpec
extends XFunctionSpec
implements IFunctionOrAliasSpecExtended {
    private transient KapiSpec kapiSpec;
    private transient AssetProcessorBase generatedAssetProcessor;
    private transient Method assetProcessorMethod;
    private transient Method counterProcessorMethod;
    private final boolean unrecognisedFunction;

    public FunctionSpec() {
        this(false);
    }

    FunctionSpec(boolean unrecognisedFunction) {
        this.unrecognisedFunction = unrecognisedFunction;
    }

    public void resolve(KapiSpec spec) throws UnresolvedSpecItemException, DuplicateSpecItemException {
        this.kapiSpec = spec;
        for (ArgumentSpec a : this.getArg()) {
            a.resolve(this);
        }
        this.getReturnType().resolve(spec, this);
        UsageSpec usage = this.getReturnType().getUsage();
        if (usage != null) {
            usage.resolve(spec);
        }
        if (this.drawCallInfo != null) {
            this.drawCallInfo.resolve(this, this.argumentNameMap);
        }
        if (this.clEnqueueCallInfo != null) {
            this.clEnqueueCallInfo.resolve(this, this.argumentNameMap);
        }
        for (AffectsStateSpec affectStateItem : this.getAffectsState()) {
            affectStateItem.resolve(this);
        }
        this.generatedAssetProcessor = GeneratedAssetProcessor.get((String)NullUtils.neverNull((Object)this.name));
        try {
            this.assetProcessorMethod = AssetProcessor.INSTANCE.getMethodForFunctionCall((String)NullUtils.neverNull((Object)this.name));
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new UnresolvedSpecItemException("Processor method for " + this + "is not valid.");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            this.counterProcessorMethod = CountersProcessor.INSTANCE.getMethodForFunctionCall((String)NullUtils.neverNull((Object)this.name));
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new UnresolvedSpecItemException("Processor method for " + this + "is not valid.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public KapiSpec getKapiSpec() {
        return this.kapiSpec;
    }

    public String toString() {
        return "Function: " + this.getName();
    }

    public static @NonNull FunctionSpec createDefault(String name) {
        FunctionSpec spec = new FunctionSpec(true);
        spec.setName(name);
        spec.setReturnType(new ReturnTypeSpec());
        return spec;
    }

    private static void reportMissingAsset(@NonNull TraceStateSnapshot traceStateSnapshot, @NonNull MissingAssetException e) {
        FunctionCall fc = e.functionCall;
        TraceAnalysisLogger.warning(traceStateSnapshot, fc, (String)NullUtils.neverNull((Object)String.format("Required asset object of type %s not found", e.traits.SPEC.getSingularName())));
    }

    @Override
    public void processAssets(TraceStateSnapshot traceStateSnapshot, FunctionCall fc) {
        if (!fc.hasError()) {
            if (this.generatedAssetProcessor != null) {
                try {
                    this.generatedAssetProcessor.execute(traceStateSnapshot, fc);
                }
                catch (MissingAssetException e) {
                    assert (e.functionCall == fc);
                    FunctionSpec.reportMissingAsset(traceStateSnapshot, e);
                }
                catch (AbortActionException e) {
                    TraceAnalysisLogger.warning(traceStateSnapshot, fc, e.getMessage());
                }
                catch (Exception e) {
                    TraceAnalysisLogger.warning(traceStateSnapshot, fc, "Unable to process function call.");
                    e.printStackTrace();
                }
            }
            if (this.assetProcessorMethod != null) {
                try {
                    this.assetProcessorMethod.invoke(null, traceStateSnapshot, fc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TraceAnalysisLogger.warning(traceStateSnapshot, fc, "Unable to process function call.");
                }
            }
            if (fc.getFunctionSpec().isVulkanCommand()) {
                try {
                    AssetProcessorBase.recordVkCommand(traceStateSnapshot, fc);
                }
                catch (MissingAssetException e) {
                    assert (e.functionCall == fc);
                    FunctionSpec.reportMissingAsset(traceStateSnapshot, e);
                }
                catch (Exception e) {
                    TraceAnalysisLogger.warning(traceStateSnapshot, fc, "Unable to record the Vulkan function call.");
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void processCounters(TraceStateSnapshot traceStateSnapshot, FunctionCall fc) {
        if (this.counterProcessorMethod != null && !fc.hasError()) {
            try {
                this.counterProcessorMethod.invoke(null, fc, traceStateSnapshot.getModel().getCounters());
            }
            catch (Exception e) {
                CoreLogging.severe(traceStateSnapshot.getModel(), e, "Unable to invoke method for " + fc);
            }
        }
        if (fc.isFrameEnd()) {
            long memory = traceStateSnapshot.getMemoryReportModel().getTotalAllocatedMemory();
            traceStateSnapshot.getModel().getCounters().totalMemoryAllocated += memory;
            traceStateSnapshot.getModel().getFrames().getLatestFrame().setTotalMemoryAllocation(memory);
        }
    }

    @Override
    public boolean isBufferCall() {
        return this.equals(KapiSpec.GLES.functions.GLBUFFERDATA) || this.equals(KapiSpec.GLES.functions.GLBUFFERSUBDATA);
    }

    @Override
    public boolean isTextureCall() {
        return this.equals(KapiSpec.GLES.functions.GLTEXIMAGE2D) || this.equals(KapiSpec.GLES.functions.GLTEXSUBIMAGE2D);
    }

    @Override
    public boolean isCompressedTextureCall() {
        return this.equals(KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE2D) || this.equals(KapiSpec.GLES.functions.GLCOMPRESSEDTEXSUBIMAGE2D);
    }

    @Override
    public boolean hasAssetProcessorMethod() {
        return this.assetProcessorMethod != null || this.generatedAssetProcessor != null;
    }

    @Override
    public boolean isUnrecognisedFunction() {
        return this.unrecognisedFunction;
    }
}

