/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.extended;

import com.arm.mgd.core.kapi.DuplicateSpecItemException;
import com.arm.mgd.core.kapi.IConstantOrAliasSpecContainer;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AnonymousConstantSpec;
import com.arm.mgd.kapi.gen.ConstantGroupRef;
import com.arm.mgd.kapi.gen.ConstantRef;
import com.arm.mgd.kapi.gen.XEnumerationSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class EnumerationSpec
extends XEnumerationSpec
implements IConstantOrAliasSpecContainer {
    private final Map<Long, AbstractConstantOrAliasSpecExtended> validConstants = new HashMap<Long, AbstractConstantOrAliasSpecExtended>();
    private KapiSpec kapiSpec;

    protected void resolve(KapiSpec requiredKapiSpec) throws DuplicateSpecItemException {
        this.kapiSpec = requiredKapiSpec;
        for (ConstantRef constantSpecRef : this.getConstant()) {
            assert (constantSpecRef != null);
            assert (constantSpecRef.getRef() != null);
            this.addConstantSpec(constantSpecRef.getRef());
        }
        for (ConstantGroupRef constantGroupRef : this.getConstantGroup()) {
            assert (constantGroupRef != null);
            assert (constantGroupRef.getRef() != null);
            this.validConstants.putAll(constantGroupRef.getRef().getConstantMap());
        }
    }

    private void addConstantSpec(AbstractConstantOrAliasSpecExtended constantSpec) throws DuplicateSpecItemException {
        AbstractConstantOrAliasSpecExtended prev = this.validConstants.put(constantSpec.getResolvedValue(), constantSpec);
        if (prev != null) {
            throw new DuplicateSpecItemException(constantSpec.toString());
        }
    }

    public Iterable<AbstractConstantOrAliasSpecExtended> getValidConstants() {
        return this.validConstants.values();
    }

    @Override
    public @NonNull AbstractConstantOrAliasSpecExtended getConstantSpecByValue(@NonNull Long value) {
        AbstractConstantOrAliasSpecExtended c = this.validConstants.get(value);
        if (c != null) {
            return c;
        }
        if (this.kapiSpec != null) {
            return this.kapiSpec.getConstantSpecByValue(value);
        }
        return AnonymousConstantSpec.newConstant(value);
    }

    public @NonNull Bitfield getBitfieldByValue(@NonNull Long bitmaskValue) {
        Bitfield listOfConstants = new Bitfield();
        assert (this.isBitfield());
        long matchedMask = 0L;
        long valueAsPrimitiveLong = bitmaskValue;
        for (AbstractConstantOrAliasSpecExtended c : this.getValidConstants()) {
            long resolvedValue = c.getResolvedValue();
            if ((valueAsPrimitiveLong & resolvedValue) != resolvedValue) continue;
            matchedMask |= resolvedValue;
            listOfConstants.add(c);
        }
        if (matchedMask != valueAsPrimitiveLong) {
            listOfConstants.add(AnonymousConstantSpec.newConstant(NullUtils.longValueOf((long)valueAsPrimitiveLong)));
        }
        return listOfConstants;
    }
}

