/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.extended;

import com.arm.mgd.core.kapi.DuplicateSpecItemException;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.kapi.UnresolvedSpecItemException;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.gen.XConstantSpec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="See SerializableDependency}")
public class ConstantSpec
extends XConstantSpec {
    private static final long serialVersionUID = -8185150327986151516L;
    private static final Pattern identPattern = Pattern.compile("^[A-Za-z_][A-Za-z0-9_]*$");
    private static final Pattern shiftPattern = Pattern.compile("^\\(1\\s*<<\\s*(\\d+)\\)$");
    private static final Pattern intMaxMinusPattern = Pattern.compile("^\\(~0U-(\\d+)\\)$");
    private static final Pattern longLongMaxMinusPattern = Pattern.compile("^\\(~0ULL-(\\d+)\\)$");
    protected Long resolvedValue;

    @Override
    public @NonNull Long getResolvedValue() {
        if (this.resolvedValue != null) {
            return this.resolvedValue;
        }
        throw new IllegalStateException("Constant " + this.getName() + " has not been resolved");
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public void resolveConstantRefs(KapiSpec spec) throws DuplicateSpecItemException {
        if (this.eglAttributeValues != null) {
            this.eglAttributeValues.resolve(spec);
        }
    }

    @Override
    public void resolve(KapiSpec spec, KapiSpec.ResolvedMaps resolvedMaps) throws UnresolvedSpecItemException {
        assert (this.resolvedValue == null);
        assert (spec != null);
        assert (identPattern != null);
        this.kapiSpec = spec;
        String valueAsString = this.getValue();
        if (valueAsString == null) {
            throw new UnresolvedSpecItemException(this + " has no value specified.");
        }
        try {
            if (valueAsString.equals("(~0U)")) {
                this.resolvedValue = -1L;
            } else {
                Matcher m = intMaxMinusPattern.matcher(valueAsString);
                if (m.matches()) {
                    long subtracted = Long.parseLong(m.group(1));
                    this.resolvedValue = -1L - subtracted;
                } else if (valueAsString.equals("(~0ULL)")) {
                    this.resolvedValue = -1L;
                } else {
                    m = longLongMaxMinusPattern.matcher(valueAsString);
                    if (m.matches()) {
                        long subtracted = Long.parseLong(m.group(1));
                        this.resolvedValue = -1L - subtracted;
                    } else if (valueAsString.matches("^[0-9]+\\.0f?$")) {
                        this.resolvedValue = Double.valueOf(valueAsString).longValue();
                    } else if (valueAsString.startsWith("0x")) {
                        String hexValue = valueAsString.substring(2);
                        hexValue = hexValue.replace("u", "");
                        hexValue = hexValue.replace("l", "");
                        this.resolvedValue = new BigInteger(hexValue, 16).longValue();
                    } else {
                        m = shiftPattern.matcher(valueAsString);
                        if (m.matches()) {
                            int shift = Integer.parseInt(m.group(1));
                            this.resolvedValue = 1 << shift;
                        } else if (identPattern.matcher(valueAsString).matches()) {
                            AbstractConstantOrAliasSpecExtended referredConstant = resolvedMaps.constantMap.get(valueAsString);
                            if (referredConstant == null) {
                                throw new UnresolvedSpecItemException("Attempting to resolve " + valueAsString + " as an identifier, but none found.");
                            }
                            referredConstant.resolve(spec, resolvedMaps);
                            this.resolvedValue = referredConstant.getResolvedValue();
                        } else {
                            this.resolvedValue = Long.valueOf(valueAsString);
                        }
                    }
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new UnresolvedSpecItemException("Constant '" + this.getName() + "' has unreadable value '" + valueAsString + "'.");
        }
        assert (this.resolvedValue != null);
    }
}

