/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.extended;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AnonymousConstantSpec;
import com.arm.mgd.kapi.gen.ConstantRef;
import com.arm.mgd.kapi.gen.XConstantGroupSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class ConstantGroupSpec
extends XConstantGroupSpec
implements Iterable<AbstractConstantOrAliasSpecExtended> {
    private final @NonNull Map<Long, AbstractConstantOrAliasSpecExtended> localConstantMap = new HashMap<Long, AbstractConstantOrAliasSpecExtended>();
    private final @NonNull List<@NonNull AbstractConstantOrAliasSpecExtended> constants = new ArrayList<AbstractConstantOrAliasSpecExtended>();
    private KapiSpec kapiSpec;

    @Override
    public @NonNull Iterator<@NonNull AbstractConstantOrAliasSpecExtended> iterator() {
        return (Iterator)NullUtils.neverNull(this.constants.iterator());
    }

    public void resolve(KapiSpec spec) {
        this.kapiSpec = spec;
        for (ConstantRef constantSpecRef : this.getConstant()) {
            assert (constantSpecRef != null);
            AbstractConstantOrAliasSpecExtended ref = constantSpecRef.getRef();
            assert (ref != null);
            this.constants.add(ref);
            AbstractConstantOrAliasSpecExtended prev = this.localConstantMap.put(ref.getResolvedValue(), ref);
            if (prev == null) continue;
            CoreLogging.trace(null, this + ": Items with the same resolved value found: " + ref.getName() + " (prev: " + prev.getName() + ")");
        }
    }

    public String toString() {
        return "ConstantGroupSpec '" + this.name + "'";
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getConstantSpecByValue(@NonNull Long value) {
        AbstractConstantOrAliasSpecExtended c = this.localConstantMap.get(value);
        if (c != null) {
            return c;
        }
        if (this.kapiSpec != null) {
            return this.kapiSpec.getConstantSpecByValue(value);
        }
        return AnonymousConstantSpec.newConstant(value);
    }

    public boolean doesConstantExist(Long value) {
        return this.localConstantMap.get(value) != null;
    }

    @NonNull Map<Long, AbstractConstantOrAliasSpecExtended> getConstantMap() {
        return Collections.unmodifiableMap(this.localConstantMap);
    }

    public boolean contains(AbstractConstantOrAliasSpecExtended constantSpec) {
        return this.constants.contains(constantSpec);
    }

    public int size() {
        return this.constants.size();
    }
}

