/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.extended;

import com.arm.mgd.core.kapi.ISerializationProxy;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.kapi.UnresolvedSpecItemException;
import com.arm.mgd.kapi.extended.ConstantSpec;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class AnonymousConstantSpec
extends ConstantSpec {
    private static final Map<Long, AnonymousConstantSpec> anonymousConstantMap = new HashMap<Long, AnonymousConstantSpec>();
    private static final long serialVersionUID = 1408883668769448285L;

    public static @NonNull AnonymousConstantSpec newConstant(@NonNull Long value) {
        AnonymousConstantSpec c = anonymousConstantMap.get(value);
        if (c == null) {
            c = new AnonymousConstantSpec(value);
            anonymousConstantMap.put(c.getResolvedValue(), c);
        }
        return c;
    }

    private AnonymousConstantSpec(@NonNull Long value) {
        this.resolvedValue = value;
        this.value = value.toString();
        this.name = "<0x" + Long.toHexString(value) + ">";
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public void resolve(KapiSpec spec, KapiSpec.ResolvedMaps resolvedMaps) throws UnresolvedSpecItemException {
        assert (false) : "AnonymousConstantSpec.resolve should never be called";
    }

    @Override
    public void setName(String name) {
        assert (false) : "AnonymousConstantSpec.setName should never be called";
    }

    @Override
    public Object writeReplace() {
        return new AnonymousSerializationProxy(this);
    }

    private static class AnonymousSerializationProxy
    implements ISerializationProxy {
        private static final long serialVersionUID = 1408883668769448285L;
        private final Long resolvedValue;

        public AnonymousSerializationProxy(@NonNull AnonymousConstantSpec constantSpec) {
            this.resolvedValue = constantSpec.getResolvedValue();
        }

        @Override
        public Object readResolve() {
            return anonymousConstantMap.get(this.resolvedValue);
        }
    }
}

