/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.extended;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.state.StateId;
import com.arm.mgd.core.state.StateValue;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.FunctionSpec;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.gen.StateValueSpec;
import com.arm.mgd.kapi.gen.TargetBindingSpec;
import com.arm.mgd.kapi.gen.XAffectsStateSpec;
import java.io.Serializable;
import org.eclipse.jdt.annotation.Nullable;

public class AffectsStateSpec
extends XAffectsStateSpec {
    private transient StateValue[] defaultValue;
    private transient int[] argIndex;

    void resolve(FunctionSpec functionSpec) {
        int nValues = this.getValue().size();
        this.defaultValue = new StateValue[nValues];
        this.argIndex = new int[nValues];
        int i = 0;
        while (i < nValues) {
            StateValueSpec valueSpec = this.getValue().get(i);
            String literal = valueSpec.getLiteral();
            AbstractConstantOrAliasSpecExtended constant = valueSpec.getConstant();
            if (literal != null) {
                AbstractConstantOrAliasSpecExtended constantValue = functionSpec.getKapiSpec().getConstantSpecByName(literal);
                assert (false) : "You should use <constant> not <literal> for constant values (" + literal + ") in " + functionSpec.getName();
                this.defaultValue[i] = constantValue != null ? new StateValue(constantValue) : new StateValue(literal);
            } else if (constant != null) {
                this.defaultValue[i] = new StateValue(constant);
            } else {
                String argId = valueSpec.getArgId();
                assert (argId != null);
                this.argIndex[i] = functionSpec.getArgumentSpecByName(argId).getArgIndex();
            }
            ++i;
        }
    }

    public StateValue[] getAffectedStateValue(FunctionCall fc) {
        StateValue[] values = (StateValue[])this.defaultValue.clone();
        int i = 0;
        while (i < values.length) {
            if (values[i] == null) {
                Serializable newValue = fc.getArgValue(this.argIndex[i]);
                values[i] = new StateValue(newValue);
            }
            ++i;
        }
        return values;
    }

    public @Nullable StateSpec getAffectedStateSpec(FunctionCall fc) {
        IFunctionOrAliasSpecExtended functionSpec = fc.getFunctionSpec();
        if (this.key.getState() == null) {
            String argId = this.key.getArgId();
            assert (argId != null);
            ArgumentSpec argumentSpec = functionSpec.getArgumentSpecByName(argId);
            Serializable argument = fc.getArgValue(argumentSpec.getArgIndex());
            if (argument instanceof AbstractConstantOrAliasSpecExtended) {
                AbstractConstantOrAliasSpecExtended constant = (AbstractConstantOrAliasSpecExtended)argument;
                if (this.getTargetBindingGroup() != null) {
                    TargetBindingSpec binding = this.getTargetBindingGroup().getRef().getTargetBinding(constant);
                    if (binding != null) {
                        assert (binding.getState() != null) : "Missing state value for target " + constant + " in " + this.getTargetBindingGroup().getRef().getName();
                        return binding.getState();
                    }
                    if (this.getTargetBindingGroup().isMixed()) {
                        return functionSpec.getKapiSpec().getStateSpecByName(new StateId(constant, false));
                    }
                    return null;
                }
                return functionSpec.getKapiSpec().getStateSpecByName(new StateId(constant, false));
            }
        } else {
            return this.key.getState();
        }
        return null;
    }
}

