/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi.extended;

import com.arm.mgd.core.kapi.DuplicateSpecItemException;
import com.arm.mgd.core.kapi.ISerializationProxy;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.SerializableDependency;
import com.arm.mgd.core.util.NumberUtils;
import com.arm.mgd.core.util.NumberValueConverter;
import com.arm.mgd.core.util.UnsupportedTypeException;
import com.arm.mgd.kapi.AbstractConstantOrAliasSpec;
import com.arm.mgd.kapi.UnresolvedSpecItemException;
import com.arm.mgd.kapi.extended.BasicTypeSpec;
import com.arm.mgd.kapi.extended.ConstantAliasSpec;
import com.arm.mgd.kapi.extended.ConstantSpec;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractConstantOrAliasSpecExtended
extends AbstractConstantOrAliasSpec
implements Comparable<AbstractConstantOrAliasSpecExtended>,
SerializableDependency {
    private static final long serialVersionUID = -8937499041038744488L;
    protected transient @Nullable KapiSpec kapiSpec;

    public final int compareByName(AbstractConstantOrAliasSpecExtended other) {
        if (other == null) {
            return 1;
        }
        return this.getName().compareTo(other.getName());
    }

    public final @NonNull Number @Nullable [] createZeroNumberArray(int size) {
        BasicTypeSpec cType = this.getCtype();
        if (cType == null) {
            return null;
        }
        NumberValueConverter<?> converter = cType.getValueConverter();
        if (converter == null) {
            return null;
        }
        int nValues = this.getNumberOfRowsAsInt() * this.getNumberOfColumnsAsInt() * size;
        @NonNull Object @Nullable [] values = new Number[nValues];
        Arrays.fill(values, converter.zeroValue());
        return values;
    }

    public final @NonNull Number @NonNull [] getNumberArray(byte @NonNull [] bytes) throws UnsupportedTypeException {
        if (this.equals(KapiSpec.GLES.constants.GL_BYTE)) {
            return NumberUtils.getByteObjectsForBytesFromBytes(bytes);
        }
        if (this.equals(KapiSpec.GLES.constants.GL_FIXED)) {
            return NumberUtils.getDoubleObjectsForFixedFromBytes(bytes);
        }
        if (this.equals(KapiSpec.GLES.constants.GL_FLOAT)) {
            return NumberUtils.getFloatObjectsFromBytes(bytes);
        }
        if (this.equals(KapiSpec.GLES.constants.GL_HALF_FLOAT_OES) || this.equals(KapiSpec.GLES.constants.GL_HALF_FLOAT)) {
            return NumberUtils.getHalfFloatObjectsFromBytes(bytes);
        }
        if (this.equals(KapiSpec.GLES.constants.GL_INT)) {
            return NumberUtils.getIntegerObjectsForIntegersFromBytes(bytes);
        }
        if (this.equals(KapiSpec.GLES.constants.GL_INT_2_10_10_10_REV)) {
            return NumberUtils.getShortObjectsForInt_2_10_10_10FromBytes(bytes);
        }
        if (this.equals(KapiSpec.GLES.constants.GL_SHORT)) {
            return NumberUtils.getShortObjectsForShortsFromBytes(bytes);
        }
        if (this.equals(KapiSpec.GLES.constants.GL_UNSIGNED_BYTE)) {
            return NumberUtils.getShortObjectsForUnsignedBytesFromBytes(bytes);
        }
        if (this.equals(KapiSpec.GLES.constants.GL_UNSIGNED_INT)) {
            return NumberUtils.getLongObjectsForUnsignedIntsFromBytes(bytes);
        }
        if (this.equals(KapiSpec.GLES.constants.GL_UNSIGNED_INT_2_10_10_10_REV)) {
            return NumberUtils.getShortObjectsForUnsignedInt_2_10_10_10FromBytes(bytes);
        }
        if (this.equals(KapiSpec.GLES.constants.GL_UNSIGNED_SHORT)) {
            return NumberUtils.getIntegerObjectsForUnsignedShortsFromBytes(bytes);
        }
        throw new UnsupportedTypeException("Unknown type '" + this + "'.");
    }

    public final int getNumberOfColumnsAsInt() {
        Short nColumns = this.getNumberOfColumns();
        if (nColumns != null) {
            return nColumns.intValue();
        }
        return 1;
    }

    public final int getNumberOfRowsAsInt() {
        Short nValues = this.getNumberOfRows();
        if (nValues != null) {
            return nValues.intValue();
        }
        return 1;
    }

    public @NonNull Long getResolvedValue() {
        throw new UnsupportedOperationException("AbstractConstantOrAliasSpecExtended.getResolvedValue must be overriden");
    }

    public boolean isAnonymous() {
        throw new UnsupportedOperationException("AbstractConstantOrAliasSpecExtended.isAnonymous must be overriden");
    }

    public void resolve(KapiSpec spec, KapiSpec.ResolvedMaps resolvedMaps) throws UnresolvedSpecItemException {
        assert (false) : "AbstractConstantOrAliasSpecExtended.resolve must be overriden";
    }

    public void resolveConstantRefs(KapiSpec spec) throws DuplicateSpecItemException {
        assert (false) : "AbstractConstantOrAliasSpecExtended.resolveConstantRefs must be overriden";
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(AbstractConstantOrAliasSpecExtended o) {
        return this.getResolvedValue().compareTo(o.getResolvedValue());
    }

    @Override
    public Object writeReplace() {
        return new NamedSerializationProxy(this);
    }

    protected static class NamedSerializationProxy
    implements ISerializationProxy {
        private static final long serialVersionUID = -7121255783825130330L;
        private final @Nullable KapiSpec kapiSpec;
        private final String name;

        public NamedSerializationProxy(@NonNull AbstractConstantOrAliasSpecExtended constantSpec) {
            assert (constantSpec.getClass() == ConstantSpec.class || constantSpec.getClass() == ConstantAliasSpec.class);
            this.kapiSpec = constantSpec.kapiSpec;
            this.name = constantSpec.getName();
        }

        @Override
        public Object readResolve() {
            if (this.kapiSpec != null) {
                return this.kapiSpec.getConstantSpecByName(this.name);
            }
            return null;
        }
    }
}

