/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.kapi;

import com.arm.mgd.kapi.gen.Api;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class ApiXmlLoaderHelper {
    public static Api loadApi(String apiFilePath) {
        Throwable throwable;
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (InputStream is = ApiXmlLoaderHelper.class.getResourceAsStream(apiFilePath);){
                Api api;
                if (is != null && (api = ApiXmlLoaderHelper.resolve(ApiXmlLoaderHelper.loadApiSpec(is))) != null) {
                    return api;
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File apiFile = new File(ApiXmlLoaderHelper.getResourceRootPath(ApiXmlLoaderHelper.class), apiFilePath);
        if (apiFile.exists() && apiFile.isFile() && apiFile.canRead()) {
            try {
                throwable = null;
                Object var3_8 = null;
                try (FileInputStream is = new FileInputStream(apiFile);){
                    return ApiXmlLoaderHelper.resolve(ApiXmlLoaderHelper.loadApiSpec(is));
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Api resolve(Api api) {
        if (api != null) {
            api.resolve();
        }
        return api;
    }

    public static File getResourceRootPath(Class<?> context) {
        try {
            URL classesUrl = context.getResource(String.valueOf(context.getSimpleName()) + ".class");
            String className = context.getName();
            className = String.valueOf(className.replace('.', '/')) + ".class";
            className = classesUrl.toURI().toString().replace(className, "");
            File tlf = new File(new URI(className));
            File tlfParent = tlf.getParentFile();
            assert (tlfParent != null);
            return tlfParent.getParentFile();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return null;
        }
    }

    private static Api loadApiSpec(InputStream is) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)Api.class.getPackageName(), (ClassLoader)Api.class.getClassLoader());
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (Api)jaxbUnmarshaller.unmarshal(is);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            assert (false);
            return null;
        }
    }
}

